/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.component.model;

import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.component.model.ComponentVersionView;
import com.castsoftware.sca.scar.server.core.model.NamedView;
import com.castsoftware.sca.scar.server.kpi.model.CounterView;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import com.castsoftware.sca.util.java.Opt;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class ComponentView
extends NamedView {
    @JsonIgnore
    private final String bomId;
    private final Set<String> references = new HashSet();
    private final Set<String> topics = new HashSet();
    private final Set<String> languages = new HashSet();
    private final List<LightLicenseView> licenses = new ArrayList();
    private final List<VulnerabilityView> vulnerabilities = new ArrayList();
    private final Collection<ComponentVersionView> allVersions = new ArrayList();
    private Collection<FileView> files = new ArrayList();
    private String version;
    private String scaId;
    private String source;
    private String category;
    private String path;
    private String latestVersion;
    private String repository;
    private String repositoryType;
    private String description;
    private String comments;
    private String upToDate;
    private String copyright;
    private boolean modified;
    private CounterView counter;
    private String declaredBy;

    public ComponentView(String originalId, String id, String name, String bomId) {
        super(originalId, id, name);
        this.bomId = bomId;
    }

    public ComponentView(String originalId, String id, String name) {
        this(originalId, id, name, null);
    }

    public void addReference(String reference) {
        Opt.ofBlankString((String)reference).ifPresent(this.references::add);
    }

    public void addLicense(LightLicenseView license) {
        this.licenses.add(license);
    }

    public void addVulnerability(VulnerabilityView vulnerability) {
        this.vulnerabilities.add(vulnerability);
    }

    public void addTopic(String topic) {
        Opt.ofBlankString((String)topic).ifPresent(this.topics::add);
    }

    public void addLanguage(String language) {
        Opt.ofBlankString((String)language).ifPresent(this.languages::add);
    }

    public void setAllVersions(Collection<ComponentVersionView> versions) {
        Optional.ofNullable(versions).ifPresent(this.allVersions::addAll);
    }

    @Generated
    public String getBomId() {
        return this.bomId;
    }

    @Generated
    public Set<String> getReferences() {
        return this.references;
    }

    @Generated
    public Set<String> getTopics() {
        return this.topics;
    }

    @Generated
    public Set<String> getLanguages() {
        return this.languages;
    }

    @Generated
    public List<LightLicenseView> getLicenses() {
        return this.licenses;
    }

    @Generated
    public List<VulnerabilityView> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @Generated
    public Collection<ComponentVersionView> getAllVersions() {
        return this.allVersions;
    }

    @Generated
    public Collection<FileView> getFiles() {
        return this.files;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getScaId() {
        return this.scaId;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public String getRepository() {
        return this.repository;
    }

    @Generated
    public String getRepositoryType() {
        return this.repositoryType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public String getUpToDate() {
        return this.upToDate;
    }

    @Generated
    public String getCopyright() {
        return this.copyright;
    }

    @Generated
    public boolean isModified() {
        return this.modified;
    }

    @Generated
    public CounterView getCounter() {
        return this.counter;
    }

    @Generated
    public String getDeclaredBy() {
        return this.declaredBy;
    }

    @Generated
    public void setFiles(Collection<FileView> files) {
        this.files = files;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setScaId(String scaId) {
        this.scaId = scaId;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Generated
    public void setRepository(String repository) {
        this.repository = repository;
    }

    @Generated
    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Generated
    public void setUpToDate(String upToDate) {
        this.upToDate = upToDate;
    }

    @Generated
    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Generated
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Generated
    public void setCounter(CounterView counter) {
        this.counter = counter;
    }

    @Generated
    public void setDeclaredBy(String declaredBy) {
        this.declaredBy = declaredBy;
    }

    @Generated
    public String toString() {
        return "ComponentView(bomId=" + this.getBomId() + ", references=" + String.valueOf(this.getReferences()) + ", topics=" + String.valueOf(this.getTopics()) + ", languages=" + String.valueOf(this.getLanguages()) + ", licenses=" + String.valueOf(this.getLicenses()) + ", vulnerabilities=" + String.valueOf(this.getVulnerabilities()) + ", allVersions=" + String.valueOf(this.getAllVersions()) + ", files=" + String.valueOf(this.getFiles()) + ", version=" + this.getVersion() + ", scaId=" + this.getScaId() + ", source=" + this.getSource() + ", category=" + this.getCategory() + ", path=" + this.getPath() + ", latestVersion=" + this.getLatestVersion() + ", repository=" + this.getRepository() + ", repositoryType=" + this.getRepositoryType() + ", description=" + this.getDescription() + ", comments=" + this.getComments() + ", upToDate=" + this.getUpToDate() + ", copyright=" + this.getCopyright() + ", modified=" + this.isModified() + ", counter=" + String.valueOf(this.getCounter()) + ", declaredBy=" + this.getDeclaredBy() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentView)) {
            return false;
        }
        ComponentView other = (ComponentView)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isModified() != other.isModified()) {
            return false;
        }
        String this$bomId = this.getBomId();
        String other$bomId = other.getBomId();
        if (this$bomId == null ? other$bomId != null : !this$bomId.equals(other$bomId)) {
            return false;
        }
        Set this$references = this.getReferences();
        Set other$references = other.getReferences();
        if (this$references == null ? other$references != null : !((Object)this$references).equals(other$references)) {
            return false;
        }
        Set this$topics = this.getTopics();
        Set other$topics = other.getTopics();
        if (this$topics == null ? other$topics != null : !((Object)this$topics).equals(other$topics)) {
            return false;
        }
        Set this$languages = this.getLanguages();
        Set other$languages = other.getLanguages();
        if (this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages)) {
            return false;
        }
        List this$licenses = this.getLicenses();
        List other$licenses = other.getLicenses();
        if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
            return false;
        }
        List this$vulnerabilities = this.getVulnerabilities();
        List other$vulnerabilities = other.getVulnerabilities();
        if (this$vulnerabilities == null ? other$vulnerabilities != null : !((Object)this$vulnerabilities).equals(other$vulnerabilities)) {
            return false;
        }
        Collection this$allVersions = this.getAllVersions();
        Collection other$allVersions = other.getAllVersions();
        if (this$allVersions == null ? other$allVersions != null : !((Object)this$allVersions).equals(other$allVersions)) {
            return false;
        }
        Collection this$files = this.getFiles();
        Collection other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scaId = this.getScaId();
        String other$scaId = other.getScaId();
        if (this$scaId == null ? other$scaId != null : !this$scaId.equals(other$scaId)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$latestVersion = this.getLatestVersion();
        String other$latestVersion = other.getLatestVersion();
        if (this$latestVersion == null ? other$latestVersion != null : !this$latestVersion.equals(other$latestVersion)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$repositoryType = this.getRepositoryType();
        String other$repositoryType = other.getRepositoryType();
        if (this$repositoryType == null ? other$repositoryType != null : !this$repositoryType.equals(other$repositoryType)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
            return false;
        }
        String this$upToDate = this.getUpToDate();
        String other$upToDate = other.getUpToDate();
        if (this$upToDate == null ? other$upToDate != null : !this$upToDate.equals(other$upToDate)) {
            return false;
        }
        String this$copyright = this.getCopyright();
        String other$copyright = other.getCopyright();
        if (this$copyright == null ? other$copyright != null : !this$copyright.equals(other$copyright)) {
            return false;
        }
        CounterView this$counter = this.getCounter();
        CounterView other$counter = other.getCounter();
        if (this$counter == null ? other$counter != null : !this$counter.equals(other$counter)) {
            return false;
        }
        String this$declaredBy = this.getDeclaredBy();
        String other$declaredBy = other.getDeclaredBy();
        return !(this$declaredBy == null ? other$declaredBy != null : !this$declaredBy.equals(other$declaredBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentView;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isModified() ? 79 : 97);
        String $bomId = this.getBomId();
        result = result * 59 + ($bomId == null ? 43 : $bomId.hashCode());
        Set $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        Set $topics = this.getTopics();
        result = result * 59 + ($topics == null ? 43 : ((Object)$topics).hashCode());
        Set $languages = this.getLanguages();
        result = result * 59 + ($languages == null ? 43 : ((Object)$languages).hashCode());
        List $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        List $vulnerabilities = this.getVulnerabilities();
        result = result * 59 + ($vulnerabilities == null ? 43 : ((Object)$vulnerabilities).hashCode());
        Collection $allVersions = this.getAllVersions();
        result = result * 59 + ($allVersions == null ? 43 : ((Object)$allVersions).hashCode());
        Collection $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scaId = this.getScaId();
        result = result * 59 + ($scaId == null ? 43 : $scaId.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $latestVersion = this.getLatestVersion();
        result = result * 59 + ($latestVersion == null ? 43 : $latestVersion.hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $repositoryType = this.getRepositoryType();
        result = result * 59 + ($repositoryType == null ? 43 : $repositoryType.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        String $upToDate = this.getUpToDate();
        result = result * 59 + ($upToDate == null ? 43 : $upToDate.hashCode());
        String $copyright = this.getCopyright();
        result = result * 59 + ($copyright == null ? 43 : $copyright.hashCode());
        CounterView $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : $counter.hashCode());
        String $declaredBy = this.getDeclaredBy();
        result = result * 59 + ($declaredBy == null ? 43 : $declaredBy.hashCode());
        return result;
    }
}

