/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.component.handler;

import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.NamedVertex;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class OperationHandler {
    public static final Function<FileVertex, String> extensionMapper = vertex -> vertex.getName().lastIndexOf(46) > 0 ? vertex.getName().substring(vertex.getName().lastIndexOf(46) + 1) : "";
    public static final Function<FileVertex, String> pathMapper = vertex -> Optional.of(vertex.getPath()).filter(s -> s.length() > 1).map(s -> s.substring(0, s.length() - 1)).map(s -> s.substring(s.lastIndexOf(47))).orElse("/");
    public static final Function<FileVertex, String> licenseMapper = vertex -> vertex.getLicenses().stream().map(LicenseVertex::getSpdxId).sorted().collect(Collectors.joining(","));
    public static final Function<FileVertex, String> versionMapper = FileVertex::getVersion;

    public static List<LicenseVertex> mergeLicenses(List<ComponentVertex> components) {
        return components.stream().map(BomComponentVertex.class::cast).map(BomComponentVertex::getLicenses).flatMap(Collection::stream).filter(OperationHandler.distinct(LicenseVertex::getSpdxId)).collect(Collectors.toList());
    }

    public static List<VulnerabilityVertex> mergeVulnerabilities(List<ComponentVertex> components) {
        return components.stream().map(BomComponentVertex.class::cast).map(BomComponentVertex::getVulnerabilities).flatMap(Collection::stream).filter(OperationHandler.distinct(VulnerabilityVertex::getVId)).collect(Collectors.toList());
    }

    public static String mergeCopyright(List<ComponentVertex> components) {
        return components.stream().map(ComponentVertex::getCopyright).map(c -> Arrays.asList(c.split("\n"))).flatMap(Collection::stream).distinct().collect(Collectors.joining("\n"));
    }

    public static List<String> mergeLists(List<ComponentVertex> components, Function<ComponentVertex, List<String>> listSupplier) {
        return components.stream().map(listSupplier).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static Set<String> mergeSets(List<ComponentVertex> components, Function<ComponentVertex, Set<String>> setSupplier) {
        return components.stream().map(setSupplier).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static <T> T getUniqueOrDefault(List<ComponentVertex> components, Function<ComponentVertex, T> supplier, T defaultValue) {
        List values = components.stream().map(supplier).distinct().collect(Collectors.toList());
        return values.size() == 1 ? values.get(0) : defaultValue;
    }

    public static String createMergeComment(List<ComponentVertex> components) {
        return "Merge of components " + components.stream().map(NamedVertex::getName).collect(Collectors.joining(", "));
    }

    public static String createSplitComment(ComponentVertex component) {
        return "Split of component " + component.getName();
    }

    public static String recomputePath(Collection<FileVertex> files) {
        String prefix = StringUtils.getCommonPrefix((String[])((String[])files.stream().map(FileVertex::getPath).toArray(String[]::new)));
        return prefix.substring(0, prefix.lastIndexOf("/") + 1);
    }

    public static <T> Predicate<T> distinct(Function<? super T, ?> key) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(key.apply(t));
    }
}

