/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.component.handler;

import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.model.BomView;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.component.model.ComponentVersionView;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.component.model.DependencyView;
import com.castsoftware.sca.scar.server.component.model.FullComponentView;
import com.castsoftware.sca.scar.server.kpi.model.CounterView;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.transformer.LicenseTransformer;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaDependency;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaDependencyVersion;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.castsoftware.sca.scar.server.vulnerability.transformer.VulnerabilityTransformer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ComponentTransforms {
    public static ComponentView from(BomComponentVertex vertex, String bomId, Map<String, ComplianceLevel> complianceLevelMap) {
        ComponentView cv = ComponentTransforms.from((ComponentVertex)vertex, (ComponentView)ComponentTransforms.create((ComponentVertex)vertex, (String)bomId));
        vertex.getLicenses().stream().map(lv -> LicenseTransformer.fromLight((LicenseVertex)lv, (Map)complianceLevelMap)).forEach(arg_0 -> ((ComponentView)cv).addLicense(arg_0));
        vertex.getVulnerabilities().stream().map(VulnerabilityTransformer::fromLight).forEach(arg_0 -> ((ComponentView)cv).addVulnerability(arg_0));
        return cv;
    }

    public static ComponentView from(ComponentVertex vertex) {
        ComponentView cv = ComponentTransforms.from((ComponentVertex)vertex, (ComponentView)ComponentTransforms.create((ComponentVertex)vertex));
        return ComponentTransforms.addLicensesAndVulnerabilities((ComponentView)cv, (ComponentVertex)vertex, new HashMap());
    }

    public static FullComponentView from(ComponentVertex vertex, BomView bomView) {
        return ComponentTransforms.from((ComponentVertex)vertex, (BomView)bomView, new HashMap());
    }

    public static FullComponentView from(ComponentVertex vertex, BomView bomView, Map<String, ComplianceLevel> complianceLevelMap) {
        FullComponentView fcv = (FullComponentView)ComponentTransforms.from((ComponentVertex)vertex, (ComponentView)ComponentTransforms.create((ComponentVertex)vertex, (BomView)bomView));
        return (FullComponentView)ComponentTransforms.addLicensesAndVulnerabilities((ComponentView)fcv, (ComponentVertex)vertex, complianceLevelMap);
    }

    public static DependencyView to(ScaDependency scaDependency) {
        DependencyView dependencyView = new DependencyView();
        Optional.ofNullable(scaDependency).ifPresent(dependency -> {
            dependencyView.setName(dependency.getProjectName());
            dependencyView.setOptional(dependency.isOptional());
            dependencyView.setType(dependency.getType());
            dependencyView.setVersion(dependency.getMatchingVersions().stream().findFirst().map(ScaDependencyVersion::getName).orElseGet(() -> ((ScaDependency)dependency).getSemverExpression()));
        });
        return dependencyView;
    }

    private static ComponentView addLicensesAndVulnerabilities(ComponentView cv, ComponentVertex vertex, Map<String, ComplianceLevel> complianceLevelMap) {
        Optional.of(vertex).filter(BomComponentVertex.class::isInstance).map(BomComponentVertex.class::cast).map(BomComponentVertex::getLicenses).ifPresent(ll -> ll.stream().map(lv -> LicenseTransformer.fromLight((LicenseVertex)lv, (Map)complianceLevelMap)).forEach(arg_0 -> ((ComponentView)cv).addLicense(arg_0)));
        Optional.of(vertex).filter(BomComponentVertex.class::isInstance).map(BomComponentVertex.class::cast).map(BomComponentVertex::getVulnerabilities).ifPresent(lv -> lv.stream().map(VulnerabilityTransformer::fromLight).forEach(arg_0 -> ((ComponentView)cv).addVulnerability(arg_0)));
        return cv;
    }

    private static ComponentView from(ComponentVertex vertex, ComponentView cv) {
        Optional<ComponentVertex> oVertex = Optional.ofNullable(vertex);
        oVertex.orElseThrow(IllegalArgumentException::new);
        oVertex.map(ComponentVertex::getSource).ifPresent(arg_0 -> ((ComponentView)cv).setSource(arg_0));
        oVertex.map(ComponentVertex::getScaId).ifPresent(arg_0 -> ((ComponentView)cv).setScaId(arg_0));
        oVertex.map(ComponentVertex::getCategory).ifPresent(arg_0 -> ((ComponentView)cv).setCategory(arg_0));
        cv.setVersion(vertex.getVersion());
        vertex.getReferences().forEach(arg_0 -> ((ComponentView)cv).addReference(arg_0));
        cv.setAllVersions((Collection)vertex.getAllVersions().entrySet().stream().map(e -> ComponentVersionView.newInstance((String)((String)e.getKey()), (Long)((Long)e.getValue()))).collect(Collectors.toList()));
        cv.setCounter(CounterView.builder().files(vertex.countFiles()).snippets(vertex.countSnippets()).build());
        vertex.getTopics().forEach(arg_0 -> ((ComponentView)cv).addTopic(arg_0));
        vertex.getLanguages().forEach(arg_0 -> ((ComponentView)cv).addLanguage(arg_0));
        oVertex.map(ComponentVertex::getLastVersion).ifPresent(arg_0 -> ((ComponentView)cv).setLatestVersion(arg_0));
        oVertex.map(ComponentVertex::getPath).ifPresent(arg_0 -> ((ComponentView)cv).setPath(arg_0));
        oVertex.map(ComponentVertex::getRepository).ifPresent(arg_0 -> ((ComponentView)cv).setRepository(arg_0));
        oVertex.map(ComponentVertex::getRepoType).ifPresent(arg_0 -> ((ComponentView)cv).setRepositoryType(arg_0));
        oVertex.map(ComponentVertex::getDescription).ifPresent(arg_0 -> ((ComponentView)cv).setDescription(arg_0));
        oVertex.map(ComponentVertex::getComments).ifPresent(arg_0 -> ((ComponentView)cv).setComments(arg_0));
        oVertex.map(ComponentVertex::getUpToDate).ifPresent(arg_0 -> ((ComponentView)cv).setUpToDate(arg_0));
        oVertex.map(ComponentVertex::isModified).ifPresent(arg_0 -> ((ComponentView)cv).setModified(arg_0));
        oVertex.map(ComponentVertex::getCopyright).ifPresent(arg_0 -> ((ComponentView)cv).setCopyright(arg_0));
        return cv;
    }

    private static ComponentView create(ComponentVertex componentVertex) {
        return new ComponentView(componentVertex.getId(), VertexUtils.encodeId((Vertex)componentVertex), componentVertex.getName());
    }

    private static ComponentView create(ComponentVertex componentVertex, String bomId) {
        return new ComponentView(componentVertex.getId(), VertexUtils.encodeId((Vertex)componentVertex), componentVertex.getName(), bomId);
    }

    private static FullComponentView create(ComponentVertex componentVertex, BomView bomView) {
        return new FullComponentView(componentVertex.getId(), VertexUtils.encodeId((Vertex)componentVertex), componentVertex.getName(), bomView);
    }

    @Generated
    private ComponentTransforms() {
    }
}

