/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.component.handler;

import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ComponentSortHandler {
    public static Integer computeLicenseSortIndex(Collection<LicenseVertex> licenseVertices, Collection<BomLicenseVertex> bomLicenseVertices) {
        Map<String, ComplianceLevel> complianceBySpdxId = bomLicenseVertices.stream().collect(Collectors.toMap(LicenseVertex::getSpdxId, BomLicenseVertex::getComplianceLevel));
        return licenseVertices.stream().collect(Collectors.groupingBy(licenseVertex -> Optional.ofNullable((ComplianceLevel)complianceBySpdxId.get(licenseVertex.getSpdxId())).orElse(ComplianceLevel.UNKNOWN), Collectors.counting())).entrySet().stream().reduce(0, (total, entry) -> Math.toIntExact((long)((ComplianceLevel)entry.getKey()).getSortMultiplier() * Math.min((Long)entry.getValue(), 99L)) + total, Integer::sum);
    }

    public static Integer computeVulnerabilitySortIndex(Collection<VulnerabilityVertex> vulnerabilityVertices) {
        return vulnerabilityVertices.stream().collect(Collectors.groupingBy(vulnerabilityVertex -> Optional.ofNullable(vulnerabilityVertex.getSeverity()).map(VulnerabilityLevel::valueOf).orElse(VulnerabilityLevel.NONE), Collectors.counting())).entrySet().stream().reduce(0, (total, entry) -> Math.toIntExact((long)((VulnerabilityLevel)entry.getKey()).getSortMultiplier() * Math.min((Long)entry.getValue(), 99L)) + total, Integer::sum);
    }
}

