/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.component.dao;

import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.core.dao.FindConfiguration;
import com.castsoftware.sca.scar.server.core.dao.PaginationConfiguration;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectWhereStep;
import org.jooq.SortOrder;
import org.jooq.impl.DSL;

/*
 * Exception performing whole class analysis ignored.
 */
public class ComponentDao
extends GraphDao<ComponentVertex> {
    public ComponentDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)BOMClassDefinition.V.VComponent);
    }

    public void addLicense(ComponentVertex component, LicenseVertex license) {
        this.addLicense(component, license, null);
    }

    public void addLicense(ComponentVertex component, LicenseVertex license, ODatabaseSession session) {
        this.link((Vertex)component, (Vertex)license, (EClassDefinition)BOMClassDefinition.E.ELicense, session);
    }

    public void addVulnerability(ComponentVertex component, VulnerabilityVertex vulnerability) {
        this.addVulnerability(component, vulnerability, null);
    }

    public void addVulnerability(ComponentVertex component, VulnerabilityVertex vulnerability, ODatabaseSession session) {
        this.link((Vertex)component, (Vertex)vulnerability, (EClassDefinition)BOMClassDefinition.E.EVulnerability, session);
    }

    public void addFile(ComponentVertex component, FileVertex file) {
        this.addFile(component, file, null);
    }

    public void addFile(ComponentVertex component, FileVertex file, ODatabaseSession session) {
        this.link((Vertex)component, (Vertex)file, (EClassDefinition)BOMClassDefinition.E.EContains, session);
    }

    public void removeFile(ComponentVertex component, FileVertex file, ODatabaseSession session) {
        this.unlink((Vertex)component, (Vertex)file, (EClassDefinition)BOMClassDefinition.E.EContains, session);
    }

    public void addSnippet(ComponentVertex component, SnippetVertex snippet) {
        this.addSnippet(component, snippet, null);
    }

    public void addSnippet(ComponentVertex component, SnippetVertex snippet, ODatabaseSession session) {
        this.link((Vertex)component, (Vertex)snippet, (EClassDefinition)BOMClassDefinition.E.EDeclaredBy, session);
    }

    public void removeSnippet(ComponentVertex component, SnippetVertex snippet, ODatabaseSession session) {
        this.unlink((Vertex)component, (Vertex)snippet, (EClassDefinition)BOMClassDefinition.E.EDeclaredBy, session);
    }

    public Optional<BomComponentVertex> findByIdWithLV(String id) {
        return this.findByIdWithLV(id, null);
    }

    public Optional<BomComponentVertex> findByIdWithLV(String id, ODatabaseSession existingSession) {
        List projections = Stream.of(GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.ELicense.name(), BOMClassDefinition.V.VLicense.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.EVulnerability.name(), BOMClassDefinition.V.VVulnerability.name()})).collect(Collectors.toList());
        return this.queryComponentWithLicensesAndVulnerabilities(projections, id, existingSession);
    }

    public Optional<ComponentVertex> findByFile(String idFile) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EContains.name()});
        return this.listVertex(ComponentVertex::new, (Query)this.queryBuilder.selectFrom(ComponentDao.traverse((String)projection, (String)idFile)), new Object[]{BOMClassDefinition.V.VComponent.name()}).stream().findFirst();
    }

    public Optional<BomComponentVertex> findByFileWithLV(String idFile) {
        Collection projections = Stream.of(GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EContains.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.ELicense.name(), BOMClassDefinition.V.VLicense.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.EVulnerability.name(), BOMClassDefinition.V.VVulnerability.name()})).collect(Collectors.toList());
        return this.queryComponentWithLicensesAndVulnerabilities(projections, idFile, null);
    }

    public Optional<ComponentVertex> findBySnippet(String idSnippet) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EDeclaredBy.name()});
        return this.listVertex(ComponentVertex::new, (Query)this.queryBuilder.selectFrom(ComponentDao.traverse((String)projection, (String)idSnippet)), new Object[]{BOMClassDefinition.V.VComponent.name()}).stream().findFirst();
    }

    public void deleteFromBom(String bomVertexId) {
        String queryComponents = ComponentDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.ECategory.name()}), (String)bomVertexId, (Integer)100);
        Collection projections = Stream.of(GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EContains.name()}), GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EDeclaredBy.name()})).collect(Collectors.toList());
        SelectConditionStep query = this.queryBuilder.selectFrom(ComponentDao.traverse((Collection)projections, (String)queryComponents, (Integer)100)).where(GraphDao.MetaFields.clazz.ne((Object)BOMClassDefinition.V.VBom.name()));
        this.execute(arg_0 -> ComponentDao.lambda$deleteFromBom$0((Query)query, arg_0));
    }

    public Collection<BomComponentVertex> findBomComponents(String bomId) {
        return this.findBomComponents(bomId, null, null);
    }

    public Collection<BomComponentVertex> findBomComponents(String bomId, String categoryRef) {
        return this.findBomComponents(bomId, categoryRef, null);
    }

    public Collection<BomComponentVertex> findBomComponents(String bomId, String categoryRef, FindConfiguration findConfiguration) {
        String componentProjection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.ECategory.name(), BOMClassDefinition.V.VComponent.name()});
        SelectWhereStep bomComponentByCategory = this.queryBuilder.selectFrom(ComponentDao.traverse((String)componentProjection, (String)Guards.notBlank((String)bomId), (Integer)5));
        Opt.ofBlankString((String)categoryRef).map(arg_0 -> ((Field)Fields.CATEGORY).eq(arg_0)).ifPresent(arg_0 -> ((SelectWhereStep)bomComponentByCategory).where(arg_0));
        Optional<FindConfiguration> fc = Optional.ofNullable(findConfiguration);
        fc.map(FindConfiguration::getSort).filter(sc -> Objects.nonNull(sc.getSort()) && !sc.getSort().isEmpty()).map(sc -> sc.getSort().stream().map(s -> DSL.field((String)s).sort(sc.isAscend() ? SortOrder.ASC : SortOrder.DESC)).collect(Collectors.toList())).ifPresent(arg_0 -> ((SelectWhereStep)bomComponentByCategory).orderBy(arg_0));
        String finalBomComponentByCategory = fc.map(FindConfiguration::getPagination).filter(p -> p.getLimit() > 0).map(this.paginate(bomComponentByCategory)).orElse(bomComponentByCategory.toString());
        String addedRelatedLink = ComponentDao.traverse((Collection)Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE.value(new String[]{BOMClassDefinition.E.ELicense.name()}), GraphDao.TraverseType.OUT_DEFINED_EDGE.value(new String[]{BOMClassDefinition.E.EVulnerability.name()})).collect(Collectors.toList()), (String)"(".concat(finalBomComponentByCategory).concat(")"), (Integer)5);
        String addedRelated = ComponentDao.traverse((String)GraphDao.TraverseType.IN_VERTEX.value(new String[0]), (String)addedRelatedLink, (Integer)5);
        return (Collection)this.query(session -> {
            ArrayList components = new ArrayList();
            HashMap idLicense = new HashMap();
            HashMap idVulnerability = new HashMap();
            HashMap componentIdLicenseIds = new HashMap();
            HashMap componentIdVulnerabilityIds = new HashMap();
            session.query(this.queryBuilder.selectFrom(addedRelated).toString(), new Object[0]).forEachRemaining(oResult -> {
                if (oResult.isVertex()) {
                    Optional<OVertexDocument> vertexDocument = oResult.getVertex().map(OVertexDocument.class::cast);
                    Vertex vertex = vertexDocument.map(ODocument::getClassName).map(Functions.forwardThrowable(BOMClassDefinition.V::valueOf)).map(v -> v.newInstance((OVertexDocument)vertexDocument.get())).map(Vertex.class::cast).orElseThrow(IllegalStateException::new);
                    switch (1.$SwitchMap$com$castsoftware$sca$scar$server$bom$structure$BOMClassDefinition$V[((BOMClassDefinition.V)vertex.definition()).ordinal()]) {
                        case 1: {
                            idLicense.put(vertex.getORID(), (LicenseVertex)vertex);
                            break;
                        }
                        case 2: {
                            idVulnerability.put(vertex.getORID(), (VulnerabilityVertex)vertex);
                            break;
                        }
                        case 3: {
                            components.add((ComponentVertex)vertex);
                            break;
                        }
                    }
                } else {
                    oResult.getEdge().ifPresent(edge -> {
                        ORID componentId = edge.getFrom().getIdentity();
                        if (this.checkEdgeType(edge, (EClassDefinition)BOMClassDefinition.E.ELicense)) {
                            List licenses = Optional.ofNullable((List)componentIdLicenseIds.get(componentId)).orElseGet(ArrayList::new);
                            licenses.add(edge.getTo().getIdentity());
                            componentIdLicenseIds.put(componentId, licenses);
                        }
                        if (this.checkEdgeType(edge, (EClassDefinition)BOMClassDefinition.E.EVulnerability)) {
                            List vulnerabilities = Optional.ofNullable((List)componentIdVulnerabilityIds.get(componentId)).orElseGet(ArrayList::new);
                            vulnerabilities.add(edge.getTo().getIdentity());
                            componentIdVulnerabilityIds.put(componentId, vulnerabilities);
                        }
                    });
                }
            });
            return components.stream().map(componentVertex -> new BomComponentVertex(componentVertex, (Collection)Optional.ofNullable((List)componentIdLicenseIds.get(componentVertex.getORID())).map(l -> l.stream().map(idLicense::get).map(Optional::ofNullable).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElseGet(ArrayList::new), (Collection)Optional.ofNullable((List)componentIdVulnerabilityIds.get(componentVertex.getORID())).map(l -> l.stream().map(idVulnerability::get).map(Optional::ofNullable).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElseGet(ArrayList::new))).collect(Collectors.toList());
        });
    }

    public void updateCategoryLink(ComponentVertex component, String categoryReference, ODatabaseSession existingSession) {
        this.execute(session -> {
            String traverse = ComponentDao.traverse((String)GraphDao.TraverseType.IN_DEFINED_EDGE.value(new String[]{BOMClassDefinition.E.ECategory.name()}), (String)component.getId());
            List all = session.query(this.queryBuilder.selectFrom(traverse).toString(), new Object[0]).edgeStream().filter(oEdge -> oEdge.getSchemaType().map(OClass::getName).filter(BOMClassDefinition.E.ECategory.name()::equals).isPresent()).collect(Collectors.toList());
            if (all.size() != 1) {
                throw new IllegalStateException();
            }
            OEdge category = (OEdge)all.get(0);
            category.setProperty("ref", (Object)categoryReference);
            session.save((Object)category);
        }, existingSession);
    }

    public List<ComponentVertex> findByLink(String fromId, BOMClassDefinition.V fromType, BOMClassDefinition.E typeLink) {
        return this.findByLink(fromId, fromType, typeLink, null);
    }

    public List<ComponentVertex> findByLink(String fromId, BOMClassDefinition.V fromType, BOMClassDefinition.E typeLink, ODatabaseSession existingSession) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{typeLink.name()});
        return this.listVertex(existingSession, ComponentVertex::new, (Query)this.queryBuilder.selectFrom(ComponentDao.traverse((String)projection, (String)fromId)), new Object[]{fromType.name()}).stream().filter(c -> !c.getId().equals(fromId)).collect(Collectors.toList());
    }

    public Long countByBom(String bomId) {
        return (Long)this.query(session -> {
            String traverseComponent = ComponentDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.ECategory.name()}), (String)bomId);
            String query = this.queryBuilder.select((SelectField)DSL.count().as("count")).from(traverseComponent).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VComponent.name())).toString();
            return session.query(query, new Object[0]).stream().filter(r -> r.hasProperty("count")).map(r -> r.getProperty("count")).map(Long.class::cast).findFirst().orElse(-1L);
        });
    }

    public void deleteFiles(ComponentVertex componentVertex, ODatabaseSession existingSession) {
        String traverseFiles = ComponentDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EContains.name()}), (String)componentVertex.getId());
        SelectConditionStep deleteSubQuery = this.queryBuilder.selectFrom(traverseFiles).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VFile.name()));
        this.execute(arg_0 -> ComponentDao.lambda$deleteFiles$18((Query)deleteSubQuery, arg_0), existingSession);
    }

    public void deleteSnippets(ComponentVertex componentVertex, ODatabaseSession existingSession) {
        String traverseFiles = ComponentDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EDeclaredBy.name()}), (String)componentVertex.getId());
        SelectConditionStep deleteSubQuery = this.queryBuilder.selectFrom(traverseFiles).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VSnippet.name()));
        this.execute(arg_0 -> ComponentDao.lambda$deleteSnippets$19((Query)deleteSubQuery, arg_0), existingSession);
    }

    public void getSnippetInfos(ComponentVertex componentVertex, ODatabaseSession existingSession) {
        String traverseFiles = ComponentDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EDeclaredBy.name()}), (String)componentVertex.getId());
        SelectConditionStep deleteSubQuery = this.queryBuilder.selectFrom(traverseFiles).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VSnippet.name()));
        this.execute(arg_0 -> ComponentDao.lambda$getSnippetInfos$20((Query)deleteSubQuery, arg_0), existingSession);
    }

    private Function<PaginationConfiguration, String> paginate(SelectWhereStep<?> query) {
        return paginationConfiguration -> String.format("%s SKIP %d", query.limit((Number)paginationConfiguration.getLimit()).toString(), paginationConfiguration.getStartAt());
    }

    private Optional<BomComponentVertex> queryComponentWithLicensesAndVulnerabilities(Collection<String> projections, String idFrom, ODatabaseSession existingSession) {
        return (Optional)this.query(session -> {
            AtomicReference component = new AtomicReference();
            ArrayList licenses = new ArrayList();
            ArrayList vulnerabilities = new ArrayList();
            session.query(this.queryBuilder.selectFrom(ComponentDao.traverse((Collection)projections, (String)idFrom)).toString(), new Object[0]).vertexStream().map(OVertexDocument.class::cast).map(v -> BOMClassDefinition.V.valueOf((String)v.getClassName()).newInstance(v)).forEach(v -> {
                if (v instanceof ComponentVertex) {
                    component.set((ComponentVertex)v);
                } else if (v instanceof LicenseVertex) {
                    licenses.add((LicenseVertex)v);
                } else if (v instanceof VulnerabilityVertex) {
                    vulnerabilities.add((VulnerabilityVertex)v);
                }
            });
            return Optional.of(component).map(AtomicReference::get).map(cv -> new BomComponentVertex(cv, (Collection)licenses, (Collection)vulnerabilities));
        }, existingSession);
    }

    private static /* synthetic */ void lambda$getSnippetInfos$20(Query deleteSubQuery, ODatabaseSession session) {
        session.command(ComponentDao.deleteVertex((Query)deleteSubQuery), new Object[0]).close();
    }

    private static /* synthetic */ void lambda$deleteSnippets$19(Query deleteSubQuery, ODatabaseSession session) {
        session.command(ComponentDao.deleteVertex((Query)deleteSubQuery), new Object[0]).close();
    }

    private static /* synthetic */ void lambda$deleteFiles$18(Query deleteSubQuery, ODatabaseSession session) {
        session.command(ComponentDao.deleteVertex((Query)deleteSubQuery), new Object[0]).close();
    }

    private static /* synthetic */ void lambda$deleteFromBom$0(Query query, ODatabaseSession session) {
        session.command(ComponentDao.deleteVertex((Query)query), new Object[0]).close();
    }
}

