/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.transformer;

import com.castsoftware.sca.scar.server.bom.domain.VersionInfo;
import com.castsoftware.sca.scar.server.bom.model.VersionView;
import com.castsoftware.sca.scar.server.kpi.transformer.KpiTransformer;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.Normalizes;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VersionTransformers {
    public static @NonNull VersionView from(OEdge version) {
        Optional<OEdge> oVersion = Optional.ofNullable(version);
        String id = oVersion.map(ORecord::getIdentity).map(ORID::toString).orElseThrow(IllegalArgumentException::new);
        return new VersionView(id, Normalizes.encodeBase64((String)id), oVersion.filter(e -> e.getPropertyNames().contains("name")).map(e -> (String)e.getProperty("name")).orElse("Unknown version"));
    }

    public static @NonNull VersionView from(VersionInfo version) {
        VersionView view = new VersionView(version.getId(), Normalizes.encodeBase64((String)version.getId()), version.getName());
        Optional.ofNullable(version.getBom()).ifPresent(bom -> {
            view.setBomId(VertexUtils.encodeId((Vertex)bom));
            view.setCreated(Long.valueOf(bom.getCreated().toEpochMilli()));
            view.setUpdated(Long.valueOf(bom.getUpdated().toEpochMilli()));
            view.setStep(bom.getReviewStep());
        });
        Optional.ofNullable(version.getLicensePolicy()).map(VertexUtils::encodeId).ifPresent(arg_0 -> ((VersionView)view).setLicensePolicy(arg_0));
        Optional.ofNullable(version.getKpi()).map(KpiTransformer::countersFrom).ifPresent(arg_0 -> ((VersionView)view).setCounter(arg_0));
        return view;
    }

    @Generated
    private VersionTransformers() {
    }
}

