/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.transformer;

import com.castsoftware.sca.scar.server.bom.domain.BomBuild;
import com.castsoftware.sca.scar.server.bom.model.build.BomBuildBaseView;
import com.castsoftware.sca.scar.server.bom.model.build.BomBuildMonitorView;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressPhase;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStatus;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStep;
import com.castsoftware.sca.scar.server.monitoring.handler.ProgressMonitor;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Guards;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Builds {
    public static @NonNull BomBuildBaseView base(@NonNull BomBuild build) {
        BomBuildBaseView view = new BomBuildBaseView(build.getId(), build.getId());
        view.setProduct(build.getConfiguration().getProduct());
        view.setProject(build.getConfiguration().getProject());
        view.setVersion(build.getConfiguration().getVersion());
        build.getBuilt().map(VertexUtils::encodeId).ifPresent(arg_0 -> ((BomBuildBaseView)view).setBomId(arg_0));
        view.setSuccess(build.getMonitor().getErrors().isEmpty());
        return view;
    }

    public static @NonNull BomBuildMonitorView monitor(BomBuild build) {
        Guards.notNull((Object)build);
        BomBuildMonitorView view = new BomBuildMonitorView(build.getId(), build.getId());
        view.setProduct(build.getConfiguration().getProduct());
        view.setProject(build.getConfiguration().getProject());
        view.setVersion(build.getConfiguration().getVersion());
        Optional.of(build).map(BomBuild::getMonitor).map(Functions.peek(m -> view.setProgression(Double.valueOf(m.getPercent())))).map(ProgressMonitor::getPhases).map(Functions.peek(ps -> view.setPhases((Collection)ps.stream().sorted(Comparator.comparing(o -> Optional.ofNullable(o).map(ProgressPhase::getType).map(build.getMonitor().getPhaseSequence()::indexOf).orElse(-1))).map(ProgressPhase::getTitle).collect(Collectors.toCollection(LinkedList::new))))).flatMap(ps -> ps.stream().filter(p -> ProgressStatus.RUNNING.equals((Object)p.getStatus())).findFirst()).map(Functions.peek(p -> view.setPhase(p.getTitle()))).flatMap(p -> p.getSteps().stream().filter(s -> ProgressStatus.RUNNING.equals((Object)s.getStatus())).findFirst()).map(ProgressStep::getTitle).ifPresent(arg_0 -> ((BomBuildMonitorView)view).setStep(arg_0));
        return view;
    }
}

