/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.transformer;

import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.FileFilter;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PreviousScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.ScaScanOptions;
import com.castsoftware.sca.scar.server.bom.model.request.BomBuildRequest;
import com.castsoftware.sca.scar.server.bom.transformer.BomBuildTransformer;
import com.castsoftware.sca.scar.server.util.Normalizes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BomBuildTransformer {
    public static BomBuildRequest from(BomWizardConfiguration configuration) {
        BomBuildRequest buildRequest = new BomBuildRequest();
        buildRequest.setProduct(configuration.getProduct());
        buildRequest.setProject(configuration.getProject());
        buildRequest.setVersion(configuration.getVersion());
        buildRequest.setLicensePolicy(configuration.getLicensePolicy());
        BomBuildRequest.SourceConfiguration sourceConfiguration = new BomBuildRequest.SourceConfiguration();
        sourceConfiguration.setType(configuration.getSourceType().name());
        sourceConfiguration.setOptions(configuration.getSourceOptions());
        switch (1.$SwitchMap$com$castsoftware$sca$scar$server$analyzer$BomWizardConfiguration$SourceType[configuration.getSourceType().ordinal()]) {
            case 1: {
                sourceConfiguration.setFolderId(Normalizes.encodeBase64URL((String)configuration.getSourcePath()));
                break;
            }
            case 2: 
            case 3: {
                sourceConfiguration.setFileId(Normalizes.encodeBase64URL((String)configuration.getSourcePath()));
                break;
            }
            case 4: {
                sourceConfiguration.setUrlId(Normalizes.encodeBase64URL((String)configuration.getSourcePath()));
                break;
            }
            case 5: {
                sourceConfiguration.setFileId("");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown source type");
            }
        }
        Optional.ofNullable(configuration.getFileOptions()).ifPresent(fo -> {
            Optional.ofNullable(fo.getFilters()).ifPresent(ff -> {
                BomBuildRequest.FilterConfiguration filterConfiguration = new BomBuildRequest.FilterConfiguration();
                filterConfiguration.setType(ff.isInclude() ? FileFilter.FilterType.INCLUDE.name() : FileFilter.FilterType.EXCLUDE.name());
                filterConfiguration.setLines(BomBuildTransformer.extractLineFilter((FileFilter)ff));
                sourceConfiguration.setFilters(filterConfiguration);
            });
            Optional.ofNullable(fo.getExceptions()).ifPresent(fe -> {
                BomBuildRequest.FilterConfiguration exceptionConfiguration = new BomBuildRequest.FilterConfiguration();
                exceptionConfiguration.setLines(BomBuildTransformer.extractLineFilter((FileFilter)fe));
                sourceConfiguration.setExceptions(exceptionConfiguration);
            });
        });
        buildRequest.setSource(sourceConfiguration);
        BomBuildRequest.ScannersConfiguration scannersConfiguration = new BomBuildRequest.ScannersConfiguration();
        scannersConfiguration.setPackages(new BomBuildRequest.PackageScannerConfiguration());
        scannersConfiguration.getPackages().setEnabled(configuration.isUsePackage());
        Optional.of(configuration).filter(BomWizardConfiguration::isUsePackage).ifPresent(config -> {
            scannersConfiguration.getPackages().setEnabled(true);
            scannersConfiguration.getPackages().setOptions(Optional.of(config).map(BomWizardConfiguration::getPackageOptions).map(PackageScanOptions::getPackageOptions).orElse(Collections.emptyList()).stream().map(packageOption -> {
                BomBuildRequest.PackageEntryConfiguration pec = new BomBuildRequest.PackageEntryConfiguration();
                pec.setType(packageOption.getType());
                pec.setSearch(packageOption.getSearch().name());
                pec.setFile(packageOption.getFile());
                pec.setAllowExternal(packageOption.isAllowExternal());
                return pec;
            }).collect(Collectors.toList()));
        });
        scannersConfiguration.setOnlyPackage(configuration.isOnlyPackage());
        scannersConfiguration.setCatalog(new BomBuildRequest.ScannerConfiguration());
        scannersConfiguration.getCatalog().setEnabled(configuration.isUseCatalog());
        scannersConfiguration.setPrevious(new BomBuildRequest.PreviousScannerConfiguration());
        scannersConfiguration.getPrevious().setEnabled(false);
        Optional.of(configuration).filter(BomWizardConfiguration::isUsePrevious).ifPresent(config -> {
            scannersConfiguration.getPrevious().setEnabled(true);
            scannersConfiguration.getPrevious().setPreviousId(Optional.of(config).map(BomWizardConfiguration::getPreviousOptions).map(PreviousScanOptions::getPreviousId).orElseThrow(IllegalStateException::new));
        });
        scannersConfiguration.setSca(new BomBuildRequest.SCAScannerConfiguration());
        scannersConfiguration.getSca().setEnabled(false);
        Optional.of(configuration).filter(BomWizardConfiguration::isUseSca).ifPresent(config -> {
            scannersConfiguration.getSca().setEnabled(true);
            scannersConfiguration.getSca().setLevel(Optional.of(config).map(BomWizardConfiguration::getScaOptions).map(ScaScanOptions::getScaLevel).orElse(ScaScanOptions.ScaLevelType.FULL_DETECT).name());
        });
        buildRequest.setScanners(scannersConfiguration);
        return buildRequest;
    }

    private static List<BomBuildRequest.LineFilterConfiguration> extractLineFilter(FileFilter fileFilter) {
        ArrayList<BomBuildRequest.LineFilterConfiguration> lineFilters = new ArrayList<BomBuildRequest.LineFilterConfiguration>();
        fileFilter.getLineFilters().forEach((k, vl) -> vl.forEach(v -> {
            BomBuildRequest.LineFilterConfiguration lfc = new BomBuildRequest.LineFilterConfiguration();
            lfc.setKey(k.name());
            lfc.setValue(FileFilter.deregexize((String)String.valueOf(v)));
            lineFilters.add(lfc);
        }));
        return lineFilters;
    }
}

