/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx;

import com.castsoftware.sca.scar.server.bom.service.export.utils.ArrayUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.ColorUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.TextUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.CellData;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.RowData;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.TableColumn;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.wp.usermodel.HeaderFooterType;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.AxisTickMark;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xddf.usermodel.text.XDDFTextRun;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.Document;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJcTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJcTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;

public class DocxPoiUtils {
    private static final int MAX_LINE_LENGTH = 70;
    private final TextUtils textUtils;
    private final ArrayUtils arrayUtils;
    private final FilesUtils filesUtils;
    private static final CTBoolean FALSE = (CTBoolean)CTBoolean.Factory.newInstance();

    public DocxPoiUtils(TextUtils textUtils, ArrayUtils arrayUtils, FilesUtils filesUtils) {
        this.textUtils = textUtils;
        this.arrayUtils = arrayUtils;
        this.filesUtils = filesUtils;
    }

    public XWPFTable initNewTable(List<TableColumn> tableColumns, List<RowData> rowDataList, XWPFDocument document, String font, boolean pctWidthValue) {
        int rowsCount = rowDataList.size();
        if (tableColumns != null) {
            ++rowsCount;
        }
        XWPFTable table = document.createTable(rowsCount, rowDataList.get(0).getCellDatas().size());
        if (tableColumns != null) {
            int index = 0;
            for (TableColumn column : tableColumns) {
                XWPFTableCell cell = table.getRow(0).getCell(index);
                cell.setText(column.getTitle());
                cell.setWidth(String.valueOf(column.getWidth()));
                cell.setWidthType(TableWidthType.DXA);
                cell.getParagraphArray(0).setWordWrapped(index != 0);
                cell.getParagraphArray(0).setSpacingAfter(0);
                cell.getParagraphArray(0).setAlignment(column.getAlignment());
                XWPFRun run = (XWPFRun)cell.getParagraphArray(0).getRuns().get(0);
                run.setFontFamily(font);
                run.setColor("FFFFFF");
                run.setBold(true);
                cell.setColor("4AA3DF");
                ++index;
            }
        }
        this.addRows(table, rowDataList, tableColumns, font, pctWidthValue);
        this.configBaseTable(table);
        return table;
    }

    private void addRows(XWPFTable table, List<RowData> rowDataList, List<TableColumn> tableColumns, String font, boolean pctWidthValue) {
        int rowIndex = 0;
        if (tableColumns != null) {
            rowIndex = 1;
        }
        for (RowData data : rowDataList) {
            int cellIndex = 0;
            for (int i = 0; i < data.getCellDatas().size(); ++i) {
                CellData cellData = (CellData)data.getCellDatas().get(i);
                XWPFTableCell cell = table.getRow(rowIndex).getCell(cellIndex);
                if (pctWidthValue) {
                    cell.setWidth(cellData.getCellWidth().intValue() * 100 / 5000 + "%");
                    cell.setWidthType(TableWidthType.PCT);
                    if (cell.getParagraphArray(0) != null) {
                        cell.getParagraphArray(0).setWordWrapped(false);
                    }
                } else {
                    cell.setWidth(String.valueOf(cellData.getCellWidth()));
                    cell.setWidthType(TableWidthType.DXA);
                    if (cell.getParagraphArray(0) != null) {
                        cell.getParagraphArray(0).setWordWrapped(true);
                    }
                }
                cell.setText(cellData.getCellText());
                cell.getParagraphArray(0).setSpacingAfter(0);
                cell.getParagraphArray(0).setAlignment(cellData.getCellAlignment());
                XWPFRun run = (XWPFRun)cell.getParagraphArray(0).getRuns().get(0);
                run.setFontFamily(font);
                run.setBold(cellData.isBold());
                if (StringUtils.isNotEmpty((CharSequence)cellData.getCellColor())) {
                    cell.setColor(cellData.getCellColor());
                    run.setColor("FFFFFF");
                } else {
                    cell.setColor("FFFFFF");
                    if (StringUtils.isNotEmpty((CharSequence)cellData.getTextColor())) {
                        run.setColor(cellData.getTextColor());
                    } else {
                        run.setColor("000000");
                    }
                }
                ++cellIndex;
            }
            ++rowIndex;
        }
    }

    public RowData create2CellsRowData(String rowTitle, String value, int firstCellWidth, String firstCellColor, String cell2TextColor, boolean cell2TextBold) {
        ArrayList<CellData> cellDataList = new ArrayList<CellData>();
        cellDataList.add(new CellData(rowTitle, BigInteger.valueOf(firstCellWidth), firstCellColor, null, true, ParagraphAlignment.LEFT));
        cellDataList.add(new CellData(value, BigInteger.valueOf(5000 - firstCellWidth), null, cell2TextColor, cell2TextBold, ParagraphAlignment.LEFT));
        return new RowData(cellDataList);
    }

    public void addLineBreaks(XWPFDocument document, int number) {
        XWPFParagraph lineBreak = document.createParagraph();
        XWPFRun lineBreakRun = lineBreak.createRun();
        lineBreakRun.setFontSize(10);
        for (int i = 0; i < number; ++i) {
            lineBreakRun.addBreak(BreakType.TEXT_WRAPPING);
        }
    }

    public XWPFRun createParagraphWithoutSpacing(XWPFTable table, String text, int rowNumber, int cellNumber, String font) {
        XWPFParagraph para;
        String[] textElements;
        StringBuilder cutText = new StringBuilder();
        for (String element : textElements = text.split(" ")) {
            if (element.length() > 70) {
                cutText.append(this.textUtils.splitByLengthAndConcatWithSpaces(element, 70));
                continue;
            }
            cutText.append(" ").append(element);
        }
        XWPFTableCell cell = table.getRow(rowNumber).getCell(cellNumber);
        if (cell.getParagraphs().size() == 1) {
            para = cell.getParagraphArray(0);
            if (para.getRuns().isEmpty()) {
                para.createRun();
            }
        } else {
            para = cell.addParagraph();
            para.createRun();
        }
        XWPFRun run = (XWPFRun)para.getRuns().get(0);
        run.setText(cutText.toString().trim());
        run.setFontFamily(font);
        run.setFontSize(11);
        para.setSpacingAfter(0);
        para.setSpacingBefore(0);
        return run;
    }

    public void setTablesJunction(XWPFDocument document, int spaceHeight) {
        this.setASpacingLine(document, spaceHeight);
    }

    public void addLineBreak(XWPFDocument document) {
        this.setASpacingLine(document, 240);
    }

    private void setASpacingLine(XWPFDocument document, int height) {
        XWPFParagraph spacingPara = document.createParagraph();
        this.setSingleLineSpacing(spacingPara, height);
    }

    private void setSingleLineSpacing(XWPFParagraph para, int height) {
        CTPPr ppr = para.getCTP().getPPr();
        if (ppr == null) {
            ppr = para.getCTP().addNewPPr();
        }
        CTSpacing spacing = ppr.isSetSpacing() ? ppr.getSpacing() : ppr.addNewSpacing();
        spacing.setAfter((Object)BigInteger.valueOf(0L));
        spacing.setBefore((Object)BigInteger.valueOf(0L));
        spacing.setLineRule(STLineSpacingRule.AUTO);
        spacing.setLine((Object)BigInteger.valueOf(height));
    }

    public void noElementToWrite(XWPFDocument document, String elementName) {
        XWPFParagraph message = document.createParagraph();
        message.createRun().setText("No " + elementName.toLowerCase() + " found");
        message.setAlignment(ParagraphAlignment.CENTER);
    }

    public void pageBreak(XWPFDocument document) {
        XWPFParagraph paragraph = document.createParagraph();
        paragraph.setSpacingBefore(0);
        paragraph.setSpacingAfter(0);
        paragraph.createRun().addBreak(BreakType.PAGE);
    }

    public void createCell(XWPFTableRow row, int cellNumber, String cellText, String cellColor, String cellWidth, String textColor, boolean bold, boolean centerValue, String font) {
        XWPFTableCell cell = row.getCell(cellNumber);
        XWPFParagraph para = cell.getParagraphArray(0) != null ? cell.getParagraphArray(0) : cell.addParagraph();
        XWPFRun run = para.createRun();
        para.setWordWrapped(false);
        run.setText(cellText);
        run.setColor(textColor);
        if (bold) {
            run.setBold(true);
        } else {
            run.setFontFamily(font);
        }
        cell.setColor(cellColor);
        cell.getParagraphArray(0).setSpacingAfter(0);
        cell.setWidth(cellWidth + "%");
        if (centerValue) {
            cell.getParagraphArray(0).setAlignment(ParagraphAlignment.CENTER);
        }
    }

    public void setParagraphColor(XWPFParagraph paragraph) {
        if (paragraph.getCTP().getPPr() == null) {
            paragraph.getCTP().addNewPPr();
        }
        if (paragraph.getCTP().getPPr().getShd() != null) {
            paragraph.getCTP().getPPr().unsetShd();
        }
        paragraph.getCTP().getPPr().addNewShd();
        paragraph.getCTP().getPPr().getShd().setVal(STShd.CLEAR);
        paragraph.getCTP().getPPr().getShd().setColor((Object)"auto");
        paragraph.getCTP().getPPr().getShd().setFill((Object)"4AA3DF");
    }

    public void setTransparentTableBorder(XWPFTable table) {
        table.setBottomBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, null);
        table.setTopBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, null);
        table.setRightBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, null);
        table.setLeftBorder(XWPFTable.XWPFBorderType.NONE, 0, 0, null);
        table.removeInsideHBorder();
        table.removeInsideVBorder();
    }

    public void setTableCellBorderNone(XWPFTableCell cell, String border) {
        CTTcBorders tcBorders;
        CTTc tc = cell.getCTTc();
        CTTcPr tcPr = tc.getTcPr();
        if (tcPr == null) {
            tcPr = tc.addNewTcPr();
        }
        if ((tcBorders = tcPr.getTcBorders()) == null) {
            tcBorders = tcPr.addNewTcBorders();
        }
        if ("TOP".equals(border)) {
            CTBorder top = tcBorders.getTop();
            if (top == null) {
                top = tcBorders.addNewTop();
            }
            top.setVal(STBorder.NIL);
        } else if ("BOTTOM".equals(border)) {
            CTBorder bottom = tcBorders.getBottom();
            if (bottom == null) {
                bottom = tcBorders.addNewBottom();
            }
            bottom.setVal(STBorder.NIL);
        } else if ("LEFT".equals(border)) {
            CTBorder left = tcBorders.getLeft();
            if (left == null) {
                left = tcBorders.addNewLeft();
            }
            left.setVal(STBorder.NIL);
        } else if ("RIGHT".equals(border)) {
            CTBorder right = tcBorders.getRight();
            if (right == null) {
                right = tcBorders.addNewRight();
            }
            right.setVal(STBorder.NIL);
        }
    }

    public void createHeader(XWPFDocument document, String product, String project, String version, String author, String exportTitle, String exportDate, String font) {
        XWPFHeader head = document.createHeader(HeaderFooterType.DEFAULT);
        XWPFTable headTable = head.createTable(2, 3);
        head.insertTable(0, headTable);
        this.configBaseTable(headTable);
        this.setTableAlign(headTable, ParagraphAlignment.CENTER);
        head.createParagraph();
        headTable.getRow(0).getCell(0).setText(this.textUtils.limitedHeaderText(author, font));
        headTable.getRow(0).getCell(1).setText(exportTitle);
        headTable.getRow(0).getCell(2).setText(exportDate);
        headTable.getRow(1).getCell(0).setText(this.textUtils.limitedHeaderText(product, font));
        headTable.getRow(1).getCell(1).setText(this.textUtils.limitedHeaderText(project, font));
        headTable.getRow(1).getCell(2).setText(this.textUtils.limitedHeaderText(version, font));
        headTable.getRows().forEach(row -> {
            row.setHeight(30);
            row.getTableCells().forEach(tc -> {
                tc.setColor("FFFFFF");
                tc.setWidth("33%");
                ((XWPFRun)tc.getParagraphArray(0).getRuns().get(0)).setFontFamily(font);
                tc.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
                tc.getParagraphArray(0).setVerticalAlignment(TextAlignment.AUTO);
                tc.getParagraphArray(0).setAlignment(ParagraphAlignment.CENTER);
                tc.getParagraphArray(0).setSpacingAfter(0);
            });
        });
        ((XWPFRun)headTable.getRow(0).getCell(1).getParagraphArray(0).getRuns().get(0)).setBold(true);
        ((XWPFRun)headTable.getRow(0).getCell(1).getParagraphArray(0).getRuns().get(0)).setFontFamily(font + " Bold");
        if (headTable.getCTTbl().getTblGrid() == null) {
            headTable.getCTTbl().addNewTblGrid();
        }
        for (int i = 0; i < 3; ++i) {
            headTable.getCTTbl().getTblGrid().addNewGridCol();
        }
    }

    public void setTableAlign(XWPFTable table, ParagraphAlignment align) {
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        CTJcTable jc = tblPr.isSetJc() ? tblPr.getJc() : tblPr.addNewJc();
        STJcTable.Enum en = STJcTable.Enum.forInt((int)align.getValue());
        jc.setVal(en);
    }

    public void createFooter(XWPFDocument document, String castIconFileName, String footerCopyright, String font) throws IOException, InvalidFormatException {
        int cellNumber;
        XWPFFooter foot = document.createFooter(HeaderFooterType.DEFAULT);
        XWPFTable footTable = foot.createTable(1, cellNumber = 3);
        if (footTable.getCTTbl().getTblGrid() == null) {
            footTable.getCTTbl().addNewTblGrid();
        }
        for (int i = 0; i < cellNumber; ++i) {
            footTable.getCTTbl().getTblGrid().addNewGridCol();
        }
        this.configBaseTable(footTable);
        this.setTransparentTableBorder(footTable);
        footTable.getRow(0).getCell(0).setText("");
        footTable.getRow(0).getCell(0).getParagraphArray(0).setAlignment(ParagraphAlignment.LEFT);
        FileInputStream fis = this.filesUtils.loadCastIcon();
        XWPFRun run = footTable.getRow(0).getCell(0).getParagraphArray(0).createRun();
        run.addPicture((InputStream)fis, Document.PICTURE_TYPE_PNG, castIconFileName, Units.toEMU((double)80.0), Units.toEMU((double)18.0));
        footTable.getRow(0).getCell(1).setText(footerCopyright);
        footTable.getRow(0).getCell(1).getParagraphArray(0).setAlignment(ParagraphAlignment.CENTER);
        footTable.getRow(0).getCell(2).setText("Page  ");
        footTable.getRow(0).getCell(2).getParagraphArray(0).setAlignment(ParagraphAlignment.RIGHT);
        footTable.getRow(0).getCell(2).getParagraphArray(0).createRun();
        CTSimpleField ctSimpleField = footTable.getRow(0).getCell(2).getParagraphArray(0).getCTP().addNewFldSimple();
        ctSimpleField.setInstr("PAGE");
        ctSimpleField.setInstr(ctSimpleField.getInstr().replaceAll("^0", ""));
        footTable.getRow(0).getCell(2).getParagraphArray(0).createRun().setText("  of  ");
        footTable.getRow(0).getCell(2).getParagraphArray(0).createRun();
        CTSimpleField ctSimpleField3 = footTable.getRow(0).getCell(2).getParagraphArray(0).getCTP().addNewFldSimple();
        ctSimpleField3.setInstr("NUMPAGES");
        ctSimpleField3.setInstr(ctSimpleField3.getInstr().replaceAll("^0", ""));
        footTable.getRows().forEach(row -> {
            row.setHeight(30);
            row.getTableCells().forEach(tc -> {
                ((XWPFRun)tc.getParagraphArray(0).getRuns().get(0)).setFontFamily(font);
                tc.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
                tc.getParagraphArray(0).setVerticalAlignment(TextAlignment.AUTO);
                tc.getParagraphArray(0).setSpacingAfter(0);
            });
        });
        footTable.getRow(0).getCell(0).setWidth("33%");
        footTable.getRow(0).getCell(1).setWidth("33%");
        footTable.getRow(0).getCell(2).setWidth("33%");
    }

    public XWPFTable initTable(XWPFDocument document, int rows, int cells) {
        XWPFTable table = document.createTable(rows, cells);
        this.configBaseTable(table);
        return table;
    }

    private void configBaseTable(XWPFTable table) {
        table.setCellMargins(0, 0, 0, 0);
        table.setWidth("100%");
        table.setTableAlignment(TableRowAlign.CENTER);
    }

    public void createBarChart(XWPFDocument document, String chartTitle, String[] categoriesList, Double[] values, boolean logarithmicScale, String logarithmicMessage, String[] colors, BarDirection barDirection, int height, boolean categoriesLabelsRotation, boolean upValues, boolean pageBreak, String font) {
        XWPFChart chart;
        XDDFCategoryAxis bottomAxis;
        if (pageBreak) {
            this.pageBreak(document);
        }
        if (logarithmicScale) {
            this.createParagraph(logarithmicMessage, document, 7, false, true, ParagraphAlignment.LEFT, font, false);
        }
        if ((bottomAxis = (chart = this.initChart(document, chartTitle, height)).createCategoryAxis(AxisPosition.BOTTOM)).hasNumberFormat()) {
            bottomAxis.setNumberFormat("@");
        }
        bottomAxis.setMajorTickMark(AxisTickMark.NONE);
        chart.setTitleOverlay(false);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        leftAxis.setCrosses(AxisCrosses.MIN);
        leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        if (logarithmicScale) {
            leftAxis.setLogBase(2.0);
        }
        XDDFCategoryDataSource categories = XDDFDataSourcesFactory.fromArray((String[])categoriesList);
        Number[] clonedValues = this.arrayUtils.cloneArrayAndUp1Values(values, upValues);
        XDDFNumericalDataSource numeric = XDDFDataSourcesFactory.fromArray((Number[])clonedValues);
        XDDFChartData data = this.createChartData(chart, bottomAxis, leftAxis);
        XDDFChartData.Series series = data.addSeries((XDDFDataSource)categories, numeric);
        series.setTitle("series1", null);
        chart.plot(data);
        XDDFBarChartData barData = (XDDFBarChartData)data;
        barData.setBarDirection(barDirection);
        if (colors != null) {
            int pointCount = series.getCategoryData().getPointCount();
            for (int p = 0; p < pointCount; ++p) {
                CTBarSer barSeries = chart.getCTChart().getPlotArea().getBarChartArray(0).getSerArray(0);
                barSeries.addNewDPt().addNewIdx().setVal((long)p);
                barSeries.getDPtArray(p).addNewSpPr().addNewSolidFill().addNewSrgbClr().setVal(ColorUtils.safeDecodeHex((String)colors[p]));
            }
        } else {
            data.setVaryColors(Boolean.valueOf(true));
        }
        if (barDirection == BarDirection.COL && categoriesLabelsRotation) {
            bottomAxis.getOrAddTextProperties();
            chart.getCTChart().getPlotArea().getCatAxArray(0).getTxPr().getBodyPr().setRot(-4230000);
        }
    }

    public XWPFParagraph createParagraph(String content, XWPFDocument document, int fontSize, boolean isBold, boolean isItalic, ParagraphAlignment align, String font, boolean removeSpacingAfter) {
        XWPFParagraph para = document.createParagraph();
        if (removeSpacingAfter) {
            para.setSpacingAfter(15);
        }
        para.setAlignment(align);
        XWPFRun run = para.createRun();
        run.setText(content);
        run.setFontSize(fontSize);
        run.setFontFamily(font);
        run.setBold(isBold);
        run.setItalic(isItalic);
        return para;
    }

    private XDDFChartData createChartData(XWPFChart chart, XDDFCategoryAxis bottomAxis, XDDFValueAxis leftAxis) {
        return chart.createData(ChartTypes.BAR, (XDDFChartAxis)bottomAxis, leftAxis);
    }

    public void createPieChart(XWPFDocument document, String chartTitle, Double[] values, String[] labels, String[] colors) {
        XWPFChart chart = this.initChart(document, chartTitle, 3500000);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(LegendPosition.BOTTOM);
        XDDFCategoryDataSource categories = XDDFDataSourcesFactory.fromArray((String[])labels);
        XDDFNumericalDataSource numeric = XDDFDataSourcesFactory.fromArray((Number[])values);
        XDDFChartData data = chart.createData(ChartTypes.DOUGHNUT, null, null);
        data.addSeries((XDDFDataSource)categories, numeric);
        XDDFShapeProperties sp1 = new XDDFShapeProperties();
        data.getSeries(0).setShapeProperties(sp1);
        chart.plot(data);
        XDDFChartData.Series series = data.getSeries(0);
        if (colors != null) {
            int pointCount = series.getCategoryData().getPointCount();
            for (int p = 0; p < pointCount; ++p) {
                chart.getCTChart().getPlotArea().getDoughnutChartArray(0).getSerArray(0).addNewDPt().addNewIdx().setVal((long)p);
                chart.getCTChart().getPlotArea().getDoughnutChartArray(0).getSerArray(0).getDPtArray(p).addNewSpPr().addNewSolidFill().addNewSrgbClr().setVal(ColorUtils.safeDecodeHex((String)colors[p]));
            }
        } else {
            data.setVaryColors(Boolean.valueOf(true));
        }
        CTDLbls dLBls = chart.getCTChart().getPlotArea().getDoughnutChartArray(0).getSerArray(0).addNewDLbls();
        dLBls.addNewShowVal().setVal(false);
        dLBls.addNewShowLegendKey().setVal(false);
        dLBls.addNewShowCatName().setVal(false);
        dLBls.addNewShowSerName().setVal(false);
        dLBls.addNewShowPercent().setVal(false);
    }

    private XWPFChart initChart(XWPFDocument document, String chartTitle, int height) {
        XWPFChart chart;
        try {
            chart = document.createChart(5940000, height);
        }
        catch (IOException | InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        chart.setTitleText(chartTitle);
        ((XDDFTextRun)chart.getTitle().getBody().getParagraph(0).getTextRuns().get(0)).setFontSize(Double.valueOf(15.0));
        ((XDDFTextRun)chart.getTitle().getBody().getParagraph(0).getTextRuns().get(0)).setBold(Boolean.valueOf(false));
        chart.setTitleOverlay(false);
        chart.getCTChartSpace().setRoundedCorners(FALSE);
        return chart;
    }

    public void setListLinksInTableCell(XWPFTable table, List<String> list, int rowNumber, String font) {
        table.getRow(rowNumber).getCell(1).removeParagraph(0);
        if (CollectionUtils.isNotEmpty(list)) {
            for (String element : list) {
                if (element.length() > 70) {
                    this.createParagraphHyperLink(table, element, element.substring(0, 70) + "...", rowNumber, font);
                    continue;
                }
                this.createParagraphHyperLink(table, element, element, rowNumber, font);
            }
        }
    }

    public void createChapter(XWPFDocument document, String chapterName, boolean startInNewPage, String font) {
        if (startInNewPage) {
            this.pageBreak(document);
        }
        XWPFParagraph componentPara = document.createParagraph();
        componentPara.setAlignment(ParagraphAlignment.CENTER);
        this.setParagraphColor(componentPara);
        componentPara.setSpacingAfter(0);
        componentPara.setVerticalAlignment(TextAlignment.CENTER);
        XWPFRun title = componentPara.createRun();
        title.setText(chapterName);
        title.setFontSize(15);
        title.setColor("FFFFFF");
        title.setFontFamily(font);
        this.addLineBreak(document);
    }

    public void createUserMessage(XWPFDocument document, String message, String font) {
        XWPFParagraph para = document.createParagraph();
        para.createRun();
        ((XWPFRun)para.getRuns().get(0)).setText(message);
        ((XWPFRun)para.getRuns().get(0)).setColor("4AA3DF");
        ((XWPFRun)para.getRuns().get(0)).setFontFamily(font);
        ((XWPFRun)para.getRuns().get(0)).setFontSize(8);
        ((XWPFRun)para.getRuns().get(0)).setItalic(true);
        this.setASpacingLine(document, 20);
    }

    public void createParagraphHyperLink(XWPFTable table, String linkUrl, String linkText, int rowNumber, String font) {
        XWPFParagraph para = table.getRow(rowNumber).getCell(1).addParagraph();
        para.setSpacingAfter(0);
        para.setSpacingBefore(0);
        XWPFHyperlinkRun linkRunRefText = this.createHyperlinkRun(para, linkUrl);
        linkRunRefText.setText(linkText.replace("%3C", "<").replace("%3E", ">"));
        linkRunRefText.setColor("4AA3DF");
        linkRunRefText.setBold(false);
        linkRunRefText.setFontSize(10);
        linkRunRefText.setFontFamily(font);
    }

    public XWPFHyperlinkRun createHyperlinkRun(XWPFParagraph paragraph, String uri) {
        String rId = paragraph.getDocument().getPackagePart().addExternalRelationship(uri, XWPFRelation.HYPERLINK.getRelation()).getId();
        CTHyperlink cthyperLink = paragraph.getCTP().addNewHyperlink();
        cthyperLink.setId(rId);
        cthyperLink.addNewR();
        return new XWPFHyperlinkRun(cthyperLink, cthyperLink.getRArray(0), (IRunBody)paragraph);
    }

    public void addSeparationLine(XWPFDocument document) {
        XWPFParagraph spacingPara = document.createParagraph();
        this.setSingleLineSpacing(spacingPara, 240);
        XWPFRun run = spacingPara.createRun();
        run.setBold(false);
        run.setFontSize(5);
        run.setColor("7F7F7F");
        run.setText("______________________________________________________________________________________");
        spacingPara.setAlignment(ParagraphAlignment.CENTER);
        XWPFParagraph spacingPara2 = document.createParagraph();
        this.setSingleLineSpacing(spacingPara2, 240);
    }

    public XWPFDocument createWordDoc(FileInputStream loadDocxBaseFile) throws IOException {
        return new XWPFDocument((InputStream)loadDocxBaseFile);
    }

    static {
        FALSE.setVal(false);
    }
}

