/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.utils.poi;

import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.XlsxPoiUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.AxisTickMark;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;

public class XlsxPoiUtils {
    private static final String FONT = "Calibri";
    private static final CTBoolean FALSE = (CTBoolean)CTBoolean.Factory.newInstance();

    public void drawXlsxBarChart(Sheet sheet, int firstRowIndex, String title, Function<String, byte[]> colors) {
        this.drawXlsxBarChart(sheet, firstRowIndex, title, colors, BarDirection.BAR);
    }

    public void drawXlsxColChart(Sheet sheet, int firstRowIndex, String title, Function<String, byte[]> colors) {
        this.drawXlsxBarChart(sheet, firstRowIndex, title, colors, BarDirection.COL);
    }

    public void drawXlsxBarChart(Sheet sheet, int firstRowIndex, String title, Function<String, byte[]> colors, BarDirection barDirection) {
        XSSFDrawing drawing = ((XSSFSheet)sheet).createDrawingPatriarch();
        XSSFClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 4, firstRowIndex, 12, firstRowIndex + 14);
        XSSFChart chart = drawing.createChart(anchor);
        chart.setTitleText(title);
        chart.setTitleOverlay(false);
        chart.getCTChartSpace().setRoundedCorners(FALSE);
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
        if (bottomAxis.hasNumberFormat()) {
            bottomAxis.setNumberFormat("@");
        }
        bottomAxis.setMajorTickMark(AxisTickMark.NONE);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
        leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        leftAxis.setLogBase(2.0);
        XDDFCategoryDataSource categories = XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)((XSSFSheet)sheet), (CellRangeAddress)new CellRangeAddress(firstRowIndex + 1, sheet.getLastRowNum(), 1, 1));
        XDDFNumericalDataSource values = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)((XSSFSheet)sheet), (CellRangeAddress)new CellRangeAddress(firstRowIndex + 1, sheet.getLastRowNum(), 2, 2));
        XDDFChartData data = chart.createData(ChartTypes.BAR, (XDDFChartAxis)bottomAxis, leftAxis);
        XDDFChartData.Series series = data.addSeries((XDDFDataSource)categories, values);
        series.setTitle("series1", null);
        chart.plot(data);
        XDDFBarChartData bar = (XDDFBarChartData)data;
        bar.setBarDirection(barDirection);
        CTChart ctChart = chart.getCTChart();
        if (ctChart.getAutoTitleDeleted() == null) {
            ctChart.addNewAutoTitleDeleted();
        }
        ctChart.setAutoTitleDeleted(FALSE);
        if (colors != null) {
            int pointCount = series.getCategoryData().getPointCount();
            for (int p = 0; p < pointCount; ++p) {
                CTBarSer barSeries = ctChart.getPlotArea().getBarChartArray(0).getSerArray(0);
                barSeries.addNewDPt().addNewIdx().setVal((long)p);
                barSeries.getDPtArray(p).addNewSpPr().addNewSolidFill().addNewSrgbClr().setVal(colors.apply((String)categories.getPointAt(p)));
            }
        } else {
            bar.setVaryColors(Boolean.valueOf(true));
        }
    }

    public void drawXlsxPieChart(Sheet sheet, int firstRowIndex, String title) {
        XSSFDrawing drawing = ((XSSFSheet)sheet).createDrawingPatriarch();
        XSSFClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 4, firstRowIndex, 12, firstRowIndex + 14);
        XSSFChart chart = drawing.createChart(anchor);
        chart.setTitleText(title);
        chart.setTitleOverlay(false);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(LegendPosition.BOTTOM);
        chart.getCTChartSpace().setRoundedCorners(FALSE);
        XDDFCategoryDataSource categories = XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)((XSSFSheet)sheet), (CellRangeAddress)new CellRangeAddress(firstRowIndex + 1, sheet.getLastRowNum(), 1, 1));
        XDDFNumericalDataSource values = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)((XSSFSheet)sheet), (CellRangeAddress)new CellRangeAddress(firstRowIndex + 1, sheet.getLastRowNum(), 2, 2));
        XDDFChartData data = chart.createData(ChartTypes.DOUGHNUT, null, null);
        data.setVaryColors(Boolean.valueOf(true));
        data.addSeries((XDDFDataSource)categories, values);
        chart.plot(data);
    }

    public void writeRiskyValue(Row row, String value, Function<String, IndexedColors> colorMapper) {
        Cell cell = this.initCell(row, value);
        Font font = this.getRiskFont(cell, colorMapper.apply(value));
        CellUtil.setCellStyleProperties((Cell)cell, Collections.singletonMap("font", font.getIndex()));
    }

    public void applyBaseStyle(Cell cell) {
        Font font = this.getBaseFont(cell, false);
        CellUtil.setCellStyleProperties((Cell)cell, Collections.singletonMap("font", font.getIndex()));
    }

    public void applyItalicSmallStyle(Cell cell) {
        Font font = this.getItalicSmallFont(cell);
        CellUtil.setCellStyleProperties((Cell)cell, Collections.singletonMap("font", font.getIndex()));
    }

    public void applyTableHeaderStyle(Cell cell) {
        Font font = this.getBaseFont(cell, true);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("borderBottom", BorderStyle.MEDIUM);
        properties.put("font", font.getIndex());
        CellUtil.setCellStyleProperties((Cell)cell, properties);
    }

    public void applyHeaderStyle(Cell cell) {
        Font font = this.getBaseFont(cell, true);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("borderBottom", BorderStyle.MEDIUM);
        properties.put("fillForegroundColor", IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        properties.put("fillPattern", FillPatternType.SOLID_FOREGROUND);
        properties.put("font", font.getIndex());
        CellUtil.setCellStyleProperties((Cell)cell, properties);
    }

    private Font getBaseFont(Cell cell, boolean bold) {
        HashMap<FontProperty, Object> fontProperties = new HashMap<FontProperty, Object>();
        fontProperties.put(FontProperty.FONT_NAME, FONT);
        fontProperties.put(FontProperty.FONT_HEIGHT, (short)240);
        fontProperties.put(FontProperty.BOLD, bold);
        return this.getFont(cell.getSheet().getWorkbook(), this.getFont(cell), fontProperties);
    }

    private Font getItalicSmallFont(Cell cell) {
        HashMap<FontProperty, Object> fontProperties = new HashMap<FontProperty, Object>();
        fontProperties.put(FontProperty.FONT_NAME, FONT);
        fontProperties.put(FontProperty.FONT_HEIGHT, (short)160);
        fontProperties.put(FontProperty.ITALIC, true);
        return this.getFont(cell.getSheet().getWorkbook(), this.getFont(cell), fontProperties);
    }

    public void createHeader(Row header, String h) {
        Cell cell = this.initCell(header, h);
        this.applyHeaderStyle(cell);
    }

    public void writeCellValue(Row row, String value) {
        Cell cell = this.initCell(row, value);
        this.applyBaseStyle(cell);
    }

    public <T> void writeCellValueForVulnerability(Row row, String severity, T value, Function<T, IndexedColors> colorMapper) {
        Cell cell = this.createCustomCell(row);
        XSSFRichTextString richTextString = new XSSFRichTextString(severity);
        Font font = this.getRiskFont(cell, colorMapper.apply(value));
        richTextString.applyFont(font);
        cell.setCellValue((RichTextString)richTextString);
    }

    private Cell initCell(Row row, String value) {
        Cell cell = this.createCustomCell(row);
        cell.setCellValue(value);
        return cell;
    }

    public <T> void writeRiskyValues(Row row, Collection<T> values, Function<T, String> mapper, Function<T, IndexedColors> colorMapper) {
        Cell cell = this.createCustomCell(row);
        String licensesAsString = values.stream().map(mapper).collect(Collectors.joining(" | "));
        XSSFRichTextString richTextString = new XSSFRichTextString(licensesAsString);
        int startIndex = 0;
        int i = 0;
        for (T value : values) {
            int end = startIndex + mapper.apply(value).length();
            Font font = this.getRiskFont(cell, colorMapper.apply(value));
            richTextString.applyFont(startIndex, end, font);
            startIndex = end + (i < values.size() - 1 ? 3 : 0);
            ++i;
        }
        cell.setCellValue((RichTextString)richTextString);
    }

    public Font getRiskFont(Cell cell, IndexedColors color) {
        HashMap<FontProperty, Object> fontProperties = new HashMap<FontProperty, Object>();
        fontProperties.put(FontProperty.FONT_NAME, FONT);
        fontProperties.put(FontProperty.FONT_HEIGHT, (short)240);
        fontProperties.put(FontProperty.BOLD, true);
        fontProperties.put(FontProperty.COLOR, color.getIndex());
        return this.getFont(cell.getSheet().getWorkbook(), this.getFont(cell), fontProperties);
    }

    private Font getFont(Cell cell) {
        Workbook wb = cell.getRow().getSheet().getWorkbook();
        CellStyle style = cell.getCellStyle();
        return wb.getFontAt(style.getFontIndex());
    }

    private Font getFont(Workbook wb, Font source, Map<FontProperty, Object> properties) {
        boolean isBold = source.getBold();
        short color = source.getColor();
        short fontHeight = source.getFontHeight();
        String fontName = source.getFontName();
        boolean isItalic = source.getItalic();
        boolean isStrikeout = source.getStrikeout();
        short typeOffset = source.getTypeOffset();
        byte underline = source.getUnderline();
        for (FontProperty property : properties.keySet()) {
            switch (property.ordinal()) {
                case 0: {
                    isBold = (Boolean)properties.get(property);
                    break;
                }
                case 1: {
                    color = (Short)properties.get(property);
                    break;
                }
                case 2: {
                    fontHeight = (Short)properties.get(property);
                    break;
                }
                case 3: {
                    fontName = (String)properties.get(property);
                    break;
                }
                case 4: {
                    isItalic = (Boolean)properties.get(property);
                    break;
                }
                case 5: {
                    isStrikeout = (Boolean)properties.get(property);
                    break;
                }
                case 6: {
                    typeOffset = (Short)properties.get(property);
                    break;
                }
                case 7: {
                    underline = (Byte)properties.get(property);
                }
            }
        }
        Font font = wb.findFont(isBold, color, fontHeight, fontName, isItalic, isStrikeout, typeOffset, underline);
        if (font == null) {
            font = wb.createFont();
            font.setBold(isBold);
            font.setColor(color);
            font.setFontHeight(fontHeight);
            font.setFontName(fontName);
            font.setItalic(isItalic);
            font.setStrikeout(isStrikeout);
            font.setTypeOffset(typeOffset);
            font.setUnderline(underline);
        }
        return font;
    }

    private Cell createCustomCell(Row row) {
        short nextIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        return row.createCell((int)nextIndex);
    }

    public void writeTable(Sheet sheet, int firstRowIndex, String categoryAxisLabel, String valueAxisLabel, Map<String, Number> data, boolean logarithmicScale, String logarithmicScaleMessage) {
        Row row = sheet.createRow(firstRowIndex);
        Cell cell = row.createCell(1);
        cell.setCellValue(categoryAxisLabel);
        this.applyTableHeaderStyle(cell);
        cell = row.createCell(2);
        cell.setCellValue(valueAxisLabel);
        this.applyTableHeaderStyle(cell);
        data.forEach((category, value) -> {
            Row r = sheet.createRow(sheet.getLastRowNum() + 1);
            Cell c = r.createCell(1);
            c.setCellValue(category);
            this.applyBaseStyle(c);
            c = r.createCell(2);
            c.setCellValue(value.doubleValue());
            this.applyBaseStyle(c);
        });
        IntStream.range(0, 5).forEach(arg_0 -> ((Sheet)sheet).autoSizeColumn(arg_0));
        if (logarithmicScale) {
            Cell cell2 = row.createCell(12);
            cell2.setCellValue("   " + logarithmicScaleMessage);
            this.applyItalicSmallStyle(cell2);
        }
    }

    static {
        FALSE.setVal(false);
    }
}

