/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class XlsxColorUtils {
    private static final byte[] RISK_CRITICAL = XlsxColorUtils.safeDecodeHex((String)"BA55D3");
    private static final byte[] RISK_HIGH = XlsxColorUtils.safeDecodeHex((String)"F50F50");
    private static final byte[] RISK_MEDIUM = XlsxColorUtils.safeDecodeHex((String)"FFA500");
    private static final byte[] RISK_LOW = XlsxColorUtils.safeDecodeHex((String)"EDDD1F");
    private static final byte[] RISK_NONE = XlsxColorUtils.safeDecodeHex((String)"8DC53E");
    private static final byte[] RISK_UNKNOWN = XlsxColorUtils.safeDecodeHex((String)"A9A9A9");
    private static final byte[] COMPLIANCE_NONE = XlsxColorUtils.safeDecodeHex((String)"7F7F7F");
    private static final Map<String, byte[]> RISK_COLORS = new HashMap();
    private static final Map<String, byte[]> CATEGORY_COLORS;
    private static final Map<String, byte[]> OBSOLESCENCE_COLORS;
    private static final Map<String, byte[]> COMPLIANCE_COLORS;
    private static final Map<String, byte[]> SOURCE_COLORS;

    public static byte[] safeDecodeHex(String hexColor) {
        try {
            return Hex.decodeHex((String)hexColor);
        }
        catch (DecoderException ignore) {
            return null;
        }
    }

    public static Function<String, byte[]> risk() {
        return c -> RISK_COLORS.getOrDefault(c, RISK_UNKNOWN);
    }

    public static Function<String, byte[]> componentCategories() {
        return c -> CATEGORY_COLORS.getOrDefault(c, RISK_UNKNOWN);
    }

    public static Function<String, byte[]> componentObsolescence() {
        return c -> OBSOLESCENCE_COLORS.getOrDefault(c, RISK_UNKNOWN);
    }

    public static Function<String, byte[]> componentCompliance() {
        return c -> COMPLIANCE_COLORS.getOrDefault(c, RISK_UNKNOWN);
    }

    public static Function<String, byte[]> fileSources() {
        return c -> SOURCE_COLORS.getOrDefault(c, RISK_UNKNOWN);
    }

    @Generated
    private XlsxColorUtils() {
    }

    static {
        RISK_COLORS.put("CRITICAL", RISK_CRITICAL);
        RISK_COLORS.put("HIGH", RISK_HIGH);
        RISK_COLORS.put("MEDIUM", RISK_MEDIUM);
        RISK_COLORS.put("LOW", RISK_LOW);
        RISK_COLORS.put("NONE", RISK_NONE);
        RISK_COLORS.put("UNKNOWN", RISK_UNKNOWN);
        CATEGORY_COLORS = new HashMap();
        CATEGORY_COLORS.put("PROPRIETARY", XlsxColorUtils.safeDecodeHex((String)"4AA3DF"));
        CATEGORY_COLORS.put("OPENSOURCE", XlsxColorUtils.safeDecodeHex((String)"8DC53E"));
        CATEGORY_COLORS.put("SANDBOX", XlsxColorUtils.safeDecodeHex((String)"FFA500"));
        CATEGORY_COLORS.put("EXCLUDED", XlsxColorUtils.safeDecodeHex((String)"BA55D3"));
        CATEGORY_COLORS.put("UNDEFINED", XlsxColorUtils.safeDecodeHex((String)"A9A9A9"));
        OBSOLESCENCE_COLORS = new HashMap();
        OBSOLESCENCE_COLORS.put("OUTDATED", RISK_CRITICAL);
        OBSOLESCENCE_COLORS.put("HIGH", RISK_HIGH);
        OBSOLESCENCE_COLORS.put("MEDIUM", RISK_MEDIUM);
        OBSOLESCENCE_COLORS.put("LOW", RISK_LOW);
        OBSOLESCENCE_COLORS.put("UPTODATE", RISK_NONE);
        OBSOLESCENCE_COLORS.put("UNKNOWN", RISK_UNKNOWN);
        COMPLIANCE_COLORS = new HashMap();
        COMPLIANCE_COLORS.put("YES", RISK_NONE);
        COMPLIANCE_COLORS.put("CONDITIONAL", RISK_MEDIUM);
        COMPLIANCE_COLORS.put("NO", RISK_HIGH);
        COMPLIANCE_COLORS.put("UNKNOWN", RISK_UNKNOWN);
        COMPLIANCE_COLORS.put("NONE", COMPLIANCE_NONE);
        SOURCE_COLORS = new HashMap();
        SOURCE_COLORS.put("LOCAL", XlsxColorUtils.safeDecodeHex((String)"8DC53E"));
        SOURCE_COLORS.put("PREVIOUS", XlsxColorUtils.safeDecodeHex((String)"FFA500"));
        SOURCE_COLORS.put("CATALOG", XlsxColorUtils.safeDecodeHex((String)"BA55D3"));
        SOURCE_COLORS.put("SCA", XlsxColorUtils.safeDecodeHex((String)"4AA3DF"));
    }
}

