/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.utils;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class TextUtils {
    public List<String> splitTextBySpacesAndLength(String element, int maxLineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = element.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (word.length() > maxLineLength - 5) {
                List wordParts = this.splitTextByLength(word, maxLineLength - 5);
                for (String part : wordParts) {
                    if (part.length() == maxLineLength - 5) {
                        lines.add(part.trim());
                        line = new StringBuilder();
                        continue;
                    }
                    word = part;
                    break;
                }
            }
            if (line.toString().length() + 1 + word.length() <= maxLineLength) {
                line.append(" ").append(word);
                continue;
            }
            lines.add(line.toString().trim());
            line = new StringBuilder();
            line.append(" ").append(word);
        }
        if (!line.toString().trim().isEmpty()) {
            lines.add(line.toString().trim());
        }
        return lines;
    }

    public List<String> splitTextByLength(String element, int maxLineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String elementCopy = element;
        while (!elementCopy.trim().isEmpty()) {
            if (elementCopy.length() > maxLineLength) {
                String line = elementCopy.substring(0, maxLineLength);
                if (line.trim().isEmpty()) continue;
                lines.add(line);
                elementCopy = elementCopy.substring(maxLineLength);
                continue;
            }
            lines.add(elementCopy.trim());
            elementCopy = "";
        }
        return lines;
    }

    public boolean isStringUpperCase(String str) {
        char[] charArray;
        for (char c : charArray = str.toCharArray()) {
            if ((c == ' ' || !Character.isLowerCase(c)) && !Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public String getPercentValue(Double value, int globalCount) {
        double percentCompute = 100.0 * value / (double)globalCount;
        DecimalFormat df = new DecimalFormat("0.#");
        return df.format(percentCompute) + " %";
    }

    public String limitedHeaderText(String text, String font) {
        return this.limitTextAndAddDots(text, 140, font, 12, 0);
    }

    public String limitTextAndAddDots(String text, int maxPixelWidth, String fontName, int fontSize, int fontStyle) {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        Font font = new Font(fontName, fontStyle, fontSize);
        int textWidth = (int)font.getStringBounds(text, frc).getWidth();
        boolean resized = false;
        while (textWidth > maxPixelWidth) {
            resized = true;
            text = text.substring(0, text.length() - 1);
            textWidth = (int)font.getStringBounds(text, frc).getWidth();
        }
        if (resized) {
            return text + "...";
        }
        return text;
    }

    public String splitByLengthAndConcatWithSpaces(String text, int maxLineLength) {
        StringBuilder concatText = new StringBuilder();
        for (int i = 0; i < text.length(); i += maxLineLength) {
            concatText.append(" ").append(text.substring(i, Math.min(i + maxLineLength, text.length())));
        }
        return concatText.toString().trim();
    }
}

