/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.subservices;

import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.domain.BomExportFormat;
import com.castsoftware.sca.scar.server.bom.handler.BomExporterEvents;
import com.castsoftware.sca.scar.server.bom.handler.ExporterContext;
import com.castsoftware.sca.scar.server.bom.service.export.model.Type;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.ComponentsService;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.DocxPoiUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.RowData;
import com.castsoftware.sca.scar.server.util.DateUtils;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;

public class VulnerabilitiesService {
    private final DocxPoiUtils poiUtils;
    private final FilesUtils fU;
    private final VulnerabilityDao vulDao;
    private final ComponentsService compService;
    public static final String CVSS31_VECTOR_PREFIX = "CVSS:3.1/";
    public static final String CVSS30_VECTOR_PREFIX = "CVSS:3.0/";

    public VulnerabilitiesService(DocxPoiUtils poiUtils, ComponentsService compService, VulnerabilityDao vulDao, FilesUtils filesUtils) {
        this.poiUtils = poiUtils;
        this.compService = compService;
        this.vulDao = vulDao;
        this.fU = filesUtils;
    }

    public void exportBomVulnerabilities(XWPFDocument document, ExporterContext context, String font) {
        if (!context.getVulnerabilities().isEmpty()) {
            context.getVulnerabilities().stream().peek(v -> context.notify((Event)BomExporterEvents.exportVulnerability())).forEach(v -> {
                this.compService.createComponentTitle(document, v.getVulId(), font);
                this.createVulnerabilityTable(v, document, font, context.getConfiguration().getExportFormat());
            });
        } else {
            this.poiUtils.noElementToWrite(document, this.fU.t("scar_export_components_vulnerabilities"));
        }
    }

    public void createSelectedCategoriesMessage(XWPFDocument document, ExporterContext context, String font) {
        if (context.getConfiguration().getExportCategories().size() < DefaultCategory.values().length) {
            this.poiUtils.createUserMessage(document, this.fU.t("scar_export_vulnerability_selected_categories"), font);
        }
    }

    public Optional<VulnerabilityVertex> getVulInfos(VulnerabilityView v) {
        return this.vulDao.findByVId(v.getVulId());
    }

    private void createVulnerabilityTable(VulnerabilityView v, XWPFDocument document, String font, BomExportFormat exportFormat) {
        Optional vulInfosOptional = this.getVulInfos(v);
        VulnerabilityVertex vulInfos = null;
        if (vulInfosOptional.isPresent()) {
            vulInfos = (VulnerabilityVertex)vulInfosOptional.get();
        }
        int[] cellWidths = new int[]{700, 4300};
        int descriptionRowNumber = 0;
        int referencesRowNumber = 0;
        ArrayList<RowData> rowDataList = new ArrayList<RowData>();
        String severityColor = null;
        if (StringUtils.isNotEmpty((CharSequence)v.getSeverity())) {
            for (Type lr : Type.getVulnerabilitySeverities()) {
                if (!lr.getLevelName().equalsIgnoreCase(v.getSeverity())) continue;
                severityColor = lr.getColor();
                break;
            }
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_vulnerabilities_severity"), "", cellWidths[0], "4AA3DF", severityColor, true));
        }
        if (vulInfosOptional.isPresent()) {
            if (StringUtils.isNotEmpty((CharSequence)vulInfos.getDescription())) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_description"), "", cellWidths[0], "4AA3DF", null, false));
                descriptionRowNumber = rowDataList.size() - 1;
            }
            if (vulInfos.getPublished() != null && vulInfos.getPublished().toEpochMilli() != 0L) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_dialog_edit_vulnerability_field_published"), DateUtils.formatExportDate((Date)Date.from(vulInfos.getPublished())), cellWidths[0], "4AA3DF", null, false));
            }
            if (CollectionUtils.isNotEmpty((Collection)((VulnerabilityVertex)vulInfosOptional.get()).getCwes())) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_dialog_edit_vulnerability_field_cwes"), String.join((CharSequence)", ", vulInfos.getCwes()), cellWidths[0], "4AA3DF", null, false));
            }
            if (vulInfos.getPublished() != null && vulInfos.getPublished().toEpochMilli() != 0L) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_references"), "", cellWidths[0], "4AA3DF", null, false));
                referencesRowNumber = rowDataList.size() - 1;
            }
            XWPFTable table = this.poiUtils.initNewTable(null, rowDataList, document, font, true);
            CTTblGrid grid = table.getCTTbl().addNewTblGrid();
            grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[0]));
            grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[1]));
            if (StringUtils.isNotEmpty((CharSequence)vulInfos.getDescription())) {
                this.poiUtils.createParagraphWithoutSpacing(table, vulInfos.getDescription(), descriptionRowNumber, 1, font);
            }
            if (CollectionUtils.isNotEmpty((Collection)vulInfos.getReferences())) {
                this.poiUtils.setListLinksInTableCell(table, vulInfos.getReferences(), referencesRowNumber, font);
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getSeverity())) {
                XWPFParagraph para = table.getRow(0).getCell(1).getParagraphArray(0);
                ((XWPFRun)para.getRuns().get(0)).setText(v.getSeverity());
                ((XWPFRun)para.getRuns().get(0)).setColor(severityColor);
                ((XWPFRun)para.getRuns().get(0)).setBold(true);
                para.setSpacingAfter(0);
                para.setSpacingBefore(0);
            }
            if ("CVE".equals(v.getType())) {
                this.createCvssTables(vulInfos, document, font, exportFormat);
            }
        }
        this.poiUtils.addLineBreak(document);
    }

    private void createCvssTables(VulnerabilityVertex vulInfos, XWPFDocument document, String font, BomExportFormat exportFormat) {
        boolean vector2Present = StringUtils.isNotEmpty((CharSequence)vulInfos.getVector2());
        boolean score2Present = MapUtils.isNotEmpty((Map)vulInfos.getScores2());
        boolean vector3Present = StringUtils.isNotEmpty((CharSequence)vulInfos.getVector3());
        boolean score3Present = MapUtils.isNotEmpty((Map)vulInfos.getScores3());
        if (vector2Present || score2Present) {
            this.createCvssTable(vulInfos.getScores2(), vulInfos, document, font, false, exportFormat);
        }
        if (vector3Present || score3Present) {
            this.createCvssTable(vulInfos.getScores3(), vulInfos, document, font, true, exportFormat);
        }
    }

    private void createCvssTable(Map<String, Double> score, VulnerabilityVertex vulInfos, XWPFDocument document, String font, boolean cvss3x, BomExportFormat exportFormat) {
        String vectorValue;
        String cellText;
        int[] cellWidths = new int[]{14, 46, 10, 18, 12};
        this.poiUtils.setTablesJunction(document, 80);
        XWPFTable table = this.poiUtils.initTable(document, 2, 5);
        CTTblGrid grid = table.getCTTbl().addNewTblGrid();
        grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[0]));
        grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[1]));
        grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[2]));
        grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[3]));
        grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[4]));
        if (cvss3x) {
            String[] vector3 = this.vector3Definition(vulInfos);
            cellText = vector3[1];
            vectorValue = BomExportFormat.DOCX.equals((Object)exportFormat) ? vector3[0].replace(CVSS31_VECTOR_PREFIX, "").replace(CVSS30_VECTOR_PREFIX, "") : vector3[0];
        } else {
            cellText = "CVSS 2";
            vectorValue = vulInfos.getVector2();
        }
        this.createCVSSRow(table, cellText, vectorValue, font, cellWidths);
        if (MapUtils.isNotEmpty(score)) {
            this.vulTableCellSetText("scar_export_vulnerabilities_base", table, score, 2);
            this.vulTableCellSetText("scar_export_vulnerabilities_exploit", table, score, 3);
            this.vulTableCellSetText("scar_export_vulnerabilities_impact", table, score, 4);
        }
    }

    private String[] vector3Definition(VulnerabilityVertex vulInfos) {
        String cVss3Type = "CVSS 3.x";
        if (vulInfos.getVector3().contains(CVSS31_VECTOR_PREFIX)) {
            cVss3Type = "CVSS 3.1";
        } else if (vulInfos.getVector3().contains(CVSS30_VECTOR_PREFIX)) {
            cVss3Type = "CVSS 3.0";
        }
        return new String[]{vulInfos.getVector3(), cVss3Type};
    }

    private void createCVSSRow(XWPFTable table, String cellText, String vectorValue, String font, int[] cellWidths) {
        this.poiUtils.createCell(table.getRow(0), 0, cellText, "4AA3DF", String.valueOf(cellWidths[0]), "FFFFFF", true, false, font);
        this.poiUtils.setTableCellBorderNone(table.getRow(0).getCell(0), "BOTTOM");
        this.poiUtils.createCell(table.getRow(0), 1, StringUtils.capitalize((String)this.fU.t("scar_export_vulnerabilities_vector").toLowerCase()), "E6F7FF", String.valueOf(cellWidths[1]), "4AA3DF", false, false, font);
        this.poiUtils.createCell(table.getRow(0), 2, StringUtils.capitalize((String)this.fU.t("scar_export_vulnerabilities_base").toLowerCase()), "E6F7FF", String.valueOf(cellWidths[2]), "4AA3DF", false, true, font);
        this.poiUtils.createCell(table.getRow(0), 3, StringUtils.capitalize((String)this.fU.t("scar_export_vulnerabilities_exploit").toLowerCase()), "E6F7FF", String.valueOf(cellWidths[3]), "4AA3DF", false, true, font);
        this.poiUtils.createCell(table.getRow(0), 4, StringUtils.capitalize((String)this.fU.t("scar_export_vulnerabilities_impact").toLowerCase()), "E6F7FF", String.valueOf(cellWidths[4]), "4AA3DF", false, true, font);
        this.poiUtils.createCell(table.getRow(1), 0, "", "4AA3DF", String.valueOf(cellWidths[0]), "FFFFFF", false, false, font);
        this.poiUtils.setTableCellBorderNone(table.getRow(1).getCell(0), "TOP");
        this.poiUtils.createCell(table.getRow(1), 1, vectorValue, "FFFFFF", String.valueOf(cellWidths[1]), "000000", false, false, font);
        this.poiUtils.createCell(table.getRow(1), 2, "", "FFFFFF", String.valueOf(cellWidths[2]), "000000", false, true, font);
        this.poiUtils.createCell(table.getRow(1), 3, "", "FFFFFF", String.valueOf(cellWidths[3]), "000000", false, true, font);
        this.poiUtils.createCell(table.getRow(1), 4, "", "FFFFFF", String.valueOf(cellWidths[4]), "000000", false, true, font);
    }

    private void vulTableCellSetText(String messageProperty, XWPFTable table, Map<String, Double> score, int cellNumber) {
        String cvssScoreAttribute = this.fU.t(messageProperty);
        if (StringUtils.isNotEmpty((CharSequence)cvssScoreAttribute) && score.containsKey(cvssScoreAttribute)) {
            ((XWPFRun)table.getRow(1).getCell(cellNumber).getParagraphArray(0).getRuns().get(0)).setText(score.get(this.fU.t(messageProperty)).toString());
        }
    }
}

