/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.subservices;

import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.DocxPoiUtils;
import java.math.BigInteger;
import org.apache.poi.xwpf.usermodel.TOC;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;

public class TocService {
    private final DocxPoiUtils poiUtils;

    public TocService(DocxPoiUtils poiUtils) {
        this.poiUtils = poiUtils;
    }

    public void setPageNumberStart(XWPFDocument doc, BigInteger start) {
        if (doc.getDocument().getBody().isSetSectPr()) {
            if (doc.getDocument().getBody().getSectPr().isSetPgNumType()) {
                doc.getDocument().getBody().getSectPr().getPgNumType().setStart(start);
            } else {
                doc.getDocument().getBody().getSectPr().addNewPgNumType().setStart(start);
            }
        } else {
            doc.getDocument().getBody().addNewSectPr().addNewPgNumType().setStart(start);
        }
    }

    public void createTOC(XWPFDocument document) {
        this.poiUtils.pageBreak(document);
        CTSdtBlock block = document.getDocument().getBody().addNewSdt();
        TOC toc = new TOC(block);
        for (XWPFParagraph par : document.getParagraphs()) {
            String parStyle = par.getStyle();
            if (parStyle == null || !parStyle.startsWith("Heading")) continue;
            try {
                int level = Integer.parseInt(parStyle.substring("Heading".length()));
                toc.addRow(level, par.getText(), 1, "112723803");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }
}

