/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.subservices;

import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.handler.BomExporterEvents;
import com.castsoftware.sca.scar.server.bom.handler.ExporterContext;
import com.castsoftware.sca.scar.server.bom.service.export.dto.LicenseDto;
import com.castsoftware.sca.scar.server.bom.service.export.model.Type;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.ComponentsService;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.TextUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.DocxPoiUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.RowData;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.util.event.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;

public class LicensesService {
    private final DocxPoiUtils poiUtils;
    private final FilesUtils fU;
    private final TextUtils textUtils;
    private final ComponentsService compService;
    private static final String[] HIGH_RISK_LICENSES_SPDX_ID = new String[]{"AGPL-3.0", "EUPL-1.1", "GPL-2.0", "GPL-3.0", "LGPL-2.1", "LGPL-3.0"};
    private static final String[] MEDIUM_RISK_LICENSES_SPDX_ID = new String[]{"EPL-1.0", "MPL-2.0"};
    private static final String[] LOW_RISK_LICENSES_SPDX_ID = new String[]{"Apache-2.0", "BSD-2-Clause", "BSD-3-Clause", "BSL-1.0", "MIT", "Unlicense"};

    public LicensesService(DocxPoiUtils poiUtils, ComponentsService compService, FilesUtils filesUtils, TextUtils textUtils) {
        this.poiUtils = poiUtils;
        this.compService = compService;
        this.fU = filesUtils;
        this.textUtils = textUtils;
    }

    public void exportBomLicenses(ExporterContext context, XWPFDocument document, String font, String font2) {
        if (!context.getLicenses().isEmpty()) {
            AtomicInteger index = new AtomicInteger();
            context.getLicenses().stream().sorted(Comparator.comparing(LicenseVertex::getTitle)).toList().forEach(l -> {
                context.notify((Event)BomExporterEvents.exportLicence());
                Object title = "";
                if (StringUtils.isNotEmpty((CharSequence)l.getSpdxId())) {
                    title = StringUtils.isNotEmpty((CharSequence)l.getTitle()) ? l.getTitle() + " (" + l.getSpdxId() + ")" : l.getSpdxId();
                }
                boolean lastLicenseInDoc = index.get() == context.getLicenses().size() - 1;
                this.compService.createComponentTitle(document, (String)title, font);
                this.createBomLicensesTableAndText(l, document, font, font2, lastLicenseInDoc);
                index.getAndIncrement();
            });
        } else {
            this.poiUtils.noElementToWrite(document, this.fU.t("scar_export_components_licenses"));
        }
    }

    public void createSelectedCategoriesMessage(ExporterContext context, XWPFDocument document, String font) {
        if (context.getConfiguration().getExportCategories().size() < DefaultCategory.values().length) {
            this.poiUtils.createUserMessage(document, this.fU.t("scar_export_license_selected_categories"), font);
        }
    }

    private void createBomLicensesTableAndText(LicenseVertex license, XWPFDocument document, String font, String font2, boolean lastLicenseInDoc) {
        String cleanedLicenseText;
        String cleanedLicenseText2;
        if (CollectionUtils.isNotEmpty((Collection)license.getProperties())) {
            this.poiUtils.createParagraph(this.fU.t("scar_export_licenses_rules_book"), document, 12, true, false, ParagraphAlignment.LEFT, font, false);
            ArrayList<String> allowsList = new ArrayList<String>();
            ArrayList<String> mustList = new ArrayList<String>();
            ArrayList<String> notAllowsList = new ArrayList<String>();
            ArrayList<String> addPropertiesList = new ArrayList<String>();
            for (String property : license.getProperties()) {
                if (property.contains("CAN_")) {
                    allowsList.add(this.fU.t("scar_license_property_" + property.toLowerCase()));
                    continue;
                }
                if (property.contains("MUST_")) {
                    mustList.add(this.fU.t("scar_license_property_" + property.toLowerCase()));
                    continue;
                }
                if (property.contains("CANNOT_")) {
                    notAllowsList.add(this.fU.t("scar_license_property_" + property.toLowerCase()));
                    continue;
                }
                if (!property.contains("SUPPORT_") && !property.contains("FOR_")) continue;
                addPropertiesList.add(this.fU.t("scar_license_property_" + property.toLowerCase()));
            }
            int[] cellWidths = new int[]{1200, 3800};
            int allowRowNumber = 0;
            int mustRowNumber = 0;
            int notAllowRowNumber = 0;
            int addPropsRowNumber = 0;
            ArrayList<RowData> rowDataList = new ArrayList<RowData>();
            if (CollectionUtils.isNotEmpty(allowsList)) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_licenses_allows"), "", cellWidths[0], "8DC53E", null, false));
            }
            if (CollectionUtils.isNotEmpty(mustList)) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_licenses_must"), "", cellWidths[0], "FFA500", null, false));
                mustRowNumber = rowDataList.size() - 1;
            }
            if (CollectionUtils.isNotEmpty(notAllowsList)) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_licenses_not_allow"), "", cellWidths[0], "F50F50", null, false));
                notAllowRowNumber = rowDataList.size() - 1;
            }
            if (CollectionUtils.isNotEmpty(addPropertiesList)) {
                rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_licenses_add_properties"), "", cellWidths[0], "4AA3DF", null, false));
                addPropsRowNumber = rowDataList.size() - 1;
            }
            if (!(CollectionUtils.isEmpty(allowsList) && CollectionUtils.isEmpty(mustList) && CollectionUtils.isEmpty(notAllowsList) && CollectionUtils.isEmpty(addPropertiesList))) {
                XWPFTable table = this.poiUtils.initNewTable(null, rowDataList, document, font, false);
                if (CollectionUtils.isNotEmpty(allowsList)) {
                    this.setParagraphInRulesBookCell(table.getRow(allowRowNumber).getCell(1), allowsList);
                }
                if (CollectionUtils.isNotEmpty(mustList)) {
                    this.setParagraphInRulesBookCell(table.getRow(mustRowNumber).getCell(1), mustList);
                }
                if (CollectionUtils.isNotEmpty(notAllowsList)) {
                    this.setParagraphInRulesBookCell(table.getRow(notAllowRowNumber).getCell(1), notAllowsList);
                }
                if (CollectionUtils.isNotEmpty(addPropertiesList)) {
                    this.setParagraphInRulesBookCell(table.getRow(addPropsRowNumber).getCell(1), addPropertiesList);
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)license.getText()) && !(cleanedLicenseText2 = (cleanedLicenseText = license.getText().replaceAll("<year> <owner>", "")).replaceAll("<year> <copyright holders>", "")).trim().isEmpty()) {
            String[] descriptionTextParts = cleanedLicenseText2.split("\\s\\s+");
            this.poiUtils.addLineBreak(document);
            this.poiUtils.createParagraph(this.fU.t("scar_export_licenses_text"), document, 12, true, false, ParagraphAlignment.LEFT, font, false);
            for (String part : descriptionTextParts) {
                XWPFParagraph paraDescriptionText = document.createParagraph();
                paraDescriptionText.setAlignment(ParagraphAlignment.LEFT);
                XWPFRun runDescriptionText = paraDescriptionText.createRun();
                runDescriptionText.setFontSize(9);
                runDescriptionText.setFontFamily(font2);
                runDescriptionText.setText("      " + part);
                if (this.textUtils.isStringUpperCase(part.trim()) || part.contains("Copyright")) continue;
                paraDescriptionText.setIndentationFirstLine(550);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)license.getUrl())) {
            this.poiUtils.createParagraph(this.fU.t("scar_export_license_reference"), document, 12, true, false, ParagraphAlignment.LEFT, font, false);
            XWPFParagraph paraRefText = document.createParagraph();
            XWPFHyperlinkRun linkRunRefText = this.poiUtils.createHyperlinkRun(paraRefText, license.getUrl());
            linkRunRefText.setText(license.getUrl());
            linkRunRefText.setColor("4AA3DF");
        }
        if (StringUtils.isEmpty((CharSequence)license.getText()) && StringUtils.isEmpty((CharSequence)license.getUrl()) && license.getProperties().isEmpty()) {
            this.poiUtils.createParagraph(this.fU.t("scar_export_licenses_no_infos"), document, 9, false, false, ParagraphAlignment.LEFT, font, false);
        } else if (!lastLicenseInDoc) {
            this.poiUtils.addSeparationLine(document);
        }
    }

    private void setParagraphInRulesBookCell(XWPFTableCell cell, List<String> propertiesList) {
        if (CollectionUtils.isNotEmpty((Collection)cell.getParagraphs())) {
            cell.removeParagraph(0);
        }
        for (String property : propertiesList) {
            XWPFParagraph para = cell.addParagraph();
            XWPFRun run = para.createRun();
            run.setText(property);
            run.setFontSize(10.5);
            para.setSpacingAfter(0);
            para.setSpacingBefore(0);
        }
    }

    public void incrementsLicensesRisksAndComponents(ExporterContext context, List<LicenseDto> licensesRiskAndComponents, Type[] licensesRisks) {
        for (ComponentView component : context.getComponents()) {
            for (LightLicenseView license : component.getLicenses()) {
                if (Arrays.asList(LOW_RISK_LICENSES_SPDX_ID).contains(license.getSpdxId())) {
                    this.incrementForLicense(license, 0, licensesRiskAndComponents, licensesRisks);
                    continue;
                }
                if (Arrays.asList(MEDIUM_RISK_LICENSES_SPDX_ID).contains(license.getSpdxId())) {
                    this.incrementForLicense(license, 1, licensesRiskAndComponents, licensesRisks);
                    continue;
                }
                if (Arrays.asList(HIGH_RISK_LICENSES_SPDX_ID).contains(license.getSpdxId())) {
                    this.incrementForLicense(license, 2, licensesRiskAndComponents, licensesRisks);
                    continue;
                }
                this.incrementForLicense(license, 3, licensesRiskAndComponents, licensesRisks);
            }
        }
        licensesRisks[3].setComponentsNumber(Double.valueOf((double)context.getComponents().size() - (licensesRisks[0].getComponentsNumber() + licensesRisks[1].getComponentsNumber() + licensesRisks[2].getComponentsNumber())));
        licensesRiskAndComponents.sort(Comparator.comparing(LicenseDto::getComponentNumber).reversed());
    }

    private void incrementForLicense(LightLicenseView license, int index, List<LicenseDto> licensesRiskAndComponents, Type[] licensesRisks) {
        for (LicenseDto licenseDto : licensesRiskAndComponents) {
            if (!licenseDto.getLicense().getSpdxId().equals(license.getSpdxId())) continue;
            licenseDto.increment();
            return;
        }
        licensesRiskAndComponents.add(new LicenseDto(license, licensesRisks[index]));
    }
}

