/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.subservices;

import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.handler.ExporterContext;
import com.castsoftware.sca.scar.server.bom.service.export.dto.LicenseDto;
import com.castsoftware.sca.scar.server.bom.service.export.model.Type;
import com.castsoftware.sca.scar.server.bom.service.export.utils.ArrayUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.ColorUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.TextUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.CellData;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.DocxPoiUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.RowData;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.TableColumn;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class KpisService {
    private final DocxPoiUtils poiUtils;
    private final FilesUtils fU;
    private final TextUtils textUtils;
    private final ArrayUtils arrayUtils;

    public KpisService(DocxPoiUtils poiUtils, FilesUtils filesUtils, TextUtils textUtils, ArrayUtils arrayUtils) {
        this.poiUtils = poiUtils;
        this.fU = filesUtils;
        this.textUtils = textUtils;
        this.arrayUtils = arrayUtils;
    }

    public void exportBomComponentByLicenseRisk(XWPFDocument document, ExporterContext context, String font, Type[] licensesRisks) {
        String overviewText = this.fU.t("scar_export_comp_by_license_risk_text_1").replace("{}", context.getConfiguration().getProduct());
        this.poiUtils.createParagraph(overviewText, document, 10, false, false, ParagraphAlignment.LEFT, font, true);
        this.poiUtils.createParagraph(this.fU.t("scar_export_comp_by_license_risk_text_2"), document, 10, false, false, ParagraphAlignment.LEFT, font, true);
        this.poiUtils.createParagraph(this.fU.t("scar_export_comp_by_license_risk_text_3"), document, 10, false, false, ParagraphAlignment.LEFT, font, false);
        Double[] values = new Double[]{licensesRisks[0].getComponentsNumber(), licensesRisks[1].getComponentsNumber(), licensesRisks[2].getComponentsNumber(), licensesRisks[3].getComponentsNumber()};
        String[] risks = new String[licensesRisks.length];
        String[] riskColors = new String[licensesRisks.length];
        int index = 0;
        for (Type lr : licensesRisks) {
            risks[index] = lr.getLevelName();
            riskColors[index] = lr.getColor();
            ++index;
        }
        this.createChartAndTableForLicensesRisks(document, context, risks, values, riskColors, font);
    }

    private void createChartAndTableForLicensesRisks(XWPFDocument document, ExporterContext context, String[] risks, Double[] values, String[] riskColors, String font) {
        this.poiUtils.createPieChart(document, this.fU.t("scar_export_comp_by_license_risk"), values, risks, riskColors);
        this.create3colsTableForCompKpi(document, context, this.fU.t("scar_export_license_risk"), risks, values, riskColors, font);
        this.poiUtils.pageBreak(document);
    }

    public void exportBomComponentByLicenses(XWPFDocument document, ExporterContext context, String font, List<LicenseDto> licensesRiskAndComponents) {
        String projectLicensesText = this.fU.t("scar_export_comp_by_license_text").replace("{}", context.getConfiguration().getProduct());
        this.poiUtils.createParagraph(projectLicensesText, document, 10, false, false, ParagraphAlignment.LEFT, font, false);
        String[] licenses = new String[licensesRiskAndComponents.size()];
        if (licenses.length > 0) {
            Double[] values = new Double[licensesRiskAndComponents.size()];
            String[] colors = new String[licensesRiskAndComponents.size()];
            int index = 0;
            for (LicenseDto licenseDto : licensesRiskAndComponents) {
                licenses[index] = licenseDto.getLicense().getSpdxId();
                values[index] = licenseDto.getComponentNumber();
                colors[index] = licenseDto.getLicenseRisk().getColor();
                ++index;
            }
            this.createChartAndTableForLicenses(document, context, licenses, values, colors, font, licensesRiskAndComponents);
        } else {
            this.poiUtils.noElementToWrite(document, this.fU.t("scar_export_components_licenses"));
        }
    }

    private void createChartAndTableForLicenses(XWPFDocument document, ExporterContext context, String[] licenses, Double[] values, String[] colors, String font, List<LicenseDto> licensesRiskAndComponents) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_comp_by_license"), licenses, values, true, this.fU.t("scar_export_logarithmic_scale_chart"), colors, BarDirection.COL, 3500000, true, true, false, font);
        int[] cellWidths = new int[]{2200, 900, 900, 1000};
        ArrayList<TableColumn> columnTitles = new ArrayList<TableColumn>();
        columnTitles.add(new TableColumn(this.fU.t("scar_export_license_name"), BigInteger.valueOf(cellWidths[0]), ParagraphAlignment.LEFT));
        columnTitles.add(new TableColumn(this.fU.t("scar_export_license_risk"), BigInteger.valueOf(cellWidths[1]), ParagraphAlignment.CENTER));
        columnTitles.add(new TableColumn(this.fU.t("scar_export_components"), BigInteger.valueOf(cellWidths[2]), ParagraphAlignment.CENTER));
        columnTitles.add(new TableColumn(this.fU.t("scar_export_percent_of") + this.fU.t("scar_export_components"), BigInteger.valueOf(cellWidths[3]), ParagraphAlignment.CENTER));
        ArrayList<RowData> rowData = new ArrayList<RowData>();
        int index = 0;
        for (String license : licenses) {
            ArrayList<CellData> cellDataList = new ArrayList<CellData>();
            cellDataList.add(new CellData(license, BigInteger.valueOf(cellWidths[0]), null, null, true, ParagraphAlignment.LEFT));
            cellDataList.add(new CellData(licensesRiskAndComponents.get(index).getLicenseRisk().getLevelName(), BigInteger.valueOf(cellWidths[1]), null, colors[index], true, ParagraphAlignment.CENTER));
            cellDataList.add(new CellData(String.valueOf(Math.round(values[index])), BigInteger.valueOf(cellWidths[2]), null, null, false, ParagraphAlignment.CENTER));
            String percent = this.textUtils.getPercentValue(licensesRiskAndComponents.get(index).getComponentNumber(), context.getComponents().size());
            cellDataList.add(new CellData(percent, BigInteger.valueOf(cellWidths[3]), null, null, false, ParagraphAlignment.CENTER));
            rowData.add(new RowData(cellDataList));
            ++index;
        }
        this.poiUtils.initNewTable(columnTitles, rowData, document, font, false);
    }

    public void exportBomComponentByCategory(XWPFDocument document, ExporterContext context, String font) {
        String[] categories = Type.getCategoryTypes();
        Double[] values = new Double[5];
        String[] colors = ColorUtils.getCategoryColors();
        int index = 0;
        for (String category : categories) {
            values[index] = ((Number)context.getKpIs().getComponentsByCategory().get(category)).doubleValue();
            ++index;
        }
        this.createChartAndTableForCompByCategory(document, context, categories, values, colors, font);
    }

    private void createChartAndTableForCompByCategory(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String[] colors, String font) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_comp_by_category"), (String[])this.arrayUtils.reverseArray((Object[])categories), (Double[])this.arrayUtils.reverseArray((Object[])values), true, this.fU.t("scar_export_logarithmic_scale_chart"), (String[])this.arrayUtils.reverseArray((Object[])colors), BarDirection.BAR, 3500000, false, true, true, font);
        this.create3colsTableForCompKpi(document, context, this.fU.t("scar_export_category"), categories, values, colors, font);
        this.poiUtils.pageBreak(document);
    }

    public void exportBomComponentByCompliance(XWPFDocument document, ExporterContext context, String font) {
        String[] categories = Type.getComplianceLevels();
        Double[] values = new Double[5];
        String[] colors = ColorUtils.getComplianceColors();
        for (int index = 0; index < values.length - 1; ++index) {
            Number value = (Number)context.getKpIs().getComponentsByCompliance().get(categories[index]);
            values[index] = value != null ? Double.valueOf(value.doubleValue()) : Double.valueOf(0.0);
        }
        values[4] = (double)context.getComponents().size() - (values[0] + values[1] + values[2] + values[3]);
        this.createChartAndTableCByCompliance(document, context, categories, values, colors, font);
        this.poiUtils.pageBreak(document);
    }

    private void createChartAndTableCByCompliance(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String[] colors, String font) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_comp_by_compliance"), categories, values, true, this.fU.t("scar_export_logarithmic_scale_chart"), colors, BarDirection.COL, 3500000, false, true, false, font);
        this.create3colsTableForCompKpi(document, context, this.fU.t("scar_export_compliance"), categories, values, colors, font);
    }

    private void create3colsTableForCompKpi(XWPFDocument document, ExporterContext context, String firstTitle, String[] categories, Double[] values, String[] colors, String font) {
        this.create3colsTable(document, firstTitle, this.fU.t("scar_export_components"), categories, values, context.getComponents().size(), colors, font);
    }

    private void create3colsTableForFilesKpi(XWPFDocument document, ExporterContext context, String firstTitle, String[] categories, Double[] values, String[] colors, String font) {
        this.create3colsTable(document, firstTitle, this.fU.t("scar_export_files"), categories, values, context.getFileCount().intValue(), colors, font);
    }

    private void create3colsTable(XWPFDocument document, String firstTitle, String elementTitle, String[] categories, Double[] values, int globalCount, String[] colors, String font) {
        int[] cellWidths = new int[]{2200, 1400, 1400};
        ArrayList<TableColumn> columnTitles = new ArrayList<TableColumn>();
        columnTitles.add(new TableColumn(firstTitle, BigInteger.valueOf(cellWidths[0]), ParagraphAlignment.LEFT));
        columnTitles.add(new TableColumn(elementTitle, BigInteger.valueOf(cellWidths[1]), ParagraphAlignment.CENTER));
        columnTitles.add(new TableColumn(this.fU.t("scar_export_percent_of") + elementTitle, BigInteger.valueOf(cellWidths[2]), ParagraphAlignment.CENTER));
        ArrayList<RowData> rowData = new ArrayList<RowData>();
        int index = 0;
        for (String category : categories) {
            ArrayList<CellData> cellDataList = new ArrayList<CellData>();
            String color = null;
            if (colors != null) {
                color = colors[index];
            }
            cellDataList.add(new CellData(category, BigInteger.valueOf(cellWidths[0]), null, color, true, ParagraphAlignment.LEFT));
            cellDataList.add(new CellData(String.valueOf(Math.round(values[index])), BigInteger.valueOf(cellWidths[1]), null, null, false, ParagraphAlignment.CENTER));
            String percent = this.textUtils.getPercentValue(values[index], globalCount);
            cellDataList.add(new CellData(percent, BigInteger.valueOf(cellWidths[2]), null, null, false, ParagraphAlignment.CENTER));
            rowData.add(new RowData(cellDataList));
            ++index;
        }
        this.poiUtils.initNewTable(columnTitles, rowData, document, font, false);
    }

    private void create4colsTableWithPositionForComp(XWPFDocument document, ExporterContext context, String secondTitle, String[] categories, Double[] values, String font) {
        this.create4colsTableWithPositionColumn(document, secondTitle, this.fU.t("scar_export_components"), categories, values, context.getComponents().size(), font);
    }

    private void create4colsTableWithPositionForFiles(XWPFDocument document, ExporterContext context, String secondTitle, String[] categories, Double[] values, String font) {
        this.create4colsTableWithPositionColumn(document, secondTitle, this.fU.t("scar_export_files"), categories, values, context.getFileCount().intValue(), font);
    }

    private void create4colsTableWithPositionColumn(XWPFDocument document, String secondTitle, String elementTitle, String[] categories, Double[] values, int globalCount, String font) {
        int[] cellWidths = new int[]{550, 2000, 1200, 1250};
        ArrayList<TableColumn> columnTitles = new ArrayList<TableColumn>();
        columnTitles.add(new TableColumn(this.fU.t("scar_export_components_position"), BigInteger.valueOf(cellWidths[0]), ParagraphAlignment.CENTER));
        columnTitles.add(new TableColumn(secondTitle, BigInteger.valueOf(cellWidths[1]), ParagraphAlignment.LEFT));
        columnTitles.add(new TableColumn(elementTitle, BigInteger.valueOf(cellWidths[2]), ParagraphAlignment.CENTER));
        columnTitles.add(new TableColumn(this.fU.t("scar_export_percent_of") + elementTitle, BigInteger.valueOf(cellWidths[3]), ParagraphAlignment.CENTER));
        ArrayList<RowData> rowData = new ArrayList<RowData>();
        int index = 0;
        for (String category : categories) {
            ArrayList<CellData> cellDataList = new ArrayList<CellData>();
            cellDataList.add(new CellData(String.valueOf(index + 1), BigInteger.valueOf(cellWidths[0]), null, null, false, ParagraphAlignment.CENTER));
            cellDataList.add(new CellData(category, BigInteger.valueOf(cellWidths[1]), null, null, true, ParagraphAlignment.LEFT));
            cellDataList.add(new CellData(String.valueOf(Math.round(values[index])), BigInteger.valueOf(cellWidths[2]), null, null, false, ParagraphAlignment.CENTER));
            String percent = this.textUtils.getPercentValue(values[index], globalCount);
            cellDataList.add(new CellData(percent, BigInteger.valueOf(cellWidths[3]), null, null, false, ParagraphAlignment.CENTER));
            rowData.add(new RowData(cellDataList));
            ++index;
        }
        this.poiUtils.initNewTable(columnTitles, rowData, document, font, false);
    }

    public void exportBomComponentByObsolescence(XWPFDocument document, ExporterContext context, String font) {
        String[] categories = Type.getObsolescenceLevels();
        Double[] values = new Double[6];
        String[] colors = ColorUtils.getObsolescenceColors();
        for (int index = 0; index < values.length; ++index) {
            values[index] = ((Number)context.getKpIs().getComponentsByObsolescence().get(categories[index])).doubleValue();
        }
        this.createChartAndTableCByObsolescence(document, context, categories, values, colors, font);
    }

    private void createChartAndTableCByObsolescence(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String[] colors, String font) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_comp_by_obsolescence"), categories, values, false, this.fU.t("scar_export_logarithmic_scale_chart"), colors, BarDirection.COL, 3500000, false, true, false, font);
        this.create3colsTableForCompKpi(document, context, this.fU.t("scar_export_components_obsolescence"), categories, values, colors, font);
    }

    public void exportBomComponentByVulnerabilities(XWPFDocument document, ExporterContext context, String font) {
        String[] categories = Type.getVulnerabilityLevels();
        Double[] values = new Double[6];
        String[] colors = ColorUtils.getVulnerabilitiesColors();
        for (int index = 0; index < values.length; ++index) {
            Number value = (Number)context.getKpIs().getComponentsByVulnerability().get(categories[index]);
            values[index] = value != null ? value.doubleValue() : 0.0;
        }
        values[4] = (double)context.getKpIs().getCounters().getComponents().longValue() - (values[0] + values[1] + values[2] + values[5]);
        this.createChartAndTableCByVulnerabilities(document, context, categories, values, colors, font);
        this.poiUtils.pageBreak(document);
    }

    private void createChartAndTableCByVulnerabilities(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String[] colors, String font) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_comp_by_vulnerability"), categories, values, true, this.fU.t("scar_export_logarithmic_scale_chart"), colors, BarDirection.COL, 3500000, false, true, true, font);
        this.create3colsTableForCompKpi(document, context, this.fU.t("scar_export_vulnerability"), categories, values, colors, font);
    }

    public void exportBomComponentTop10Languages(XWPFDocument document, ExporterContext context, String font) {
        Map map = context.getKpIs().getComponentsTop10Language();
        if (map.isEmpty()) {
            this.poiUtils.noElementToWrite(document, this.fU.t("scar_export_components_languages"));
        } else {
            int max = map.size();
            if (map.size() > 10) {
                max = 10;
            }
            String[] categories = new String[max];
            Double[] values = new Double[max];
            Map sorted = this.sortMap(map, true);
            int index = 0;
            for (Map.Entry entry : sorted.entrySet()) {
                if (index >= max) continue;
                values[index] = ((Number)entry.getValue()).doubleValue();
                categories[index] = (String)entry.getKey();
                ++index;
            }
            this.createChartAndTableTop10Languages(document, context, categories, values, font);
        }
    }

    private void createChartAndTableTop10Languages(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String font) {
        this.poiUtils.createPieChart(document, this.fU.t("scar_export_comp_top10_language"), values, categories, null);
        this.create4colsTableWithPositionForComp(document, context, this.fU.t("scar_export_language"), categories, values, font);
    }

    public void exportBomComponentTop10Topics(XWPFDocument document, ExporterContext context, String font) {
        Map topicsMap = context.getKpIs().getComponentsTop10Topic();
        if (topicsMap.isEmpty()) {
            return;
        }
        int max = topicsMap.size();
        if (topicsMap.size() > 10) {
            max = 10;
        }
        String[] categories = new String[max];
        Double[] values = new Double[max];
        Map sorted = this.sortMap(topicsMap, false);
        int index = max - 1;
        for (Map.Entry entry : sorted.entrySet()) {
            values[index] = ((Number)entry.getValue()).doubleValue();
            categories[index] = (String)entry.getKey();
            --index;
        }
        this.createChartAndTableCTop10Topics(document, context, categories, values, font);
    }

    private void createChartAndTableCTop10Topics(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String font) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_comp_top10_topics"), categories, values, true, this.fU.t("scar_export_logarithmic_scale_chart"), null, BarDirection.BAR, 3500000, false, true, true, font);
        this.create4colsTableWithPositionForComp(document, context, this.fU.t("scar_export_topic"), (String[])this.arrayUtils.reverseArray((Object[])categories), (Double[])this.arrayUtils.reverseArray((Object[])values), font);
    }

    private Map<String, Number> sortMap(Map<String, Number> map, boolean upperCase) {
        Stream stream = map.entrySet().stream().filter(m -> !((String)m.getKey()).equalsIgnoreCase("OTHERS")).sorted(Map.Entry.comparingByValue(Comparator.comparingInt(Number::intValue).reversed()));
        if (upperCase) {
            return stream.collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(), Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        return stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public void exportBomFilesBySource(XWPFDocument document, ExporterContext context, String font) {
        Map map = context.getKpIs().getFilesBySource();
        if (map.isEmpty()) {
            return;
        }
        String[] categories = Type.getSourcesTypes();
        Double[] values = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        String[] colors = ColorUtils.getSourcesColors();
        int index = 0;
        for (String category : categories) {
            for (Map.Entry entry : map.entrySet()) {
                if (!category.equals(entry.getKey())) continue;
                values[index] = ((Number)entry.getValue()).doubleValue();
                break;
            }
            ++index;
        }
        this.createChartAndTableFilesBySource(document, context, categories, values, colors, font);
        this.poiUtils.pageBreak(document);
    }

    private void createChartAndTableFilesBySource(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String[] colors, String font) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_files_by_source"), categories, values, true, this.fU.t("scar_export_logarithmic_scale_chart"), colors, BarDirection.COL, 3500000, false, false, false, font);
        this.create3colsTableForFilesKpi(document, context, this.fU.t("scar_export_source"), categories, values, colors, font);
    }

    public void exportBomFilesTop10Extensions(XWPFDocument document, ExporterContext context, String font) {
        Map sorted = context.getKpIs().getFilesTop10Extension().entrySet().stream().filter(m -> !((String)m.getKey()).equalsIgnoreCase("OTHERS")).sorted(Map.Entry.comparingByValue(Comparator.comparingInt(Number::intValue))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        if (sorted.isEmpty()) {
            return;
        }
        int max = sorted.size();
        if (sorted.size() > 10) {
            max = 10;
        }
        String[] categories = new String[max];
        Double[] values = new Double[max];
        int index = max - 1;
        for (Map.Entry entry : sorted.entrySet()) {
            values[index] = ((Number)entry.getValue()).doubleValue();
            categories[index] = (String)entry.getKey();
            --index;
        }
        this.createChartAndTableFilesTop10Extensions(document, context, categories, values, font);
    }

    private void createChartAndTableFilesTop10Extensions(XWPFDocument document, ExporterContext context, String[] categories, Double[] values, String font) {
        this.poiUtils.createPieChart(document, this.fU.t("scar_export_files_top10_extensions"), values, categories, null);
        this.create4colsTableWithPositionForFiles(document, context, this.fU.t("scar_export_extension"), categories, values, font);
    }

    public void createSelectedCategoriesMessage(XWPFDocument document, ExporterContext context, String font) {
        if (context.getConfiguration().getExportCategories().size() < DefaultCategory.values().length) {
            this.poiUtils.createUserMessage(document, this.fU.t("scar_export_kpis_selected_categories"), font);
        }
    }
}

