/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.subservices;

import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.handler.BomExporterEvents;
import com.castsoftware.sca.scar.server.bom.handler.ExporterContext;
import com.castsoftware.sca.scar.server.bom.service.export.dto.LicenseDto;
import com.castsoftware.sca.scar.server.bom.service.export.model.Type;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.TextUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.DocxPoiUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.RowData;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.core.model.NamedView;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;

public class ComponentsService {
    private final DocxPoiUtils poiUtils;
    private final TextUtils textUtils;
    private final FilesUtils fU;

    public ComponentsService(DocxPoiUtils poiUtils, FilesUtils filesUtils, TextUtils textUtils) {
        this.poiUtils = poiUtils;
        this.fU = filesUtils;
        this.textUtils = textUtils;
    }

    public void exportBomComponents(ExporterContext context, List<ComponentView> components, XWPFDocument document, String font, List<LicenseDto> licensesRiskAndComponents) {
        AtomicBoolean noneFound = new AtomicBoolean(true);
        components.stream().filter(component -> context.getConfiguration().getExportCategories().stream().anyMatch(component.getCategory()::equalsIgnoreCase)).sorted(Comparator.comparing(NamedView::getName)).peek(c -> context.notify((Event)BomExporterEvents.exportComponent())).forEach(c -> {
            noneFound.set(false);
            this.createComponentTitle(document, c.getName(), font);
            this.createComponentTable(c, document, licensesRiskAndComponents, font);
        });
        if (noneFound.get()) {
            this.poiUtils.noElementToWrite(document, this.fU.t("scar_export_components"));
        }
    }

    public void createSelectedCategoriesComponentsMessage(ExporterContext context, XWPFDocument document, String font) {
        if (context.getConfiguration().getExportCategories().size() < DefaultCategory.values().length) {
            ArrayList<String> categoryNames = new ArrayList<String>();
            for (String category : context.getConfiguration().getExportCategories()) {
                categoryNames.add(DefaultCategory.valueOf((String)category.toUpperCase()).getName());
            }
            String message = this.fU.t("scar_export_comp_selected_categories") + String.join((CharSequence)", ", categoryNames) + ".";
            this.poiUtils.createUserMessage(document, message, font);
        }
    }

    public void createComponentTitle(XWPFDocument document, String componentName, String font) {
        XWPFParagraph componentPara = document.createParagraph();
        XWPFRun title = componentPara.createRun();
        title.setText(componentName);
        title.setFontSize(15);
        title.setColor("4AA3DF");
        title.setFontFamily(font);
    }

    private void createComponentTable(ComponentView c, XWPFDocument document, List<LicenseDto> licensesRiskAndComponents, String font) {
        XWPFRun run;
        int[] cellWidths = new int[]{850, 4150};
        int originsRowNumber = 0;
        int vulnerabilitiesRowNumber = 0;
        int licensesRowNumber = 0;
        int descriptionRowNumber = 0;
        ArrayList<RowData> rowDataList = new ArrayList<RowData>();
        if (CollectionUtils.isNotEmpty((Collection)c.getReferences())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_origins"), "", cellWidths[0], "4AA3DF", null, false));
        }
        if (StringUtils.isNotEmpty((CharSequence)c.getCategory())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_category"), DefaultCategory.valueOf((String)c.getCategory().toUpperCase()).getName(), cellWidths[0], "4AA3DF", null, false));
        }
        if (StringUtils.isNotEmpty((CharSequence)c.getUpToDate())) {
            String obsolescenceColor = "UPTODATE".equalsIgnoreCase(c.getUpToDate()) ? "8DC53E" : ("OUTDATED".equalsIgnoreCase(c.getUpToDate()) ? "BA55D3" : ("LOW".equalsIgnoreCase(c.getUpToDate()) ? "EDDD1F" : ("MEDIUM".equalsIgnoreCase(c.getUpToDate()) ? "FFA500" : ("HIGH".equalsIgnoreCase(c.getUpToDate()) ? "F50F50" : "7F7F7F"))));
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_obsolescence"), c.getUpToDate(), cellWidths[0], "4AA3DF", obsolescenceColor, true));
        }
        if (StringUtils.isNotBlank((CharSequence)c.getVersion())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_version"), c.getVersion(), cellWidths[0], "4AA3DF", null, false));
        }
        if (StringUtils.isNotEmpty((CharSequence)c.getLatestVersion())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_latest_version"), c.getLatestVersion(), cellWidths[0], "4AA3DF", null, false));
        }
        if (CollectionUtils.isNotEmpty((Collection)c.getVulnerabilities())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_vulnerabilities"), "", cellWidths[0], "4AA3DF", null, true));
            vulnerabilitiesRowNumber = rowDataList.size() - 1;
        }
        if (CollectionUtils.isNotEmpty((Collection)c.getLicenses())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_licenses"), "", cellWidths[0], "4AA3DF", null, true));
            licensesRowNumber = rowDataList.size() - 1;
        }
        if (StringUtils.isNotEmpty((CharSequence)c.getPath())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_path"), c.getPath(), cellWidths[0], "4AA3DF", null, false));
        }
        if (StringUtils.isNotEmpty((CharSequence)c.getCopyright())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_copyright"), c.getCopyright(), cellWidths[0], "4AA3DF", null, false));
        }
        if (StringUtils.isNotEmpty((CharSequence)c.getRepository())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_repository"), c.getRepository(), cellWidths[0], "4AA3DF", null, false));
        }
        if (CollectionUtils.isNotEmpty((Collection)c.getLanguages())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_languages"), String.join((CharSequence)", ", c.getLanguages()), cellWidths[0], "4AA3DF", null, false));
        }
        if (CollectionUtils.isNotEmpty((Collection)c.getTopics())) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_topics"), String.join((CharSequence)", ", c.getTopics()), cellWidths[0], "4AA3DF", null, false));
        }
        rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_files_count"), String.valueOf(c.getCounter().getFiles()), cellWidths[0], "4AA3DF", null, false));
        if (StringUtils.isNotEmpty((CharSequence)c.getDescription()) && !c.getDescription().contains("%description%")) {
            rowDataList.add(this.poiUtils.create2CellsRowData(this.fU.t("scar_export_components_description"), "", cellWidths[0], "4AA3DF", null, false));
            descriptionRowNumber = rowDataList.size() - 1;
        }
        XWPFTable table = this.poiUtils.initNewTable(null, rowDataList, document, font, true);
        CTTblGrid grid = table.getCTTbl().addNewTblGrid();
        grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[0]));
        grid.addNewGridCol().setW((Object)BigInteger.valueOf(cellWidths[1]));
        if (CollectionUtils.isNotEmpty((Collection)c.getReferences())) {
            this.poiUtils.setListLinksInTableCell(table, new ArrayList(c.getReferences()), originsRowNumber, font);
        }
        if (CollectionUtils.isNotEmpty((Collection)c.getLicenses())) {
            LinkedList sortedLicenses = c.getLicenses().stream().sorted(Comparator.comparing(LightLicenseView::getSpdxId)).collect(Collectors.toCollection(LinkedList::new));
            table.getRow(licensesRowNumber).getCell(1).removeParagraph(0);
            block0: for (LightLicenseView sortedLicense : sortedLicenses) {
                run = this.poiUtils.createParagraphWithoutSpacing(table, sortedLicense.getSpdxId(), licensesRowNumber, 1, font);
                for (LicenseDto license : licensesRiskAndComponents) {
                    if (!license.getLicense().getSpdxId().equals(sortedLicense.getSpdxId())) continue;
                    run.setColor(license.getLicenseRisk().getColor());
                    run.setBold(true);
                    continue block0;
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)c.getVulnerabilities())) {
            LinkedList sortedVulnerabilities = c.getVulnerabilities().stream().sorted(Comparator.comparing(VulnerabilityView::getVulId)).collect(Collectors.toCollection(LinkedList::new));
            table.getRow(vulnerabilitiesRowNumber).getCell(1).removeParagraph(0);
            block2: for (VulnerabilityView vul : sortedVulnerabilities) {
                run = this.poiUtils.createParagraphWithoutSpacing(table, vul.getVulId(), vulnerabilitiesRowNumber, 1, font);
                for (Type level : Type.getVulnerabilitySeverities()) {
                    if (!level.getLevelName().equals(vul.getSeverity())) continue;
                    run.setColor(level.getColor());
                    run.setBold(true);
                    continue block2;
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)c.getDescription())) {
            String description = c.getDescription();
            table.getRow(descriptionRowNumber).getCell(1).removeParagraph(0);
            this.poiUtils.createParagraphWithoutSpacing(table, description, descriptionRowNumber, 1, font);
        }
        this.poiUtils.addLineBreak(document);
    }
}

