/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export.subservices;

import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.handler.ExporterContext;
import com.castsoftware.sca.scar.server.bom.service.export.model.Type;
import com.castsoftware.sca.scar.server.bom.service.export.utils.ColorUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.CellData;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.DocxPoiUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.RowData;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.TableColumn;
import com.castsoftware.sca.scar.server.util.DateUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class BomInfosService {
    private final DocxPoiUtils poiUtils;
    private final FilesUtils fU;

    public BomInfosService(DocxPoiUtils poiUtils, FilesUtils filesUtils) {
        this.poiUtils = poiUtils;
        this.fU = filesUtils;
    }

    public void createBomInfosTable(ExporterContext context, XWPFDocument document, String font) {
        int[] cellWidths = new int[]{900, 4100};
        ArrayList<String> rowTitles = new ArrayList<String>();
        rowTitles.add(this.fU.t("scar_export_bom_infos_project"));
        rowTitles.add(this.fU.t("scar_export_bom_infos_product"));
        rowTitles.add(this.fU.t("scar_export_bom_infos_creation_date"));
        rowTitles.add(this.fU.t("scar_export_bom_infos_review_step"));
        rowTitles.add(this.fU.t("scar_export_bom_infos_bom_version"));
        rowTitles.add(this.fU.t("scar_export_bom_infos_policy_name"));
        ArrayList<String> rowValues = new ArrayList<String>();
        rowValues.add(context.getConfiguration().getProject());
        rowValues.add(context.getConfiguration().getProduct());
        rowValues.add(DateUtils.formatExportDate((Date)Date.from(context.getCreated())));
        rowValues.add(context.getReviewStep());
        rowValues.add(context.getConfiguration().getVersion());
        rowValues.add(context.getLicensePolicy());
        ArrayList<RowData> rowDataList = new ArrayList<RowData>();
        for (int i = 0; i < rowTitles.size(); ++i) {
            ArrayList<CellData> cellDataList = new ArrayList<CellData>();
            cellDataList.add(new CellData((String)rowTitles.get(i), BigInteger.valueOf(cellWidths[0]), "4AA3DF", null, true, ParagraphAlignment.LEFT));
            cellDataList.add(new CellData((String)rowValues.get(i), BigInteger.valueOf(cellWidths[1]), null, null, false, ParagraphAlignment.LEFT));
            rowDataList.add(new RowData(cellDataList));
        }
        this.poiUtils.initNewTable(null, rowDataList, document, font, false);
        this.poiUtils.addLineBreak(document);
    }

    public void exportBomInfosCountsChart(ExporterContext context, XWPFDocument document, String font) {
        String[] categories = Type.getBomInfosCountsTypes();
        Double[] values = new Double[]{(double)context.getComponentCount(), (double)context.getFileCount(), context.getLicenses().size(), context.getVulnerabilities().size()};
        String[] colors = ColorUtils.getGlobalCountsColors();
        this.createChartAndTableBomInfosCounts(document, categories, values, colors, font);
    }

    private void createChartAndTableBomInfosCounts(XWPFDocument document, String[] categories, Double[] values, String[] colors, String font) {
        this.poiUtils.createBarChart(document, this.fU.t("scar_export_global_counts"), categories, values, true, this.fU.t("scar_export_logarithmic_scale_chart"), colors, BarDirection.COL, 3500000, false, true, false, font);
        int[] cellWidths = new int[]{4000, 1000};
        ArrayList<TableColumn> columnTitles = new ArrayList<TableColumn>();
        columnTitles.add(new TableColumn(this.fU.t("scar_export_element"), BigInteger.valueOf(cellWidths[0]), ParagraphAlignment.LEFT));
        columnTitles.add(new TableColumn(this.fU.t("scar_export_count"), BigInteger.valueOf(cellWidths[1]), ParagraphAlignment.CENTER));
        ArrayList<RowData> rowData = new ArrayList<RowData>();
        int index = 0;
        for (String category : categories) {
            ArrayList<CellData> cellDataList = new ArrayList<CellData>();
            cellDataList.add(new CellData(category, BigInteger.valueOf(cellWidths[0]), null, colors[index], true, ParagraphAlignment.LEFT));
            cellDataList.add(new CellData(String.valueOf(Math.round(values[index])), BigInteger.valueOf(cellWidths[1]), null, null, false, ParagraphAlignment.CENTER));
            rowData.add(new RowData(cellDataList));
            ++index;
        }
        this.poiUtils.initNewTable(columnTitles, rowData, document, font, false);
    }

    public void createSelectedCategoriesMessage(ExporterContext context, XWPFDocument document, String font) {
        if (context.getConfiguration().getExportCategories().size() < DefaultCategory.values().length) {
            this.poiUtils.createUserMessage(document, this.fU.t("scar_export_bom_infos_selected_categories"), font);
        }
    }
}

