/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service.export;

import com.castsoftware.sca.scar.server.bom.handler.BomExporterEvents;
import com.castsoftware.sca.scar.server.bom.handler.ExporterContext;
import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.bom.service.export.ExportSteps;
import com.castsoftware.sca.scar.server.bom.service.export.model.Type;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.VulnerabilitiesService;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.XlsxColorUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.XlsxPoiUtils;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;

public class XlsxBomExportService
implements ExportSteps {
    private final XlsxPoiUtils xlsxPoiUtils;
    private final FilesUtils fU;
    private final VulnerabilitiesService vulService;
    private final int maxChar = SpreadsheetVersion.EXCEL2007.getMaxTextLength();
    private static final CTBoolean FALSE = (CTBoolean)CTBoolean.Factory.newInstance();

    public XlsxBomExportService(XlsxPoiUtils xlsxPoiUtils, FilesUtils filesUtils, VulnerabilitiesService vulService) {
        this.xlsxPoiUtils = xlsxPoiUtils;
        this.fU = filesUtils;
        this.vulService = vulService;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] startExport(ExporterContext context) {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            byte[] byArray;
            try (ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();){
                if (context.getConfiguration().isExportComponents()) {
                    this.xlsxBomExportComponents(context, (Workbook)workbook);
                }
                if (context.getConfiguration().isExportFiles()) {
                    this.xlsxBomExportFiles(context, (Workbook)workbook);
                }
                this.xlsxBomExportVulnerabilities((Workbook)workbook, context);
                this.xlsxBomExportLicences((Workbook)workbook, context);
                if (context.getConfiguration().isExportKpis()) {
                    this.xlsxBomExportKpis(context, (Workbook)workbook);
                }
                context.notify((Event)BomExporterEvents.exportXlsxWriting());
                workbook.write((OutputStream)byteArrayOS);
                byArray = byteArrayOS.toByteArray();
            }
            return byArray;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to write BOM xlsx export", t);
        }
    }

    private void xlsxBomExportComponents(ExporterContext context, Workbook workbook) {
        List componentHeaders = this.getComponentHeaders();
        context.notify((Event)BomExporterEvents.exportXlsxComponents((Integer)context.getComponents().size()));
        Sheet sheet = workbook.createSheet(this.fU.t("scar_export_components"));
        Row header = sheet.createRow(0);
        componentHeaders.forEach(h -> this.xlsxPoiUtils.createHeader(header, h));
        context.getComponents().stream().filter(component -> context.getConfiguration().getExportCategories().stream().anyMatch(component.getCategory()::equalsIgnoreCase)).peek(c -> context.notify((Event)BomExporterEvents.exportComponent())).forEach(c -> {
            Row row = sheet.createRow(sheet.getLastRowNum() + 1);
            this.exportComponent(row, c);
        });
        context.notify((Event)BomExporterEvents.resizeComponentColumns());
        IntStream.range(0, componentHeaders.size()).forEach(arg_0 -> ((Sheet)sheet).autoSizeColumn(arg_0));
    }

    private void xlsxBomExportFiles(ExporterContext context, Workbook workbook) {
        List fileHeaders = this.getFileHeaders();
        context.notify((Event)BomExporterEvents.exportFiles((Long)context.getFileCount()));
        Sheet sheet = workbook.createSheet(this.fU.t("scar_export_files"));
        Row header = sheet.createRow(0);
        fileHeaders.forEach(h -> this.xlsxPoiUtils.createHeader(header, h));
        context.getComponents().stream().filter(component -> context.getConfiguration().getExportCategories().stream().anyMatch(component.getCategory()::equalsIgnoreCase)).peek(c -> context.notify((Event)BomExporterEvents.exportFile())).forEach(c -> c.getFiles().forEach(f -> {
            Row row = sheet.createRow(sheet.getLastRowNum() + 1);
            this.exportFile(row, f, c);
        }));
        context.notify((Event)BomExporterEvents.resizeFileColumns());
        IntStream.range(0, fileHeaders.size()).forEach(arg_0 -> ((Sheet)sheet).autoSizeColumn(arg_0));
    }

    public void xlsxBomExportLicences(Workbook workbook, ExporterContext context) {
        List licenseHeaders = this.getLicenseHeaders();
        context.notify((Event)BomExporterEvents.exportLicences((Integer)context.getLicenses().size()));
        Sheet sheetLicenses = workbook.createSheet(this.fU.t("scar_export_licenses"));
        Row headerLicenses = sheetLicenses.createRow(0);
        licenseHeaders.forEach(h -> this.xlsxPoiUtils.createHeader(headerLicenses, h));
        context.getLicenses().forEach(licenseVertex -> {
            context.notify((Event)BomExporterEvents.exportLicence());
            Row row = sheetLicenses.createRow(sheetLicenses.getLastRowNum() + 1);
            this.addLicenceDetail(row, licenseVertex);
        });
        context.notify((Event)BomExporterEvents.resizeLicenseColumns());
        IntStream.range(0, licenseHeaders.size()).forEach(arg_0 -> ((Sheet)sheetLicenses).autoSizeColumn(arg_0));
    }

    public void xlsxBomExportVulnerabilities(Workbook workbook, ExporterContext context) {
        List vulnerabilitiesHeaders = this.getVulnerabilitiesHeaders();
        context.notify((Event)BomExporterEvents.exportVulnerabilities((Integer)context.getVulnerabilities().size()));
        Sheet sheetVulnerabilities = workbook.createSheet(this.fU.t("scar_export_vulnerabilities"));
        Row headerVulnerabilities = sheetVulnerabilities.createRow(0);
        vulnerabilitiesHeaders.forEach(h -> this.xlsxPoiUtils.createHeader(headerVulnerabilities, h));
        context.getVulnerabilities().forEach(lightVulView -> {
            context.notify((Event)BomExporterEvents.exportVulnerability());
            Row row = sheetVulnerabilities.createRow(sheetVulnerabilities.getLastRowNum() + 1);
            this.vulService.getVulInfos(lightVulView).ifPresent(vulVertex -> this.addVulnerabilityDetail(row, vulVertex, lightVulView));
        });
        context.notify((Event)BomExporterEvents.resizeVulnerabilityColumns());
        IntStream.range(0, vulnerabilitiesHeaders.size()).forEach(arg_0 -> ((Sheet)sheetVulnerabilities).autoSizeColumn(arg_0));
    }

    private void xlsxBomExportKpis(ExporterContext context, Workbook workbook) {
        context.notify((Event)BomExporterEvents.exportXlsxKPIs());
        String logScale = this.fU.t("scar_export_logarithmic_scale_message");
        Sheet sheet = workbook.createSheet(this.fU.t("scar_export_kpis_components"));
        String components = this.fU.t("scar_export_components");
        this.exportComponentsByCategory(sheet, context.getKpIs().getComponentsByCategory(), logScale, components);
        this.exportComponentsByObsolescence(sheet, context.getKpIs().getComponentsByObsolescence(), logScale, components);
        this.exportComponentsByCompliance(sheet, context.getComponents().size(), context.getKpIs().getComponentsByCompliance(), logScale, components);
        this.exportComponentsByVulnerability(sheet, context.getComponents().size(), context.getKpIs().getComponentsByVulnerability(), logScale, components);
        int startRow = 61;
        if (!context.getKpIs().getComponentsTop10License().isEmpty()) {
            this.exportTop10ComponentLicenses(sheet, context.getKpIs().getComponentsTop10License(), startRow, logScale, components);
            startRow += 15;
        }
        if (!context.getKpIs().getComponentsTop10Language().isEmpty()) {
            this.exportTop10ComponentLanguages(sheet, context.getKpIs().getComponentsTop10Language(), startRow, logScale, components);
            startRow += 15;
        }
        if (!context.getKpIs().getComponentsTop10Topic().isEmpty()) {
            this.exportTop10ComponentTopics(sheet, context.getKpIs().getComponentsTop10Topic(), startRow, logScale, components);
        }
        sheet = workbook.createSheet(this.fU.t("scar_export_kpis_files"));
        String files = this.fU.t("scar_export_files_count");
        this.exportFilesBySource(sheet, context.getKpIs().getFilesBySource(), logScale, files);
        this.exportTop10FileExtensions(sheet, context.getKpIs().getFilesTop10Extension(), logScale, files);
    }

    public void exportFile(Row row, FileView file, ComponentView component) {
        this.xlsxPoiUtils.writeCellValue(row, file.getName());
        this.xlsxPoiUtils.writeCellValue(row, component.getName());
        this.xlsxPoiUtils.writeCellValue(row, file.getPath());
        this.xlsxPoiUtils.writeCellValue(row, Long.toString(file.getSize()));
        this.xlsxPoiUtils.writeCellValue(row, file.getVersion());
        this.xlsxPoiUtils.writeRiskyValues(row, file.getLicenses(), LightLicenseView::getSpdxId, arg_0 -> this.getLicenseColor(arg_0));
        this.xlsxPoiUtils.writeCellValue(row, file.getComments());
    }

    public void exportComponent(Row row, ComponentView componentView) {
        this.xlsxPoiUtils.writeCellValue(row, componentView.getName());
        this.xlsxPoiUtils.writeCellValue(row, componentView.getDescription());
        this.xlsxPoiUtils.writeCellValue(row, componentView.getCategory());
        this.xlsxPoiUtils.writeCellValue(row, componentView.getSource());
        this.xlsxPoiUtils.writeCellValue(row, componentView.getRepository());
        this.xlsxPoiUtils.writeRiskyValues(row, (Collection)componentView.getVulnerabilities(), VulnerabilityView::getVulId, arg_0 -> this.getRiskColor(arg_0));
        this.xlsxPoiUtils.writeRiskyValues(row, (Collection)componentView.getLicenses(), LightLicenseView::getSpdxId, arg_0 -> this.getLicenseColor(arg_0));
        this.xlsxPoiUtils.writeCellValue(row, componentView.getVersion());
        this.xlsxPoiUtils.writeCellValue(row, componentView.getLatestVersion());
        this.xlsxPoiUtils.writeRiskyValue(row, componentView.getUpToDate(), arg_0 -> this.getObsolescenceColor(arg_0));
        this.xlsxPoiUtils.writeCellValue(row, componentView.getPath());
        this.xlsxPoiUtils.writeCellValue(row, String.join((CharSequence)" | ", componentView.getReferences()));
        this.xlsxPoiUtils.writeCellValue(row, String.join((CharSequence)" | ", componentView.getTopics()));
        this.xlsxPoiUtils.writeCellValue(row, String.join((CharSequence)" | ", componentView.getLanguages()));
        this.xlsxPoiUtils.writeCellValue(row, componentView.getComments());
    }

    public void exportComponentsByCategory(Sheet sheet, Map<String, Number> data, String logScale, String components) {
        Map sorted = Stream.of(Type.getCategoryTypes()).collect(Collectors.toMap(s -> s, s -> data.getOrDefault(s, 0), (e1, e2) -> e1, LinkedHashMap::new));
        this.xlsxPoiUtils.writeTable(sheet, 1, this.fU.t("scar_export_category"), components, sorted, true, logScale);
        this.xlsxPoiUtils.drawXlsxBarChart(sheet, 1, this.fU.t("scar_export_comp_by_category"), XlsxColorUtils.componentCategories());
    }

    public void exportComponentsByObsolescence(Sheet sheet, Map<String, Number> data, String logScale, String components) {
        Map sorted = Stream.of(Type.getObsolescenceLevels()).collect(Collectors.toMap(s -> s, s -> data.getOrDefault(s, 0), (e1, e2) -> e1, LinkedHashMap::new));
        this.xlsxPoiUtils.writeTable(sheet, 16, this.fU.t("scar_export_components_obsolescence"), components, sorted, true, logScale);
        this.xlsxPoiUtils.drawXlsxColChart(sheet, 16, this.fU.t("scar_export_comp_by_obsolescence"), XlsxColorUtils.componentObsolescence());
    }

    public void exportComponentsByCompliance(Sheet sheet, int componentsCount, Map<String, Number> data, String logScale, String components) {
        Map sorted = Stream.of(Type.getComplianceLevels()).collect(Collectors.toMap(s -> s, s -> data.getOrDefault(s, 0), (e1, e2) -> e1, LinkedHashMap::new));
        sorted.replace("NONE", 0, componentsCount - sorted.values().stream().mapToInt(Number::intValue).sum());
        this.xlsxPoiUtils.writeTable(sheet, 31, this.fU.t("scar_export_compliance"), components, sorted, true, logScale);
        this.xlsxPoiUtils.drawXlsxColChart(sheet, 31, this.fU.t("scar_export_comp_by_compliance"), XlsxColorUtils.componentCompliance());
    }

    public void exportComponentsByVulnerability(Sheet sheet, int componentsCount, Map<String, Number> data, String logScale, String components) {
        Map sorted = Stream.of(Type.getVulnerabilityLevels()).collect(Collectors.toMap(s -> s, s -> data.getOrDefault(s, 0), (e1, e2) -> e1, LinkedHashMap::new));
        sorted.replace("NONE", 0, componentsCount - sorted.values().stream().mapToInt(Number::intValue).sum());
        this.xlsxPoiUtils.writeTable(sheet, 46, this.fU.t("scar_export_vulnerability"), components, sorted, true, logScale);
        this.xlsxPoiUtils.drawXlsxColChart(sheet, 46, this.fU.t("scar_export_comp_by_vulnerability"), XlsxColorUtils.risk());
    }

    public void exportTop10ComponentLicenses(Sheet sheet, Map<String, Number> data, int startRow, String logScale, String components) {
        Map sorted = this.sortMap(data, false);
        this.xlsxPoiUtils.writeTable(sheet, startRow, this.fU.t("scar_export_license"), components, sorted, true, logScale);
        this.xlsxPoiUtils.drawXlsxColChart(sheet, startRow, this.fU.t("scar_export_comp_top10_licenses"), null);
    }

    public void exportTop10ComponentLanguages(Sheet sheet, Map<String, Number> data, int startRow, String logScale, String components) {
        if (data.isEmpty()) {
            return;
        }
        Map sorted = this.sortMap(data, true);
        this.xlsxPoiUtils.writeTable(sheet, startRow, this.fU.t("scar_export_language"), components, sorted, false, logScale);
        this.xlsxPoiUtils.drawXlsxPieChart(sheet, startRow, this.fU.t("scar_export_comp_top10_language"));
    }

    public void exportTop10ComponentTopics(Sheet sheet, Map<String, Number> data, int startRow, String logScale, String components) {
        if (data.isEmpty()) {
            return;
        }
        Map sorted = this.sortMap(data, false);
        this.xlsxPoiUtils.writeTable(sheet, startRow, this.fU.t("scar_export_topic"), components, sorted, true, logScale);
        this.xlsxPoiUtils.drawXlsxColChart(sheet, startRow, this.fU.t("scar_export_comp_top10_topics"), null);
    }

    public void exportFilesBySource(Sheet sheet, Map<String, Number> data, String logScale, String files) {
        Map sorted = Stream.of(Type.getSourcesTypes()).collect(Collectors.toMap(s -> s, s -> data.getOrDefault(s, 0), (e1, e2) -> e1, LinkedHashMap::new));
        this.xlsxPoiUtils.writeTable(sheet, 1, this.fU.t("scar_export_source"), files, sorted, true, logScale);
        this.xlsxPoiUtils.drawXlsxColChart(sheet, 1, this.fU.t("scar_export_files_by_source"), XlsxColorUtils.fileSources());
    }

    public void exportTop10FileExtensions(Sheet sheet, Map<String, Number> data, String logScale, String files) {
        if (data.isEmpty()) {
            return;
        }
        Map sorted = this.sortMap(data, true);
        this.xlsxPoiUtils.writeTable(sheet, 16, this.fU.t("scar_export_extension"), files, sorted, false, logScale);
        this.xlsxPoiUtils.drawXlsxPieChart(sheet, 16, this.fU.t("scar_export_files_top10_extensions"));
    }

    private Map<String, Number> sortMap(Map<String, Number> data, boolean keyToUpperCase) {
        Stream stream = data.entrySet().stream().filter(m -> !((String)m.getKey()).equalsIgnoreCase("OTHERS")).sorted(Map.Entry.comparingByValue(Comparator.comparingInt(Number::intValue).reversed()));
        if (keyToUpperCase) {
            return stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        return stream.collect(Collectors.toMap(e -> ((String)e.getKey()).toUpperCase(), Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private void addLicenceDetail(Row row, LicenseVertex licenseVertex) {
        this.xlsxPoiUtils.writeCellValue(row, licenseVertex.getSpdxId());
        this.xlsxPoiUtils.writeCellValue(row, licenseVertex.getTitle());
        this.xlsxPoiUtils.writeCellValue(row, licenseVertex.getDescription());
        this.xlsxPoiUtils.writeCellValue(row, licenseVertex.getCategory());
        this.xlsxPoiUtils.writeCellValue(row, String.join((CharSequence)" | ", licenseVertex.getProperties()));
        this.xlsxPoiUtils.writeCellValue(row, licenseVertex.getUrl());
        String text = licenseVertex.getText().length() > this.maxChar ? licenseVertex.getText().substring(this.maxChar - 3).concat("...") : licenseVertex.getText();
        this.xlsxPoiUtils.writeCellValue(row, text);
    }

    private void addVulnerabilityDetail(Row row, VulnerabilityVertex vulnerabilityVertex, VulnerabilityView lightVulView) {
        this.xlsxPoiUtils.writeCellValue(row, vulnerabilityVertex.getVId());
        this.xlsxPoiUtils.writeCellValue(row, vulnerabilityVertex.getType());
        this.xlsxPoiUtils.writeCellValueForVulnerability(row, vulnerabilityVertex.getSeverity(), (Object)lightVulView, arg_0 -> this.getRiskColor(arg_0));
        this.xlsxPoiUtils.writeCellValue(row, String.join((CharSequence)" | ", vulnerabilityVertex.getCwes()));
        this.xlsxPoiUtils.writeCellValue(row, String.join((CharSequence)" | ", vulnerabilityVertex.getDescription()));
        this.xlsxPoiUtils.writeCellValue(row, vulnerabilityVertex.getPublished().toString());
        this.xlsxPoiUtils.writeCellValue(row, String.join((CharSequence)" | ", vulnerabilityVertex.getReferences()));
    }

    private IndexedColors getObsolescenceColor(String obsolescence) {
        return "OUTDATED".equalsIgnoreCase(obsolescence) ? IndexedColors.VIOLET : ("HIGH".equalsIgnoreCase(obsolescence) ? IndexedColors.RED : ("MEDIUM".equalsIgnoreCase(obsolescence) ? IndexedColors.ORANGE : ("LOW".equalsIgnoreCase(obsolescence) ? IndexedColors.DARK_YELLOW : ("UPTODATE".equalsIgnoreCase(obsolescence) ? IndexedColors.GREEN : IndexedColors.GREY_50_PERCENT))));
    }

    private IndexedColors getRiskColor(VulnerabilityView vulnerability) {
        String severity = vulnerability.getSeverity();
        return "CRITICAL".equalsIgnoreCase(severity) ? IndexedColors.VIOLET : ("HIGH".equalsIgnoreCase(severity) ? IndexedColors.RED : ("MEDIUM".equalsIgnoreCase(severity) ? IndexedColors.ORANGE : ("LOW".equalsIgnoreCase(severity) ? IndexedColors.DARK_YELLOW : IndexedColors.BLACK)));
    }

    private IndexedColors getLicenseColor(LightLicenseView license) {
        String compliance = license.getCompliance();
        return "NO".equalsIgnoreCase(compliance) ? IndexedColors.RED : ("CONDITIONAL".equalsIgnoreCase(compliance) ? IndexedColors.ORANGE : ("YES".equalsIgnoreCase(compliance) ? IndexedColors.GREEN : IndexedColors.GREY_50_PERCENT));
    }

    public List<String> getComponentHeaders() {
        assert (this.fU != null);
        return Arrays.asList(this.fU.t("scar_export_components_name"), this.fU.t("scar_export_components_description"), this.fU.t("scar_export_components_category"), this.fU.t("scar_export_source"), this.fU.t("scar_export_components_repository"), this.fU.t("scar_export_components_vulnerabilities"), this.fU.t("scar_export_components_licenses"), this.fU.t("scar_export_components_version"), this.fU.t("scar_export_components_latest_version"), this.fU.t("scar_export_components_obsolescence"), this.fU.t("scar_export_components_path"), this.fU.t("scar_export_references"), this.fU.t("scar_export_components_topics"), this.fU.t("scar_export_components_languages"), this.fU.t("scar_export_components_comments"));
    }

    public List<String> getFileHeaders() {
        assert (this.fU != null);
        return Arrays.asList(this.fU.t("scar_export_file_name"), this.fU.t("scar_export_component"), this.fU.t("scar_export_components_path"), this.fU.t("scar_export_file_size"), this.fU.t("scar_export_file_version"), this.fU.t("scar_export_licenses"), this.fU.t("scar_export_components_comments"));
    }

    public List<String> getLicenseHeaders() {
        assert (this.fU != null);
        return Arrays.asList(this.fU.t("scar_export_license_spdx_id"), this.fU.t("scar_export_title"), this.fU.t("scar_export_components_description"), this.fU.t("scar_export_components_category"), this.fU.t("scar_export_properties"), this.fU.t("scar_export_url"), this.fU.t("scar_export_text"));
    }

    public List<String> getVulnerabilitiesHeaders() {
        assert (this.fU != null);
        return Arrays.asList(this.fU.t("scar_export_vulnerability_name"), this.fU.t("scar_export_vulnerability_type"), this.fU.t("scar_export_vulnerabilities_severity"), this.fU.t("scar_export_vulnerability_cwe"), this.fU.t("scar_export_vulnerability_description"), this.fU.t("scar_export_vulnerability_published"), this.fU.t("scar_export_vulnerability_references"));
    }

    static {
        FALSE.setVal(false);
    }
}

