/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service;

import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.bom.dao.ProductDao;
import com.castsoftware.sca.scar.server.bom.dao.ProjectDao;
import com.castsoftware.sca.scar.server.bom.domain.ProjectVertex;
import com.castsoftware.sca.scar.server.bom.exception.BomExceptions;
import com.castsoftware.sca.scar.server.bom.model.NameFilter;
import com.castsoftware.sca.scar.server.bom.model.ProductView;
import com.castsoftware.sca.scar.server.bom.model.ProjectView;
import com.castsoftware.sca.scar.server.bom.model.VersionView;
import com.castsoftware.sca.scar.server.bom.model.request.BomBuildRequest;
import com.castsoftware.sca.scar.server.bom.transformer.BomBuildTransformer;
import com.castsoftware.sca.scar.server.bom.transformer.Products;
import com.castsoftware.sca.scar.server.bom.transformer.VersionTransformers;
import com.castsoftware.sca.scar.server.core.model.NamedView;
import com.castsoftware.sca.scar.server.orientdb.domain.NamedVertex;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.util.java.Functions;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProductService {
    private final ProductDao productDao;
    private final ProjectDao projectDao;
    private final ObjectMapper objectMapper;

    public ProductService(ProductDao productDao, ProjectDao projectDao, ObjectMapper objectMapper) {
        this.productDao = productDao;
        this.projectDao = projectDao;
        this.objectMapper = objectMapper;
    }

    public Collection<ProductView> getProducts(NameFilter filter) {
        return this.getElements(filter, () -> ((ProductDao)this.productDao).findAll(), arg_0 -> ((ProductDao)this.productDao).findByName(arg_0), arg_0 -> ((ProductDao)this.productDao).searchByName(arg_0), Products::from);
    }

    public ProductView getProduct(String id) {
        return this.productDao.findById(RequestUtils.decodeId((String)id)).map(Products::from).orElseThrow(() -> BomExceptions.productNotFound((String)id));
    }

    public Collection<ProjectView> getProjects(String productId, NameFilter filter) {
        String decodedProductId = RequestUtils.decodeId((String)productId);
        return this.getElements(filter, () -> this.projectDao.findAllByProduct(decodedProductId), name -> this.projectDao.findByProductAndName(decodedProductId, name), name -> this.projectDao.searchByProductAndName(decodedProductId, name), project -> Products.from((String)productId, (ProjectVertex)project));
    }

    public ProjectView getProject(String productId, String id) {
        ProjectView view = this.getProject(id);
        view.setProductId(productId);
        return view;
    }

    public ProjectView getProject(String id) {
        return this.projectDao.findById(RequestUtils.decodeId((String)id)).map(Products::from).orElseThrow(() -> BomExceptions.projectNotFound((String)id));
    }

    public BomBuildRequest getProjectLastBomBuildConfiguration(String id) {
        return this.projectDao.findBomBuildConfiguration(RequestUtils.decodeId((String)id)).stream().map(Functions.evictThrowable(s -> (BomWizardConfiguration)this.objectMapper.readValue(s, BomWizardConfiguration.class), (String)"invalid configuration. Maybe it's an older serialized configuration")).map(Optional::ofNullable).filter(Optional::isPresent).map(Optional::get).map(BomBuildTransformer::from).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public List<VersionView> getProjectVersions(String projectId) {
        return this.projectDao.findAllVersionInfo(RequestUtils.decodeId((String)projectId)).stream().map(VersionTransformers::from).collect(Collectors.toList());
    }

    private <MODEL extends NamedView, DOMAIN extends NamedVertex> List<MODEL> getElements(NameFilter filter, Supplier<List<DOMAIN>> all, Function<String, Optional<DOMAIN>> findByName, Function<String, List<DOMAIN>> searchByName, Function<DOMAIN, MODEL> transform) {
        List<DOMAIN> elements;
        if (filter != null && StringUtils.isNotBlank((CharSequence)filter.getName())) {
            String name = filter.getName();
            elements = filter.isStrict() ? findByName.apply(name).map(xva$0 -> Arrays.asList(xva$0)).orElseGet(ArrayList::new) : searchByName.apply(name);
        } else {
            elements = all.get();
        }
        return elements.stream().map(transform).collect(Collectors.toList());
    }
}

