/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.model.BomView;
import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.bom.model.request.FileUpdateRequest;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.bom.transformer.Boms;
import com.castsoftware.sca.scar.server.bom.transformer.FilesTransformer;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.component.handler.ComponentTransforms;
import com.castsoftware.sca.scar.server.component.model.FullComponentView;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.util.java.Guards;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FileService {
    private final FileDao fileDao;
    private final BomDao bomDao;
    private final ComponentDao componentDao;
    private final LicenseDao licenseDao;
    private final KPIComputer kpiComputer;

    public FileService(FileDao fileDao, BomDao bomDao, ComponentDao componentDao, LicenseDao licenseDao, KPIComputer kpiComputer) {
        this.fileDao = fileDao;
        this.bomDao = bomDao;
        this.componentDao = componentDao;
        this.licenseDao = licenseDao;
        this.kpiComputer = kpiComputer;
    }

    public FileView getFile(String id, boolean fullView) {
        FileVertex fileVertex = (FileVertex)this.fileDao.findByIdWithLicense(RequestUtils.decodeId((String)id)).orElseThrow(NoSuchElementException::new);
        BomVertex bomVertex = (BomVertex)this.bomDao.findByFile(fileVertex.getId()).orElseThrow(IllegalStateException::new);
        Map<String, ComplianceLevel> mapping = this.licenseDao.findBomLicenses(bomVertex.getId()).stream().collect(Collectors.toMap(LicenseVertex::getSpdxId, BomLicenseVertex::getComplianceLevel));
        return fullView ? FilesTransformer.from((FileVertex)fileVertex, mapping, (FullComponentView)ComponentTransforms.from((ComponentVertex)((ComponentVertex)this.componentDao.findByFileWithLV(fileVertex.getId()).orElseThrow(IllegalStateException::new)), (BomView)Boms.from((BomVertex)bomVertex), mapping)) : FilesTransformer.from((FileVertex)fileVertex, mapping);
    }

    public void updateFile(String id, FileUpdateRequest request) {
        boolean hasChangedLicenses;
        Guards.notNull((Object)request);
        FileVertex fileVertex = (FileVertex)this.fileDao.findByIdWithLicense(RequestUtils.decodeId((String)id)).orElseThrow(NoSuchElementException::new);
        BomVertex bomVertex = (BomVertex)this.bomDao.findByFile(fileVertex.getId()).orElseThrow(IllegalStateException::new);
        BomComponentVertex componentVertex = this.componentDao.findByFileWithLV(fileVertex.getId()).filter(BomComponentVertex.class::isInstance).map(BomComponentVertex.class::cast).orElseThrow(NoSuchElementException::new);
        List currentLicenses = Objects.requireNonNullElse(request.getLicenses(), List.of());
        boolean bl = hasChangedLicenses = !fileVertex.getLicenses().stream().map(LicenseVertex::getSpdxId).toList().equals(currentLicenses);
        if (hasChangedLicenses) {
            fileVertex.setLicenses(currentLicenses.stream().map(arg_0 -> ((LicenseDao)this.licenseDao).findBySpdxId(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        }
        this.fileDao.withTransaction(session -> {
            fileVertex.setVersion(StringUtils.defaultString((String)request.getVersion()));
            fileVertex.setComments(StringUtils.defaultString((String)request.getComments()));
            fileVertex.setCopyright(StringUtils.defaultString((String)request.getCopyright()));
            bomVertex.setUpdated(Instant.now());
            this.fileDao.save((Vertex)fileVertex, session);
            this.bomDao.save((Vertex)bomVertex, session);
            if (hasChangedLicenses) {
                this.fileDao.unlinkAll((Vertex)fileVertex, (EClassDefinition)BOMClassDefinition.E.ELicense, session);
                fileVertex.getLicenses().forEach(l -> this.fileDao.addLicense(fileVertex, l, session));
                if (Boolean.TRUE.equals(request.getUpdateComponent())) {
                    List<String> componentLicenses = componentVertex.getLicenses().stream().map(LicenseVertex::getSpdxId).toList();
                    fileVertex.getLicenses().stream().filter(l -> !componentLicenses.contains(l.getSpdxId())).forEach(l -> this.componentDao.link((Vertex)componentVertex, (Vertex)l, (EClassDefinition)BOMClassDefinition.E.ELicense, session));
                }
            }
        });
        if (hasChangedLicenses) {
            this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
        }
    }

    public Collection<FileView> searchBySha256(String sha256, boolean onlyBoms) {
        return this.fileDao.findBySha256(sha256).stream().map(f -> FilesTransformer.from((FileVertex)f, null, (FullComponentView)ComponentTransforms.from((ComponentVertex)((ComponentVertex)this.componentDao.findByFileWithLV(f.getId()).orElseThrow(IllegalStateException::new)), (BomView)this.bomDao.findById(((BomVertex)this.bomDao.findByFile(f.getId()).orElseThrow(IllegalStateException::new)).getId()).map(Boms::from).orElseThrow(IllegalStateException::new)))).filter(fv -> !onlyBoms || fv.getComponent().getBom().getVersion() != null).collect(Collectors.toList());
    }
}

