/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service;

import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.api.model.request.catalog.AddRequest;
import com.castsoftware.sca.scar.server.api.model.request.catalog.CatalogRequest;
import com.castsoftware.sca.scar.server.api.model.request.catalog.ChangePolicyRequest;
import com.castsoftware.sca.scar.server.api.model.request.catalog.RemoveRequest;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.CatalogAdd;
import com.castsoftware.sca.scar.server.bom.domain.CatalogBomVertex;
import com.castsoftware.sca.scar.server.bom.exception.BomExceptions;
import com.castsoftware.sca.scar.server.bom.handler.CatalogWriter;
import com.castsoftware.sca.scar.server.bom.model.CatalogView;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.bom.transformer.Products;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.scar.server.util.task.TaskExecutor;
import com.castsoftware.sca.scar.server.util.task.TaskRunnable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CatalogService
implements CatalogRequest.CatalogRequestVisitor {
    private final CentralDao centralDao;
    private final BomDao bomDao;
    private final ComponentDao componentDao;
    private final LicensePolicyDao licensePolicyDao;
    private final KPIComputer kpiComputer;
    private final TaskExecutor<CatalogAdd> catalogAddExecutor;
    private final CatalogWriter catalogWriter;

    public CatalogService(CentralDao centralDao, BomDao bomDao, ComponentDao componentDao, LicensePolicyDao licensePolicyDao, KPIComputer kpiComputer, TaskExecutor<CatalogAdd> catalogAddExecutor, CatalogWriter catalogWriter) {
        this.centralDao = centralDao;
        this.bomDao = bomDao;
        this.componentDao = componentDao;
        this.licensePolicyDao = licensePolicyDao;
        this.kpiComputer = kpiComputer;
        this.catalogAddExecutor = catalogAddExecutor;
        this.catalogWriter = catalogWriter;
    }

    public CatalogView getCatalog() {
        return Optional.ofNullable(this.centralDao.getCatalogWithPolicy()).map(CatalogService::from).orElseThrow(BomExceptions::catalogNotFound);
    }

    public void updateCatalog(@NonNull CatalogRequest request) {
        request.accept((CatalogRequest.CatalogRequestVisitor)this);
    }

    public void visit(AddRequest addRequest) {
        this.catalogAddExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void visit(RemoveRequest removeRequest) {
        HashSet bomsToUpdate = new HashSet();
        Optional.ofNullable(removeRequest).map(CatalogRequest::getComponentIds).orElseGet(ArrayList::new).stream().map(RequestUtils::decodeId).forEach(id -> bomsToUpdate.addAll(Objects.requireNonNull(this.removeComponentFromCatalog(id))));
        bomsToUpdate.forEach(bomId -> this.bomDao.findById(bomId).ifPresent(x$0 -> this.kpiComputer.computeBasicKPIBackground(x$0, new EventListener[0])));
    }

    public void visit(ChangePolicyRequest changePolicyRequest) {
        String policyId = Optional.ofNullable(changePolicyRequest).map(ChangePolicyRequest::getPolicyId).orElseThrow(IllegalStateException::new);
        LicensePolicyVertex policy = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)policyId)).orElseThrow(NoSuchElementException::new);
        BomVertex catalog = Optional.ofNullable(this.centralDao.getCatalog()).orElseThrow(NoSuchElementException::new);
        this.bomDao.withTransaction(session -> {
            this.bomDao.unlinkAll((Vertex)catalog, (EClassDefinition)BOMClassDefinition.E.EPolicy, session);
            this.bomDao.link((Vertex)catalog, (Vertex)policy, (EClassDefinition)BOMClassDefinition.E.EPolicy, session);
        });
    }

    private Set<String> removeComponentFromCatalog(String id) {
        if (this.bomDao.findByComponent(id).filter(BomVertex::isCatalog).isPresent()) {
            ComponentVertex componentVertex = (ComponentVertex)this.componentDao.findById(id).orElseThrow(NoSuchElementException::new);
            List linkedComponents = this.componentDao.findByLink(id, BOMClassDefinition.V.VComponent, BOMClassDefinition.E.EFrom);
            this.componentDao.withTransaction(session -> {
                this.componentDao.deleteSnippets(componentVertex, session);
                this.componentDao.deleteFiles(componentVertex, session);
                this.componentDao.delete((Vertex)componentVertex, session);
                linkedComponents.forEach(c -> {
                    c.setSource(BomSource.LOCAL.name());
                    this.componentDao.save((Vertex)c, session);
                });
            });
            return linkedComponents.stream().map(c -> this.bomDao.findByComponent(c.getId())).flatMap(Optional::stream).filter(Objects::nonNull).map(Vertex::getId).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private static @NonNull CatalogView from(BomVertex vertex) {
        return Optional.ofNullable(vertex).filter(v -> CatalogBomVertex.class.isAssignableFrom(v.getClass())).map(CatalogBomVertex.class::cast).map(cbv -> new CatalogView(cbv.getId(), VertexUtils.encodeId((Vertex)cbv), Products.from((LicensePolicyVertex)cbv.getLicensePolicy()))).orElseGet(() -> new CatalogView(vertex.getId(), VertexUtils.encodeId((Vertex)vertex), null));
    }
}

