/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service;

import com.castsoftware.sca.scar.server.analyzer.BomCreator;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.FileFilter;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.FileScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PreviousScanOptions;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.ScaScanOptions;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.SCArApplication;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.domain.BomBuild;
import com.castsoftware.sca.scar.server.bom.domain.BomDelete;
import com.castsoftware.sca.scar.server.bom.domain.BomExport;
import com.castsoftware.sca.scar.server.bom.domain.BomExportConfiguration;
import com.castsoftware.sca.scar.server.bom.domain.BomExportData;
import com.castsoftware.sca.scar.server.bom.domain.BomExportFormat;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.FullBomVertex;
import com.castsoftware.sca.scar.server.bom.exception.BomCreationLimitExceededException;
import com.castsoftware.sca.scar.server.bom.exception.BomExceptions;
import com.castsoftware.sca.scar.server.bom.exception.UnsupportedExtensionException;
import com.castsoftware.sca.scar.server.bom.exception.UploadException;
import com.castsoftware.sca.scar.server.bom.exception.WorkspaceInitializationException;
import com.castsoftware.sca.scar.server.bom.handler.BomBuildMonitor;
import com.castsoftware.sca.scar.server.bom.handler.BomExportMonitor;
import com.castsoftware.sca.scar.server.bom.handler.BomExporter;
import com.castsoftware.sca.scar.server.bom.handler.BomWriter;
import com.castsoftware.sca.scar.server.bom.handler.ProductWriter;
import com.castsoftware.sca.scar.server.bom.model.build.BomBuildExecutorView;
import com.castsoftware.sca.scar.server.bom.model.build.BomBuildTaskView;
import com.castsoftware.sca.scar.server.bom.model.export.BomExportExecutorView;
import com.castsoftware.sca.scar.server.bom.model.export.BomExportTaskView;
import com.castsoftware.sca.scar.server.bom.model.request.BomBuildRequest;
import com.castsoftware.sca.scar.server.bom.model.request.BomExportRequest;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.transformer.Builds;
import com.castsoftware.sca.scar.server.bom.transformer.Exports;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.message.Message;
import com.castsoftware.sca.scar.server.message.MessageService;
import com.castsoftware.sca.scar.server.message.MessageSource;
import com.castsoftware.sca.scar.server.message.MessageType;
import com.castsoftware.sca.scar.server.monitoring.handler.ProgressMonitor;
import com.castsoftware.sca.scar.server.sam.domain.SBomConfiguration;
import com.castsoftware.sca.scar.server.sam.domain.SamAccount;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkState;
import com.castsoftware.sca.scar.server.sam.handler.SamLinkContext;
import com.castsoftware.sca.scar.server.sam.handler.SamUsageStatsUpdater;
import com.castsoftware.sca.scar.server.system.resolver.PathResolver;
import com.castsoftware.sca.scar.server.util.Normalizes;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.scar.server.util.task.TaskExecutor;
import com.castsoftware.sca.scar.server.util.task.TaskRunnable;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;

public class BomTaskService {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(BomTaskService.class);
    private static final Integer MAX_BOMS_ALLOWED = 5;
    public static final String CYCLONE_DX = "cyclone_dx";
    public static final Set<String> ARCHIVE_EXTENSIONS = new HashSet<String>(Arrays.asList(".zip", ".jar", ".tar", ".tar.gz", ".tgz", ".tar.xz", ".txz"));
    public static final Set<String> CYCLONE_DX_EXTENSIONS = new HashSet<String>(Arrays.asList(".xml", ".json"));
    private final BomDao bomDao;
    private final BomCreator bomCreator;
    private final BomWriter bomWriter;
    private final BomExporter bomExporter;
    private final ProductWriter productWriter;
    private final PathResolver pathResolver;
    private final KPIComputer kpiComputer;
    private final SamUsageStatsUpdater usageStatsUpdater;
    private final MessageService messageService;
    private final TaskExecutor<BomBuild> bomBuildExecutor;
    private final TaskExecutor<BomDelete> bomDeleteExecutor;
    private final TaskExecutor<BomExport> bomExportExecutor;
    final FilesUtils filesUtils;

    public BomTaskService(BomDao bomDao, BomCreator bomCreator, BomWriter bomWriter, BomExporter bomExporter, ProductWriter productWriter, PathResolver pathResolver, KPIComputer kpiComputer, SamUsageStatsUpdater usageStatsUpdater, MessageService messageService, TaskExecutor<BomBuild> bomBuildExecutor, TaskExecutor<BomDelete> bomDeleteExecutor, TaskExecutor<BomExport> bomExportExecutor, FilesUtils filesUtils) {
        this.bomDao = bomDao;
        this.bomCreator = bomCreator;
        this.bomWriter = bomWriter;
        this.bomExporter = bomExporter;
        this.productWriter = productWriter;
        this.pathResolver = pathResolver;
        this.kpiComputer = kpiComputer;
        this.usageStatsUpdater = usageStatsUpdater;
        this.messageService = messageService;
        this.bomBuildExecutor = bomBuildExecutor;
        this.bomDeleteExecutor = bomDeleteExecutor;
        this.bomExportExecutor = bomExportExecutor;
        this.filesUtils = filesUtils;
    }

    public BomBuildExecutorView getBomBuildExecutor() {
        return new BomBuildExecutorView(this.bomBuildExecutor.isBusy() == false);
    }

    public Collection<BomBuildTaskView> getBomBuildTasks() {
        return this.bomBuildExecutor.getTasks().values().stream().map(Builds::monitor).collect(Collectors.toCollection(ArrayList::new));
    }

    public BomBuildTaskView getBomBuildTask(String id) {
        return (BomBuildTaskView)Opt.ofNullable((Object)((BomBuild)this.bomBuildExecutor.getTasks().get(id))).map(Builds::monitor).orElseThrow(NoSuchElementException::new);
    }

    public String processBomArchiveUpload(String sourceType, String fileName, InputStream fileInputStream) {
        Set extensions = CYCLONE_DX.equals(sourceType) ? CYCLONE_DX_EXTENSIONS : ARCHIVE_EXTENSIONS;
        Path tempFile = Opt.ofNullable((Object)fileName).filter(name -> !name.startsWith(".")).flatMap(name -> extensions.stream().filter(name::endsWith).findFirst()).map(ext -> this.resolveWorkspacePath(String.format("%d-%s", new Date().getTime(), fileName))).orElseThrow(() -> new UnsupportedExtensionException(fileName));
        try {
            this.writeToFile(fileInputStream, tempFile);
        }
        catch (IOException e) {
            throw new UploadException(fileName, (Throwable)e);
        }
        return Normalizes.encodeBase64URL((String)tempFile.toString());
    }

    private Path resolveWorkspacePath(String fileName) {
        Path workspace = ((Path)SCArApplication.defaultResourceLocation(Path::toAbsolutePath)).resolve("workspace");
        if (!Files.exists(workspace, new LinkOption[0])) {
            try {
                Files.createDirectories(workspace, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WorkspaceInitializationException((Throwable)e);
            }
        }
        return workspace.resolve(fileName);
    }

    private void writeToFile(InputStream uploadedInputStream, Path uploadedFilePath) throws IOException {
        int read;
        byte[] bytes = new byte[1024];
        OutputStream out = Files.newOutputStream(uploadedFilePath, new OpenOption[0]);
        while ((read = uploadedInputStream.read(bytes)) != -1) {
            out.write(bytes, 0, read);
        }
        out.flush();
        out.close();
    }

    private BomWizardConfiguration initBomBuild(BomBuildRequest bomBuildRequest) {
        BomWizardConfiguration configuration = new BomWizardConfiguration();
        configuration.setProduct(Guards.notBlank((String)bomBuildRequest.getProduct()));
        configuration.setProject(Guards.notBlank((String)bomBuildRequest.getProject()));
        configuration.setVersion(Guards.notBlank((String)bomBuildRequest.getVersion()));
        configuration.setLicensePolicy((String)Guards.notNull((Object)bomBuildRequest.getLicensePolicy()));
        return configuration;
    }

    public String createBomBuildTask(BomBuildRequest bomBuildRequest) {
        Guards.notNull((Object)bomBuildRequest, (String)"Invalid SBOM creation request");
        if (this.isBomLimitReached()) {
            throw new BomCreationLimitExceededException();
        }
        BomWizardConfiguration configuration = this.initBomBuild(bomBuildRequest);
        this.configureSourceScanner(bomBuildRequest, configuration);
        this.configureOptionalScanner(bomBuildRequest, configuration);
        Function<String, BomBuild> createTask = executionId -> {
            BomBuild bomBuild = new BomBuild(executionId, new ProgressMonitor(), configuration);
            configuration.setListener((EventListener)new BomBuildMonitor(bomBuild));
            return bomBuild;
        };
        return this.bomBuildExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void notifyScanSuccess(@NonNull BomBuild bomBuild) {
        BomWizardConfiguration config = bomBuild.getConfiguration();
        try {
            Message message = new Message();
            message.setMessage(String.format("A new SBOM has been created for '%s / %s / %s'", config.getProduct(), config.getProject(), config.getVersion()));
            message.setType(MessageType.SBOM_CREATED);
            message.setSource(MessageSource.LOCAL);
            message.addAction(String.format("/boms/%s", Normalizes.encodeBase64URL((String)((BomVertex)bomBuild.getBuilt().orElseThrow(IllegalStateException::new)).getId())), "View SBOM");
            this.messageService.createMessage(message);
        }
        catch (Exception e) {
            LOGGER.warn("Message creation failed: {}", (Object)e.getMessage());
        }
    }

    private void notifyScanFailure(@NonNull BomWizardConfiguration config, @NonNull String phase) {
        try {
            Message message = new Message();
            message.setMessage(String.format("Your SBOM scan for '%s / %s / %s' has failed during the %s phase", config.getProduct(), config.getProject(), config.getVersion(), phase));
            message.setType(MessageType.SBOM_SCAN_FAILED);
            message.setSource(MessageSource.LOCAL);
            this.messageService.createMessage(message);
        }
        catch (Exception e) {
            LOGGER.warn("Message creation failed: {}", (Object)e.getMessage());
        }
    }

    public void createBomDeleteTask(String encodedBomId) {
        FullBomVertex bomVertex = this.bomDao.findById(RequestUtils.decodeId((String)encodedBomId)).filter(FullBomVertex.class::isInstance).map(FullBomVertex.class::cast).orElseThrow(NoSuchElementException::new);
        this.bomWriter.preDeleteUnlinkBom(bomVertex);
        BomDelete bomDelete = new BomDelete(bomVertex.getProduct().getName(), bomVertex.getProject().getName(), (String)bomVertex.getVersion().getProperty("name"));
        this.bomDeleteExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public BomExportExecutorView getBomExportExecutor() {
        return new BomExportExecutorView(this.bomExportExecutor.isBusy() == false);
    }

    public Collection<BomExportTaskView> getBomExportTasks() {
        return this.bomExportExecutor.getTasks().values().stream().map(Exports::monitor).collect(Collectors.toList());
    }

    public BomExportTaskView getBomExportTask(String id) {
        return (BomExportTaskView)Opt.ofNullable((Object)((BomExport)this.bomExportExecutor.getTasks().get(id))).map(Exports::monitor).orElseThrow(NoSuchElementException::new);
    }

    public String createBomExportTask(String bomId, BomExportRequest bomExportRequest) throws IllegalAccessException, JSONException {
        BomExportConfiguration configuration = new BomExportConfiguration();
        FullBomVertex bomVertex = this.bomDao.findById(RequestUtils.decodeId((String)bomId)).filter(FullBomVertex.class::isInstance).map(FullBomVertex.class::cast).orElseThrow(() -> BomExceptions.bomNotFound((String)bomId));
        configuration.setProduct(bomVertex.getProduct().getName());
        configuration.setProject(bomVertex.getProject().getName());
        configuration.setVersion((String)bomVertex.getVersion().getProperty("name"));
        configuration.setSourcePath(this.extractBomVertexSourcePath(bomVertex));
        configuration.setExportComponents(bomExportRequest.isExportComponents());
        configuration.setExportFiles(bomExportRequest.isExportFiles());
        configuration.setExportKpis(bomExportRequest.isExportKPIs());
        configuration.setExportData(BomExportData.valueOf((String)bomExportRequest.getExportData().toUpperCase()));
        configuration.setExportFormat(BomExportFormat.valueOf((String)bomExportRequest.getExportFormat().toUpperCase()));
        configuration.setExportCategories(bomExportRequest.getExportCategories());
        Function<String, BomExport> createTask = executionId -> {
            BomExport export = new BomExport(executionId, configuration, new ProgressMonitor());
            configuration.setListener((EventListener)new BomExportMonitor(export, this.filesUtils));
            return export;
        };
        return this.bomExportExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String extractBomVertexSourcePath(@NonNull FullBomVertex bomVertex) {
        String scanPropertyData = (String)bomVertex.getVertex().getProperty("scan");
        String sourcePath = "";
        if (StringUtils.isNotEmpty((CharSequence)scanPropertyData)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode jsonNode = mapper.readTree(scanPropertyData);
                sourcePath = jsonNode.get("sourcePath").asText();
            }
            catch (IOException e) {
                LOGGER.info("Json could not be parsed");
            }
        }
        return sourcePath;
    }

    private boolean isBomLimitReached() {
        Integer maxBoms = Optional.of(SamLinkContext.get()).map(SamLinkState::getSamAccount).map(SamAccount::getSbomConfiguration).map(SBomConfiguration::getMaxSBoms).orElse(MAX_BOMS_ALLOWED);
        Integer currentBoms = this.bomDao.countAll().map(Long::intValue).orElseThrow(Suppliers.illegalState((String)"Cannot count available BOMs"));
        Integer currentScans = this.getBomBuildTasks().size();
        return currentBoms + currentScans >= maxBoms;
    }

    private void configureSourceScanner(@NonNull BomBuildRequest bomBuildRequest, BomWizardConfiguration configuration) {
        Opt.ofNullable((Object)bomBuildRequest.getSource()).map(Functions.peek(sourceConfig -> {
            if (sourceConfig.getUrlId() != null) {
                configuration.setSourcePath(Normalizes.decodeBase64URL((String)sourceConfig.getUrlId()));
            } else {
                PathResolver.PathType pathType = sourceConfig.getFileId() != null ? PathResolver.PathType.FILE : PathResolver.PathType.FOLDER;
                configuration.setSourcePath(Opt.of((Object)pathType).map(pt -> PathResolver.PathType.FILE.equals(pt) ? sourceConfig.getFileId() : sourceConfig.getFolderId()).map(id -> this.pathResolver.findPath(id, pathType)).orElseThrow(Suppliers.illegalArgument((String)"invalid source path")).toString());
            }
        })).ifPresent(sourceConfig -> {
            configuration.setSourceType(BomWizardConfiguration.SourceType.stream().filter(st -> st.name().equals(sourceConfig.getType())).findAny().orElse(BomWizardConfiguration.SourceType.FILE));
            configuration.setSourceOptions(sourceConfig.getOptions());
            if (!BomWizardConfiguration.SourceType.HLCSV.equals((Object)configuration.getSourceType()) && !BomWizardConfiguration.SourceType.CYCLONE_DX.equals((Object)configuration.getSourceType())) {
                this.configureFileScanner(configuration, sourceConfig);
            }
        });
    }

    private void configureFileScanner(@NonNull BomWizardConfiguration configuration, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomBuildRequest.SourceConfiguration sourceConfig) {
        FileScanOptions fileScanOptions = new FileScanOptions();
        Opt.ofNullable((Object)sourceConfig.getFilters()).ifPresent(f -> {
            FileFilter fileFilter = new FileFilter();
            Opt.ofNullable((Object)f.getType()).filter(Predicates.notEmptyString()).map(FileFilter.FilterType::valueOf).filter(ft -> ft.equals((Object)FileFilter.FilterType.INCLUDE)).ifPresent(ft -> fileFilter.setInclude());
            Opt.ofNullable((Object)f.getLines()).ifPresent(fls -> fls.forEach(fl -> Opt.ofNullable((Object)fl.getKey()).filter(Predicates.notEmptyString()).map(FileFilter.LineFilter::valueOf).ifPresent(k -> fileFilter.addLineFilter(k, fl.getValue()))));
            fileScanOptions.setFilters(fileFilter);
        });
        Opt.ofNullable((Object)sourceConfig.getExceptions()).ifPresent(e -> {
            Guards.notNull((Object)fileScanOptions.getFilters(), (Supplier)Suppliers.illegalConfiguration((String)"Filter exceptions defined but no filter found"));
            FileFilter exceptFilter = new FileFilter();
            Opt.ofNullable((Object)e.getLines()).ifPresent(fls -> fls.forEach(fl -> Opt.ofNullable((Object)fl.getKey()).filter(Predicates.notEmptyString()).map(FileFilter.LineFilter::valueOf).ifPresent(k -> exceptFilter.addLineFilter(k, fl.getValue()))));
            fileScanOptions.setExceptions(exceptFilter);
        });
        configuration.setFileOptions(fileScanOptions);
    }

    private void configureOptionalScanner(@NonNull BomBuildRequest bomBuildRequest, BomWizardConfiguration configuration) {
        Opt.ofNullable((Object)bomBuildRequest.getScanners()).ifPresent(scannersConfig -> {
            configuration.setOnlyPackage(scannersConfig.isOnlyPackage());
            Opt.ofNullable((Object)scannersConfig.getPackages()).filter(BomBuildRequest.ScannerConfiguration::isEnabled).ifPresent(packageScannerConfiguration -> {
                configuration.setUsePackage(true);
                Opt.ofNullable((Object)packageScannerConfiguration.getOptions()).ifPresent(packageConfigurations -> {
                    PackageScanOptions packageOptions = new PackageScanOptions();
                    packageConfigurations.forEach(packageConfiguration -> {
                        PackageOption packageOption = new PackageOption();
                        Opt.ofNullable((Object)packageConfiguration.getType()).ifPresent(arg_0 -> ((PackageOption)packageOption).setType(arg_0));
                        Opt.ofNullable((Object)packageConfiguration.getSearch()).filter(Predicates.notEmptyString()).map(PackageOption.PackageSearch::valueOf).ifPresent(arg_0 -> ((PackageOption)packageOption).setSearch(arg_0));
                        Opt.ofNullable((Object)packageConfiguration.getFile()).filter(Predicates.notEmptyString()).ifPresent(arg_0 -> ((PackageOption)packageOption).setFile(arg_0));
                        Opt.of((Object)packageConfiguration.isAllowExternal()).ifPresent(arg_0 -> ((PackageOption)packageOption).setAllowExternal(arg_0));
                        Opt.of((Object)packageConfiguration.isOnlyDirect()).ifPresent(arg_0 -> ((PackageOption)packageOption).setOnlyDirect(arg_0));
                        packageOptions.addPackageOption(packageOption);
                    });
                    configuration.setPackageOptions(packageOptions);
                });
            });
            Opt.ofNullable((Object)scannersConfig.getPrevious()).filter(BomBuildRequest.ScannerConfiguration::isEnabled).ifPresent(previousConfiguration -> {
                configuration.setUsePrevious(true);
                Opt.ofNullable((Object)previousConfiguration.getPreviousId()).filter(Predicates.notEmptyString()).map(PreviousScanOptions::new).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).setPreviousOptions(arg_0));
            });
            Opt.ofNullable((Object)scannersConfig.getCatalog()).filter(BomBuildRequest.ScannerConfiguration::isEnabled).ifPresent(c -> configuration.setUseCatalog(true));
            Opt.ofNullable((Object)scannersConfig.getSca()).filter(BomBuildRequest.ScannerConfiguration::isEnabled).ifPresent(c -> {
                configuration.setUseSca(true);
                if (configuration.isOnlyPackage()) {
                    configuration.setScaOptions(new ScaScanOptions(ScaScanOptions.ScaLevelType.FULL_DETECT));
                } else {
                    Opt.ofNullable((Object)c.getLevel()).filter(Predicates.notEmptyString()).map(ScaScanOptions.ScaLevelType::valueOf).map(ScaScanOptions::new).ifPresent(arg_0 -> ((BomWizardConfiguration)configuration).setScaOptions(arg_0));
                }
            });
        });
    }
}

