/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.service;

import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.FolderDao;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.CategoryInfo;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.NodeVertex;
import com.castsoftware.sca.scar.server.bom.exception.BomExceptions;
import com.castsoftware.sca.scar.server.bom.handler.DisplayNameResolver;
import com.castsoftware.sca.scar.server.bom.model.BomView;
import com.castsoftware.sca.scar.server.bom.model.CategoryView;
import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.bom.model.FolderView;
import com.castsoftware.sca.scar.server.bom.model.NodeView;
import com.castsoftware.sca.scar.server.bom.model.request.ChangeComponentsCategoryRequest;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.bom.transformer.Boms;
import com.castsoftware.sca.scar.server.bom.transformer.CategoryTransformer;
import com.castsoftware.sca.scar.server.bom.transformer.FilesTransformer;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.component.handler.ComponentTransforms;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.core.dao.FindConfiguration;
import com.castsoftware.sca.scar.server.core.model.request.GetRequest;
import com.castsoftware.sca.scar.server.core.transformer.FindConfigurationTransformers;
import com.castsoftware.sca.scar.server.kpi.dao.KPIDao;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.kpi.model.KPIsView;
import com.castsoftware.sca.scar.server.kpi.transformer.KpiTransformer;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.license.transformer.LicenseTransformer;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.util.Normalizes;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.StreamUtils;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.Predicates;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class BomService {
    private final BomDao bomDao;
    private final ComponentDao componentDao;
    private final FolderDao folderDao;
    private final FileDao fileDao;
    private final LicenseDao licenseDao;
    private final LicensePolicyDao licensePolicyDao;
    private final KPIDao kpiDao;
    private final KPIComputer kpiComputer;
    private final DisplayNameResolver displayNameResolver;
    private static final ReentrantLock lock = new ReentrantLock();

    public BomService(BomDao bomDao, ComponentDao componentDao, FolderDao folderDao, FileDao fileDao, LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, KPIDao kpiDao, KPIComputer kpiComputer, DisplayNameResolver displayNameResolver) {
        this.bomDao = bomDao;
        this.componentDao = componentDao;
        this.folderDao = folderDao;
        this.fileDao = fileDao;
        this.licenseDao = licenseDao;
        this.licensePolicyDao = licensePolicyDao;
        this.kpiDao = kpiDao;
        this.kpiComputer = kpiComputer;
        this.displayNameResolver = displayNameResolver;
    }

    public Collection<BomView> getAllBoms() {
        return this.bomDao.findAll().stream().map(Boms::from).collect(Collectors.toList());
    }

    public BomView getBom(String id) {
        return this.bomDao.findById(RequestUtils.decodeId((String)id)).map(Boms::from).orElseThrow(() -> BomExceptions.bomNotFound((String)id));
    }

    public Collection<CategoryView> getCategories(String bomId) {
        HashSet refs = new HashSet();
        List views = this.bomDao.findCategoryInfo(RequestUtils.decodeId((String)bomId)).stream().peek(categoryInfo -> refs.add(categoryInfo.getReference())).map(categoryInfo -> CategoryTransformer.from((DisplayNameResolver)this.displayNameResolver, (CategoryInfo)categoryInfo, (String)bomId)).collect(Collectors.toList());
        DefaultCategory.stream().filter(Predicates.negate(c -> refs.contains(c.name()))).map(c -> CategoryTransformer.from((DefaultCategory)c, (String)bomId)).forEach(views::add);
        return views.stream().sorted(Comparator.comparingInt(cv -> DefaultCategory.valueOf((String)cv.getOriginalId().toUpperCase()).getDisplayOrder())).collect(Collectors.toList());
    }

    public Collection<ComponentView> getComponents(String bomId, GetRequest paginationRequest) {
        return this.getComponents(bomId, null, paginationRequest);
    }

    public Collection<ComponentView> getComponents(String bomId, String categoryName, GetRequest paginationRequest) {
        Optional<GetRequest> optionalGetRequest = Optional.ofNullable(paginationRequest);
        String decodeBomId = RequestUtils.decodeId((String)bomId);
        Map mapping = this.getAllBomLicenseComplianceLevel(bomId);
        return this.componentDao.findBomComponents(decodeBomId, Opt.ofBlankString((String)categoryName).map(Normalizes::decodeBase64URL).orElse(categoryName), optionalGetRequest.map(FindConfigurationTransformers::from).orElseGet(FindConfiguration::new)).stream().map(c -> ComponentTransforms.from((BomComponentVertex)c, (String)bomId, (Map)mapping)).collect(Collectors.toList());
    }

    public ComponentView getComponent(String bomId, String id) {
        String decodeId = RequestUtils.decodeId((String)id);
        Map mapping = this.getAllBomLicenseComplianceLevel(bomId);
        return this.componentDao.findByIdWithLV(decodeId).map(c -> ComponentTransforms.from((BomComponentVertex)c, (String)bomId, (Map)mapping)).orElseThrow(() -> BomExceptions.componentNotFound((String)id));
    }

    public Collection<FileView> getComponentFiles(String bomId, String id) {
        String decodeId = RequestUtils.decodeId((String)id);
        Map mapping = this.getAllBomLicenseComplianceLevel(bomId);
        return this.fileDao.findByComponentWithLicense(decodeId).stream().map(fileVertex -> FilesTransformer.from((FileVertex)fileVertex, (Map)mapping)).collect(Collectors.toList());
    }

    public FolderView getRootNode(String bomId) {
        return this.bomDao.findRootNode(RequestUtils.decodeId((String)bomId)).map(fv -> new FolderView(fv.getId(), VertexUtils.encodeId((Vertex)fv), fv.getName(), bomId)).orElseThrow(() -> BomExceptions.rootNodeNotFound((String)bomId));
    }

    public Collection<NodeView> getNodeChildren(String bomId, String id) {
        Map mapping = this.getAllBomLicenseComplianceLevel(Guards.notBlank((String)bomId));
        return this.folderDao.findChildren(RequestUtils.decodeId((String)id)).stream().map(nv -> FilesTransformer.from((NodeVertex)nv, (String)bomId, (Map)mapping)).collect(Collectors.toList());
    }

    public void updateLicensePolicy(String bomId, String policyId) {
        Guards.notBlank((String)policyId);
        BomVertex bom = (BomVertex)this.bomDao.findById(RequestUtils.decodeId((String)bomId)).orElseThrow(() -> BomExceptions.bomNotFound((String)bomId));
        LicensePolicyVertex policy = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)policyId)).orElseThrow(NoSuchElementException::new);
        this.bomDao.withTransaction(session -> {
            bom.setUpdated(Instant.now());
            this.bomDao.save((Vertex)bom, session);
            this.bomDao.unlinkAll((Vertex)bom, (EClassDefinition)BOMClassDefinition.E.EPolicy, session);
            this.bomDao.link((Vertex)bom, (Vertex)policy, (EClassDefinition)BOMClassDefinition.E.EPolicy, session);
        });
        this.kpiComputer.computeLicenseKPIBackground(bom, new EventListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponentsCategory(String bomId, ChangeComponentsCategoryRequest changeCategory) {
        Guards.notNull((Object)changeCategory, (String)"changeCategory request is mandatory");
        if (Optional.ofNullable(changeCategory.getComponentIds()).filter(Predicates.notEmptyCollection()).isEmpty()) {
            return;
        }
        String category = Opt.ofBlankString((String)changeCategory.getCategory()).map(Functions.evictThrowable(DefaultCategory::valueOf)).map(Enum::name).orElseThrow(IllegalArgumentException::new);
        lock.lock();
        try {
            BomVertex bomVertex = (BomVertex)this.bomDao.findById(RequestUtils.decodeId((String)bomId)).orElseThrow(NoSuchElementException::new);
            changeCategory.getComponentIds().stream().map(RequestUtils::decodeId).forEach(componentId -> this.componentDao.withTransaction(session -> {
                ComponentVertex vertex = (ComponentVertex)this.componentDao.findById(componentId, session).orElseThrow(NoSuchElementException::new);
                this.componentDao.updateCategoryLink(vertex, category, session);
                vertex.setCategory(category);
                this.componentDao.save((Vertex)vertex, session);
            }));
            this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
        }
        finally {
            lock.unlock();
        }
    }

    public void updateBomReviewStep(String bomId, int step) {
        BomVertex bom = (BomVertex)this.bomDao.findById(RequestUtils.decodeId((String)bomId)).orElseThrow(() -> BomExceptions.bomNotFound((String)bomId));
        this.bomDao.withTransaction(session -> {
            bom.setReviewStep(Integer.valueOf(step));
            bom.setUpdated(Instant.now());
            this.bomDao.save((Vertex)bom, session);
        });
    }

    public Collection<LightLicenseView> getCompliances(String id) {
        Map definedCompliances = this.getAllBomLicenseComplianceLevel(id);
        return this.licenseDao.findAll().stream().sorted(Comparator.comparing(LicenseVertex::getSpdxId, String.CASE_INSENSITIVE_ORDER)).map(lv -> LicenseTransformer.fromLight((LicenseVertex)lv, (Map)definedCompliances)).collect(Collectors.toList());
    }

    public Collection<KPIsView> getKpisFromProject(String projectId) {
        return this.kpiDao.findByProject(RequestUtils.decodeId((String)projectId)).stream().map(KpiTransformer::from).collect(Collectors.toList());
    }

    public KPIsView getKpis(String bomId) {
        return this.kpiDao.findByBom(RequestUtils.decodeId((String)bomId)).map(KpiTransformer::from).orElseThrow(() -> BomExceptions.kpisNotFound((String)bomId));
    }

    public Collection<BomView> searchBomFromComponent(String id) {
        return this.componentDao.findByLink(RequestUtils.decodeId((String)id), BOMClassDefinition.V.VComponent, BOMClassDefinition.E.EFrom).stream().map(c -> (BomVertex)this.bomDao.findById(((BomVertex)this.bomDao.findByComponent(c.getId()).orElseThrow(IllegalStateException::new)).getId()).orElseThrow(IllegalStateException::new)).filter(StreamUtils.distinctByKey(Vertex::getId)).map(Boms::from).distinct().collect(Collectors.toList());
    }

    public Collection<BomView> searchBomFromVulnerability(String id) {
        return this.componentDao.findByLink(RequestUtils.decodeId((String)id), BOMClassDefinition.V.VVulnerability, BOMClassDefinition.E.EVulnerability).stream().map(c -> (BomVertex)this.bomDao.findById(((BomVertex)this.bomDao.findByComponent(c.getId()).orElseThrow(IllegalStateException::new)).getId()).orElseThrow(IllegalStateException::new)).filter(StreamUtils.distinctByKey(Vertex::getId)).map(Boms::from).collect(Collectors.toList());
    }

    public Collection<BomView> searchBomFromLicense(String id) {
        return this.componentDao.findByLink(RequestUtils.decodeId((String)id), BOMClassDefinition.V.VLicense, BOMClassDefinition.E.ELicense).stream().map(c -> (BomVertex)this.bomDao.findById(((BomVertex)this.bomDao.findByComponent(c.getId()).orElseThrow(IllegalStateException::new)).getId()).orElseThrow(IllegalStateException::new)).filter(StreamUtils.distinctByKey(Vertex::getId)).map(Boms::from).collect(Collectors.toList());
    }

    private Map<String, ComplianceLevel> getAllBomLicenseComplianceLevel(String bomId) {
        return this.licenseDao.findBomLicenses(RequestUtils.decodeId((String)bomId)).stream().collect(Collectors.toMap(LicenseVertex::getSpdxId, BomLicenseVertex::getComplianceLevel));
    }
}

