/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.ioc;

import com.castsoftware.sca.scar.server.analyzer.BomCreator;
import com.castsoftware.sca.scar.server.api.handler.BomBuildBroadcaster;
import com.castsoftware.sca.scar.server.api.handler.BomDeleteBroadcaster;
import com.castsoftware.sca.scar.server.api.handler.BomExportBroadcaster;
import com.castsoftware.sca.scar.server.application.configuration.BomProperties;
import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.configuration.TaskExecutorProperties;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.domain.BomBuild;
import com.castsoftware.sca.scar.server.bom.domain.BomDelete;
import com.castsoftware.sca.scar.server.bom.domain.BomExport;
import com.castsoftware.sca.scar.server.bom.handler.BomExporter;
import com.castsoftware.sca.scar.server.bom.handler.BomWriter;
import com.castsoftware.sca.scar.server.bom.handler.ProductWriter;
import com.castsoftware.sca.scar.server.bom.service.BomTaskService;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.message.MessageService;
import com.castsoftware.sca.scar.server.sam.handler.SamUsageStatsUpdater;
import com.castsoftware.sca.scar.server.system.resolver.PathResolver;
import com.castsoftware.sca.scar.server.util.task.TaskEventListener;
import com.castsoftware.sca.scar.server.util.task.TaskExecutor;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BomTaskIOC {
    @Bean
    public TaskExecutor<BomBuild> bomBuildSCArExecutor(BomBuildBroadcaster broadcaster, ScarServerProperties scarServerProperties, ExecutorService executorService) {
        Integer parallelExecution = Optional.ofNullable(scarServerProperties).map(ScarServerProperties::getBom).map(BomProperties::getBuilder).orElseGet(TaskExecutorProperties::new).getParallel();
        TaskExecutor taskExecutor = new TaskExecutor(executorService, parallelExecution);
        taskExecutor.addListener((TaskEventListener)broadcaster);
        return taskExecutor;
    }

    @Bean
    public TaskExecutor<BomDelete> bomDeleteSCArExecutor(BomDeleteBroadcaster broadcaster, ExecutorService executorService) {
        TaskExecutor taskExecutor = new TaskExecutor(executorService, Integer.valueOf(4));
        taskExecutor.addListener((TaskEventListener)broadcaster);
        return taskExecutor;
    }

    @Bean
    public TaskExecutor<BomExport> bomExportSCArExecutor(BomExportBroadcaster broadcaster, ExecutorService executorService) {
        TaskExecutor taskExecutor = new TaskExecutor(executorService, Integer.valueOf(1));
        taskExecutor.addListener((TaskEventListener)broadcaster);
        return taskExecutor;
    }

    @Bean
    public BomTaskService bomTaskService(BomDao bomDao, BomCreator bomCreator, BomWriter bomWriter, BomExporter bomExporter, ProductWriter productWriter, PathResolver pathResolver, KPIComputer kpiComputer, SamUsageStatsUpdater samUsageStatsUpdater, MessageService messageService, TaskExecutor<BomBuild> bomBuildTaskExecutor, TaskExecutor<BomDelete> bomDeleteTaskExecutor, TaskExecutor<BomExport> bomExportTaskExecutor, FilesUtils filesUtils) {
        return new BomTaskService(bomDao, bomCreator, bomWriter, bomExporter, productWriter, pathResolver, kpiComputer, samUsageStatsUpdater, messageService, bomBuildTaskExecutor, bomDeleteTaskExecutor, bomExportTaskExecutor, filesUtils);
    }
}

