/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.ioc;

import com.castsoftware.sca.scar.server.api.handler.CatalogAddBroadcaster;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.FolderDao;
import com.castsoftware.sca.scar.server.bom.dao.ProductDao;
import com.castsoftware.sca.scar.server.bom.dao.ProjectDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.CatalogAdd;
import com.castsoftware.sca.scar.server.bom.handler.AnalyzerBomFetcher;
import com.castsoftware.sca.scar.server.bom.handler.BomExporter;
import com.castsoftware.sca.scar.server.bom.handler.BomWriter;
import com.castsoftware.sca.scar.server.bom.handler.CatalogWriter;
import com.castsoftware.sca.scar.server.bom.handler.DisplayNameResolver;
import com.castsoftware.sca.scar.server.bom.handler.ProductWriter;
import com.castsoftware.sca.scar.server.bom.handler.ScannerPreferenceFetcher;
import com.castsoftware.sca.scar.server.bom.service.BomService;
import com.castsoftware.sca.scar.server.bom.service.CatalogService;
import com.castsoftware.sca.scar.server.bom.service.FileService;
import com.castsoftware.sca.scar.server.bom.service.ProductService;
import com.castsoftware.sca.scar.server.bom.service.export.DocxBomExportService;
import com.castsoftware.sca.scar.server.bom.service.export.XlsxBomExportService;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.BomInfosService;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.ComponentsService;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.FirstPageService;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.KpisService;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.LicensesService;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.TocService;
import com.castsoftware.sca.scar.server.bom.service.export.subservices.VulnerabilitiesService;
import com.castsoftware.sca.scar.server.bom.service.export.utils.ArrayUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.TextUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.XlsxPoiUtils;
import com.castsoftware.sca.scar.server.bom.service.export.utils.poi.docx.DocxPoiUtils;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.kpi.dao.KPIDao;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.orientdb.EmbeddedServer;
import com.castsoftware.sca.scar.server.orientdb.RemoteDatabasePoolBuilder;
import com.castsoftware.sca.scar.server.orientdb.configuration.OrientDBClientConfiguration;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.preference.repository.ScannerPreferencesRepository;
import com.castsoftware.sca.scar.server.preference.service.PreferencesService;
import com.castsoftware.sca.scar.server.system.service.SystemService;
import com.castsoftware.sca.scar.server.util.task.TaskEventListener;
import com.castsoftware.sca.scar.server.util.task.TaskExecutor;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.db.ODatabasePool;
import java.util.concurrent.ExecutorService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class BomIOC {
    @Bean
    public RemoteDatabasePoolBuilder.DatabasePoolFactory poolFactory() {
        return ODatabasePool::new;
    }

    @Bean
    @Primary
    public RemoteDatabasePoolBuilder bomPoolBuilder(OrientDBClientConfiguration clientConfiguration, RemoteDatabasePoolBuilder.DatabasePoolFactory poolFactory) {
        return new RemoteDatabasePoolBuilder((RemoteDatabase)clientConfiguration.getDatabases().getBom(), poolFactory);
    }

    @Bean
    @Primary
    public ODatabasePool bomPool(RemoteDatabasePoolBuilder builder, EmbeddedServer server) {
        return builder.build(server);
    }

    @Bean
    public CentralDao centralDao(ODatabasePool pool) {
        return new CentralDao(pool);
    }

    @Bean
    public BomDao bomDao(ODatabasePool pool) {
        return new BomDao(pool);
    }

    @Bean
    public SnippetDao snippetDao(ODatabasePool pool) {
        return new SnippetDao(pool);
    }

    @Bean
    public FileDao fileDao(ODatabasePool pool) {
        return new FileDao(pool);
    }

    @Bean
    public FolderDao folderDao(ODatabasePool pool) {
        return new FolderDao(pool);
    }

    @Bean
    public ProductDao productDao(ODatabasePool pool) {
        return new ProductDao(pool);
    }

    @Bean
    public ProjectDao projectDao(ODatabasePool pool) {
        return new ProjectDao(pool);
    }

    @Bean
    public BomWriter bomWriter(BomDao bomDao, ComponentDao componentDao, FileDao fileDao, FolderDao folderDao, SnippetDao snippetDao, LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, VulnerabilityDao vulnerabilityDao, ProductDao productDao, ProjectDao projectDao, CentralDao centralDao, KPIDao kpiDao, ObjectMapper mapper) {
        return new BomWriter(bomDao, componentDao, fileDao, folderDao, snippetDao, licenseDao, licensePolicyDao, vulnerabilityDao, productDao, projectDao, centralDao, kpiDao, mapper);
    }

    @Bean
    public DocxPoiUtils docxPoiUtils(TextUtils textUtils, ArrayUtils arrayUtils, FilesUtils filesUtils) {
        return new DocxPoiUtils(textUtils, arrayUtils, filesUtils);
    }

    @Bean
    public XlsxPoiUtils xlsxPoiUtils() {
        return new XlsxPoiUtils();
    }

    @Bean
    public FilesUtils filesUtils() {
        return new FilesUtils();
    }

    @Bean
    public TextUtils textUtils() {
        return new TextUtils();
    }

    @Bean
    public ArrayUtils arrayUtils() {
        return new ArrayUtils();
    }

    @Bean
    public TocService tocService(DocxPoiUtils poiUtils) {
        return new TocService(poiUtils);
    }

    @Bean
    public ComponentsService componentsExportService(DocxPoiUtils poiUtils, FilesUtils filesUtils, TextUtils textUtils) {
        return new ComponentsService(poiUtils, filesUtils, textUtils);
    }

    @Bean
    public BomInfosService bomInfosService(DocxPoiUtils poiUtils, FilesUtils filesUtils) {
        return new BomInfosService(poiUtils, filesUtils);
    }

    @Bean
    public KpisService kpisService(DocxPoiUtils poiUtils, FilesUtils filesUtils, TextUtils textUtils, ArrayUtils arrayUtils) {
        return new KpisService(poiUtils, filesUtils, textUtils, arrayUtils);
    }

    @Bean
    public VulnerabilitiesService vulnerabilitiesService(DocxPoiUtils poiUtils, ComponentsService compService, VulnerabilityDao vulnerabilityDao, FilesUtils filesUtils) {
        return new VulnerabilitiesService(poiUtils, compService, vulnerabilityDao, filesUtils);
    }

    @Bean
    public LicensesService licensesService(DocxPoiUtils poiUtils, ComponentsService compService, FilesUtils filesUtils, TextUtils textUtils) {
        return new LicensesService(poiUtils, compService, filesUtils, textUtils);
    }

    @Bean
    public FirstPageService firstPageService(DocxPoiUtils poiUtils, FilesUtils filesUtils) {
        return new FirstPageService(poiUtils, filesUtils);
    }

    @Bean
    public XlsxBomExportService xlsxBomExportService(XlsxPoiUtils xlsxPoiUtils, FilesUtils filesUtils, VulnerabilitiesService vulService) {
        return new XlsxBomExportService(xlsxPoiUtils, filesUtils, vulService);
    }

    @Bean
    public DocxBomExportService docxBomExportService(DocxPoiUtils poiUtils, TocService tocService, ComponentsService componentsExportService, FilesUtils filesUtils, BomInfosService bomInfosService, KpisService kpisService, VulnerabilitiesService vulService, LicensesService licensesServIce, FirstPageService firstPageService) {
        return new DocxBomExportService(poiUtils, tocService, componentsExportService, bomInfosService, kpisService, vulService, licensesServIce, filesUtils, firstPageService);
    }

    @Bean
    public BomExporter bomExporter(ComponentDao componentDao, FileDao fileDao, LicenseDao licenseDao, KPIDao kpiDao, SnippetDao snippetDao, VulnerabilityDao vulnerabilityDao, SystemService systemService, PreferencesService preferencesService, XlsxBomExportService xlsxBomExportService, DocxBomExportService docxBomExportService) {
        return new BomExporter(componentDao, fileDao, licenseDao, kpiDao, snippetDao, vulnerabilityDao, systemService, preferencesService, xlsxBomExportService, docxBomExportService);
    }

    @Bean
    public ProductWriter productWriter(ProductDao productDao, ProjectDao projectDao) {
        return new ProductWriter(productDao, projectDao);
    }

    @Bean
    public DisplayNameResolver displayNameResolver() {
        return new DisplayNameResolver();
    }

    @Bean
    public BomService bomService(BomDao bomDao, ComponentDao componentDao, FolderDao folderDao, FileDao fileDao, LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, KPIDao kpiDao, KPIComputer kpiComputer, DisplayNameResolver displayNameResolver) {
        return new BomService(bomDao, componentDao, folderDao, fileDao, licenseDao, licensePolicyDao, kpiDao, kpiComputer, displayNameResolver);
    }

    @Bean
    public ProductService productService(ProductDao productDao, ProjectDao projectDao, ObjectMapper objectMapper) {
        return new ProductService(productDao, projectDao, objectMapper);
    }

    @Bean
    public TaskExecutor<CatalogAdd> catalogAddExecutor(CatalogAddBroadcaster broadcaster, ExecutorService executorService) {
        TaskExecutor taskExecutor = new TaskExecutor(executorService, Integer.valueOf(1));
        taskExecutor.addListener((TaskEventListener)broadcaster);
        return taskExecutor;
    }

    @Bean
    public CatalogWriter catalogWriter(BomDao bomDao, CentralDao centralDao, ComponentDao componentDao, SnippetDao snippetDao, FileDao fileDao, FolderDao folderDao) {
        return new CatalogWriter(bomDao, centralDao, componentDao, snippetDao, fileDao, folderDao);
    }

    @Bean
    public CatalogService catalogService(CentralDao centralDao, BomDao bomDao, ComponentDao componentDao, LicensePolicyDao licensePolicyDao, KPIComputer kpiComputer, TaskExecutor<CatalogAdd> catalogAddExecutor, CatalogWriter catalogWriter) {
        return new CatalogService(centralDao, bomDao, componentDao, licensePolicyDao, kpiComputer, catalogAddExecutor, catalogWriter);
    }

    @Bean
    public AnalyzerBomFetcher analyzerBomFetcher(CentralDao centralDao, BomDao bomDao, ComponentDao componentDao, FileDao fileDao, SnippetDao snippetDao, VulnerabilityDao vulnerabilityDao, LicenseDao licenseDao) {
        return new AnalyzerBomFetcher(centralDao, bomDao, componentDao, fileDao, snippetDao, vulnerabilityDao, licenseDao);
    }

    @Bean
    public ScannerPreferenceFetcher bomPreferenceFetcher(ScannerPreferencesRepository scannerPreferencesRepository) {
        return new ScannerPreferenceFetcher(scannerPreferencesRepository);
    }

    @Bean
    public FileService fileService(FileDao fileDao, BomDao bomDao, ComponentDao componentDao, LicenseDao licenseDao, KPIComputer kpiComputer) {
        return new FileService(fileDao, bomDao, componentDao, licenseDao, kpiComputer);
    }
}

