/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.handler;

import com.castsoftware.sca.scar.server.bom.dao.ProductDao;
import com.castsoftware.sca.scar.server.bom.dao.ProjectDao;
import com.castsoftware.sca.scar.server.bom.domain.ProductVertex;
import com.castsoftware.sca.scar.server.bom.domain.ProjectVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class ProductWriter {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ProductWriter.class);
    private final ProductDao productDao;
    private final ProjectDao projectDao;

    public ProductWriter(ProductDao productDao, ProjectDao projectDao) {
        this.productDao = productDao;
        this.projectDao = projectDao;
    }

    public void cleanIfNecessary(String productId, String projectId) {
        this.projectDao.withTransaction(session -> {
            try {
                List projects;
                ProjectVertex projectVertex = (ProjectVertex)this.projectDao.findById(projectId, session).orElseThrow(IllegalStateException::new);
                ProductVertex productVertex = (ProductVertex)this.productDao.findById(productId, session).orElseThrow(IllegalStateException::new);
                List boms = this.projectDao.findBoms(projectVertex, session);
                if (boms.stream().distinct().count() <= 0L) {
                    this.projectDao.delete((Vertex)projectVertex, session);
                }
                if ((projects = this.productDao.findProjects(productVertex, session)).stream().distinct().count() <= 0L) {
                    this.productDao.delete((Vertex)productVertex, session);
                }
            }
            catch (Throwable t) {
                LOGGER.error("fail to clean product and project");
                throw Exceptions.wrap((Throwable)t);
            }
        });
    }
}

