/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.handler;

import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.FolderDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.FolderVertex;
import com.castsoftware.sca.scar.server.bom.domain.NodeVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class CatalogWriter {
    private final BomDao bomDao;
    private final CentralDao centralDao;
    private final ComponentDao componentDao;
    private final SnippetDao snippetDao;
    private final FileDao fileDao;
    private final FolderDao folderDao;

    public CatalogWriter(BomDao bomDao, CentralDao centralDao, ComponentDao componentDao, SnippetDao snippetDao, FileDao fileDao, FolderDao folderDao) {
        this.bomDao = bomDao;
        this.centralDao = centralDao;
        this.componentDao = componentDao;
        this.snippetDao = snippetDao;
        this.fileDao = fileDao;
        this.folderDao = folderDao;
    }

    public void addComponentToCatalog(String componentId) {
        BomComponentVertex bomComponent = this.componentDao.findByIdWithLV(componentId).filter(BomComponentVertex.class::isInstance).map(BomComponentVertex.class::cast).orElseThrow(NoSuchElementException::new);
        Collection licensesToAdd = bomComponent.getLicenses();
        Collection vulnerabilitiesToAdd = bomComponent.getVulnerabilities();
        List filesToAdd = this.fileDao.findByComponentWithLicense(bomComponent.getId()).stream().filter(f -> !this.isInCatalog(f)).collect(Collectors.toList());
        List snippetsToAdd = this.snippetDao.findByComponent(bomComponent.getId()).stream().filter(s -> !this.isInCatalog(s)).collect(Collectors.toList());
        if (!filesToAdd.isEmpty() || !snippetsToAdd.isEmpty()) {
            BomVertex catalog = Optional.ofNullable(this.centralDao.getCatalog()).orElseThrow(NoSuchElementException::new);
            this.centralDao.withTransaction(session -> {
                FolderVertex catalogRoot = (FolderVertex)this.bomDao.findRootNode(catalog.getId(), session).orElseThrow(IllegalStateException::new);
                bomComponent.setSource(BomSource.CATALOG.name());
                this.componentDao.save((Vertex)bomComponent, session);
                ComponentVertex catalogComponent = bomComponent.copy();
                this.componentDao.save((Vertex)catalogComponent, session);
                licensesToAdd.forEach(l -> this.componentDao.addLicense(catalogComponent, l, session));
                vulnerabilitiesToAdd.forEach(v -> this.componentDao.addVulnerability(catalogComponent, v, session));
                filesToAdd.forEach(f -> {
                    FileVertex copiedFile = f.copy();
                    copiedFile.setPath("/");
                    this.fileDao.save((Vertex)copiedFile, session);
                    f.getLicenses().forEach(l -> this.fileDao.addLicense(copiedFile, l, session));
                    this.componentDao.addFile(catalogComponent, copiedFile, session);
                    this.folderDao.addChild(catalogRoot, (NodeVertex)copiedFile, session);
                });
                snippetsToAdd.forEach(s -> {
                    SnippetVertex copiedSnippet = new SnippetVertex(s.getName());
                    copiedSnippet.setScaId(s.getScaId());
                    copiedSnippet.setVersion(s.getVersion());
                    this.snippetDao.save((Vertex)copiedSnippet, session);
                    this.componentDao.addSnippet(catalogComponent, copiedSnippet, session);
                });
                this.bomDao.addComponent(catalog, catalogComponent, bomComponent.getCategory(), session);
                this.componentDao.link((Vertex)bomComponent, (Vertex)catalogComponent, (EClassDefinition)BOMClassDefinition.E.EFrom, session);
            });
        }
    }

    private boolean isInCatalog(FileVertex fileVertex) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.fileDao.findBySha256(fileVertex.getSha256()).stream().filter(f -> !f.getId().equals(fileVertex.getId())).map(f -> this.bomDao.findByFile(f.getId())).forEach(b -> b.filter(BomVertex::isCatalog).ifPresent(p -> result.set(true)));
        return result.get();
    }

    private boolean isInCatalog(SnippetVertex snippetVertex) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.snippetDao.findByNameAndVersion(snippetVertex.getName(), snippetVertex.getVersion()).stream().filter(s -> !s.getId().equals(snippetVertex.getId())).map(s -> this.bomDao.findBySnippet(s.getId())).forEach(b -> b.filter(BomVertex::isCatalog).ifPresent(p -> result.set(true)));
        return result.get();
    }
}

