/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.handler;

import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.exception.BomSaveException;
import com.castsoftware.sca.scar.server.analyzer.structure.Bom;
import com.castsoftware.sca.scar.server.analyzer.structure.Category;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.License;
import com.castsoftware.sca.scar.server.analyzer.structure.Vulnerability;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.FolderDao;
import com.castsoftware.sca.scar.server.bom.dao.ProductDao;
import com.castsoftware.sca.scar.server.bom.dao.ProjectDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.FolderVertex;
import com.castsoftware.sca.scar.server.bom.domain.FullBomVertex;
import com.castsoftware.sca.scar.server.bom.domain.NodeVertex;
import com.castsoftware.sca.scar.server.bom.domain.ProductVertex;
import com.castsoftware.sca.scar.server.bom.domain.ProjectVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.bom.handler.BomWriter;
import com.castsoftware.sca.scar.server.bom.handler.BomWriterEvents;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.component.handler.ComponentSortHandler;
import com.castsoftware.sca.scar.server.kpi.dao.KPIDao;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class BomWriter {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(BomWriter.class);
    public static final String UNKNOWN = "unknown";
    private final BomDao bomDao;
    private final ComponentDao componentDao;
    private final FileDao fileDao;
    private final FolderDao folderDao;
    private final SnippetDao snippetDao;
    private final LicenseDao licenseDao;
    private final LicensePolicyDao licensePolicyDao;
    private final VulnerabilityDao vulnerabilityDao;
    private final ProductDao productDao;
    private final ProjectDao projectDao;
    private final CentralDao centralDao;
    private final KPIDao kpiDao;
    private final ObjectMapper mapper;

    public BomWriter(BomDao bomDao, ComponentDao componentDao, FileDao fileDao, FolderDao folderDao, SnippetDao snippetDao, LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, VulnerabilityDao vulnerabilityDao, ProductDao productDao, ProjectDao projectDao, CentralDao centralDao, KPIDao kpiDao, ObjectMapper mapper) {
        this.bomDao = bomDao;
        this.componentDao = componentDao;
        this.fileDao = fileDao;
        this.folderDao = folderDao;
        this.snippetDao = snippetDao;
        this.licenseDao = licenseDao;
        this.licensePolicyDao = licensePolicyDao;
        this.vulnerabilityDao = vulnerabilityDao;
        this.productDao = productDao;
        this.projectDao = projectDao;
        this.centralDao = centralDao;
        this.kpiDao = kpiDao;
        this.mapper = mapper;
    }

    public BomVertex writeBom(@NonNull BomWizardConfiguration configuration, @NonNull Bom scanBom) {
        LicensePolicyVertex licensePolicy = this.licensePolicyDao.findByName(configuration.getLicensePolicy()).orElseGet(() -> (LicensePolicyVertex)Opt.ofNullable((Object)this.centralDao.getDefaultPolicy()).orElseThrow(Suppliers.illegalState((String)"License Policy not found and no default policy")));
        Optional existingProduct = this.productDao.findByName(configuration.getProduct());
        Optional existingProject = existingProduct.flatMap(p -> this.projectDao.findByProductAndName(p.getId(), configuration.getProject()));
        String newVersion = Opt.of((Object)configuration).map(BomWizardConfiguration::getVersion).filter(v -> existingProject.map(Vertex::getId).map(arg_0 -> ((ProjectDao)this.projectDao).findVersions(arg_0)).map(vs -> !vs.contains(v)).orElse(true)).orElseThrow(Suppliers.illegalArgument((String)String.format("Product (%s)/Project (%s)/version (%s) need to be unique", configuration.getProduct(), configuration.getProject(), configuration.getVersion())));
        if (scanBom.getRootNode() == null || scanBom.getRootNode().getChildren().isEmpty()) {
            throw new BomSaveException("bom_not_saved", "No file node, unable to save bom");
        }
        BomWriterContext context = new BomWriterContext(configuration, scanBom, (ProductVertex)existingProduct.orElse(null), (ProjectVertex)existingProject.orElse(null), newVersion, licensePolicy);
        this.configureProject(context);
        this.createBom(context);
        this.createVulnerabilities(context);
        this.createComponents(context);
        this.createTreeFolder(context);
        this.attachSnippetsToFiles(context);
        this.bomDao.save((Vertex)context.savedBom);
        this.projectDao.addBom(context.savedProject, context.savedBom, context.version);
        context.savedBom.setAvailable(true);
        this.bomDao.save((Vertex)context.savedBom);
        this.logSaving(scanBom, "Finished SBOM creation", new Object[0]);
        this.notify(context, (Event)Event.finish(this.getClass()));
        return context.savedBom;
    }

    public void preDeleteUnlinkBom(FullBomVertex bomVertex) {
        this.logDeleting(bomVertex, "Unlinking BOM...", new Object[0]);
        this.projectDao.unlink((Vertex)bomVertex.getProject(), (Vertex)bomVertex, (EClassDefinition)BOMClassDefinition.E.EVersion);
    }

    public void deleteBom(@NonNull FullBomVertex bomVertex) {
        String bomId = bomVertex.getId();
        try {
            this.logDeleting(bomVertex, "Deleting Components and associated files / snippets...", new Object[0]);
            this.componentDao.deleteFromBom(bomId);
            this.logDeleting(bomVertex, "Deleting Folders and associated Files...", new Object[0]);
            this.folderDao.deleteFromBom(bomId);
            this.logDeleting(bomVertex, "Deleting KPIs...", new Object[0]);
            this.kpiDao.deleteByBom(bomId);
            this.logDeleting(bomVertex, "Deleting SBOM...", new Object[0]);
            this.bomDao.delete((Vertex)bomVertex);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to delete SBOM (but it has been unlinked from project)");
            throw Exceptions.wrap((Throwable)t);
        }
    }

    private void notify(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context, Event<BomWriterEvents.BomWriterVisitor> event) {
        context.configuration.notify(event);
    }

    private void configureProject(BomWriterContext context) {
        this.notify(context, (Event)BomWriterEvents.configureProject());
        ProductVertex product = Opt.ofNullable((Object)context.product).orElseGet(() -> (ProductVertex)this.productDao.save((Vertex)new ProductVertex(context.scannedBom.getProduct())));
        context.savedProject = Opt.ofNullable((Object)context.project).map(ProjectVertex.class::cast).orElseGet(() -> {
            ProjectVertex saved = (ProjectVertex)this.projectDao.save((Vertex)new ProjectVertex(context.scannedBom.getProject()));
            this.productDao.addProject(product, saved);
            return saved;
        });
    }

    private void createBom(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context) {
        this.logSaving(context.scannedBom, "Saving BOM...", new Object[0]);
        this.notify(context, (Event)BomWriterEvents.createBom());
        BomVertex bom = new BomVertex();
        bom.setAvailable(false);
        bom.setCreated(Instant.ofEpochMilli(context.scannedBom.getCreationTimestamp()));
        Optional.of(context.configuration).map(Functions.forwardThrowable(arg_0 -> ((ObjectMapper)this.mapper).writeValueAsString(arg_0))).ifPresent(arg_0 -> ((BomVertex)bom).setScannerConfiguration(arg_0));
        context.savedBom = (BomVertex)this.bomDao.save((Vertex)bom);
        this.bomDao.addPolicy(context.savedBom, context.licensePolicy);
    }

    private void createVulnerabilities(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context) {
        context.scannedBom.getVulnerabilities().stream().filter(Objects::nonNull).forEach(v -> this.vulnerabilityDao.save((Vertex)Vulnerability.toVertex((Vulnerability)v)));
    }

    private void createComponents(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context) {
        this.logSaving(context.scannedBom, "Saving BOM Components...", new Object[0]);
        Long totalCount = context.scannedBom.getCategories().stream().map(Category::getComponents).mapToLong(List::size).sum();
        this.notify(context, (Event)BomWriterEvents.createComponents((Long)totalCount));
        context.scannedBom.getCategories().stream().map(Category::getComponents).flatMap(Collection::stream).filter(Predicates.negate(Component::isEmpty)).filter(c -> StringUtils.isNotEmpty((String)c.getName())).peek(c -> this.notify(context, (Event)BomWriterEvents.createComponent())).map(c -> this.createComponent(c, context)).filter(Objects::nonNull).forEach(c -> this.bomDao.addComponent(context.savedBom, c, c.getCategory()));
    }

    private ComponentVertex createComponent(@NonNull Component component, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context) {
        this.logSaving(context.scannedBom, "Creating Component '%s' ...", new Object[]{component.getName()});
        ComponentVertex cv = new ComponentVertex(component.getName());
        cv.setScaId(component.getScaId());
        cv.setCategory(component.getCategory().getType().name());
        cv.setSource(component.getSource().name());
        cv.setPath(component.getPath());
        cv.setReferences(component.getReferences());
        cv.setVersion(component.getVersion());
        cv.setCountFiles(Opt.ofEmptyCollection((Collection)component.getFiles()).map(List::size).map(Integer::longValue).orElse(0L));
        cv.setCountSnippets(Opt.ofEmptyCollection((Collection)component.getSnippets()).map(List::size).map(Integer::longValue).orElse(0L));
        cv.setLastVersion(component.getLatestVersion());
        cv.setAllVersions(new LinkedHashMap(component.getAllVersions()));
        cv.setTopics(component.getTopics());
        cv.setLanguages(component.getLanguages());
        cv.setDescription(component.getDescription());
        cv.setRepoType(component.getRepositoryType());
        cv.setRepository(component.getRepository());
        cv.setComments(component.getComments());
        cv.setUpToDate(component.getUpToDate());
        cv.setCopyright(component.getCopyrights());
        cv = (ComponentVertex)this.componentDao.save((Vertex)cv);
        this.createComponentLicenses(component, cv, context);
        this.createComponentVulnerabilities(component, cv);
        this.createComponentFiles(component, cv, context);
        this.createComponentSnippets(component, cv, context);
        if (component.getLinkedComponentId() != null) {
            this.attachToCatalog(cv, component.getLinkedComponentId());
        }
        return cv;
    }

    private void createComponentLicenses(@NonNull Component component, @NonNull ComponentVertex componentVertex, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context) {
        List lvs = component.getLicenses().stream().map(License::getSpdxId).map(spdxId -> context.licenseCache.computeIfAbsent(spdxId, id -> this.licenseDao.findBySpdxId(id).orElseGet(() -> (LicenseVertex)this.licenseDao.save((Vertex)new LicenseVertex(id))))).peek(lv -> this.componentDao.addLicense(componentVertex, lv)).collect(Collectors.toList());
        componentVertex.setLicenseIndex(ComponentSortHandler.computeLicenseSortIndex(lvs, (Collection)this.licenseDao.findBomLicenses(context.savedBom.getId())));
        this.componentDao.save((Vertex)componentVertex);
    }

    private void createComponentVulnerabilities(@NonNull Component component, @NonNull ComponentVertex componentVertex) {
        List vvs = component.getVulnerabilities().stream().filter(Objects::nonNull).map(Vulnerability::getVId).map(id -> this.vulnerabilityDao.findByVId(id).orElseGet(() -> (VulnerabilityVertex)this.vulnerabilityDao.save((Vertex)new VulnerabilityVertex(id)))).peek(vv -> this.componentDao.addVulnerability(componentVertex, vv)).collect(Collectors.toList());
        componentVertex.setVulnerabilityIndex(ComponentSortHandler.computeVulnerabilitySortIndex(vvs));
        this.componentDao.save((Vertex)componentVertex);
    }

    private void createComponentFiles(@NonNull Component component, ComponentVertex componentVertex, BomWriterContext context) {
        component.getFiles().forEach(file -> {
            FileNode fileNode = (FileNode)Guards.notNull((Object)file.getFileNode(), (Supplier)Suppliers.illegalState((String)"Invalid FileNode for FileElement"));
            FileVertex vertex = new FileVertex(fileNode.getName());
            String path = Opt.ofNullable((Object)fileNode.getPath()).map(p -> {
                p = BomWizardConfiguration.SourceType.CYCLONE_DX.equals((Object)context.configuration.getSourceType()) ? p.replace(context.configuration.getSourcePath() + component.getPath(), "/") : p;
                return p.replace(vertex.getName(), "");
            }).orElse(vertex.getName());
            vertex.setPath(Optional.of(component).map(Component::getPath).filter(Predicates.negate("/"::equals)).filter(path::startsWith).map(cp -> path.replaceFirst((String)cp, "")).map(p -> p.startsWith("/") ? p : "/".concat((String)p)).orElse(path));
            Fields.field((String)file.getSha256(), arg_0 -> ((FileVertex)vertex).setSha256(arg_0));
            Fields.field((String)file.getSha1(), arg_0 -> ((FileVertex)vertex).setSha1(arg_0));
            Fields.field((String)file.getMd5(), arg_0 -> ((FileVertex)vertex).setMd5(arg_0));
            Fields.field((String)file.getCopyrights(), arg_0 -> ((FileVertex)vertex).setCopyright(arg_0));
            Fields.field((Object)file.getSize(), arg_0 -> ((FileVertex)vertex).setSize(arg_0));
            Fields.field((String)file.getScaVersion(), arg_0 -> ((FileVertex)vertex).setVersion(arg_0));
            FileVertex saved = (FileVertex)this.fileDao.save((Vertex)vertex);
            file.getLicenses().stream().map(License::getSpdxId).map(spdxId -> context.licenseCache.computeIfAbsent(spdxId, id -> this.licenseDao.findBySpdxId(id).orElseGet(() -> (LicenseVertex)this.licenseDao.save((Vertex)new LicenseVertex(id))))).forEach(l -> this.fileDao.addLicense(saved, l));
            this.componentDao.addFile(componentVertex, saved);
            context.fileCache.put(file.getFileNode().getUUID(), saved);
        });
    }

    private void createComponentSnippets(@NonNull Component component, ComponentVertex componentVertex, BomWriterContext context) {
        component.getSnippets().forEach(snippet -> {
            SnippetVertex vertex = new SnippetVertex(snippet.getName());
            Fields.field((String)snippet.getScaProject(), arg_0 -> ((SnippetVertex)vertex).setScaId(arg_0));
            Fields.field((String)snippet.getScaVersion(), arg_0 -> ((SnippetVertex)vertex).setVersion(arg_0));
            SnippetVertex saved = (SnippetVertex)this.snippetDao.save((Vertex)vertex);
            this.componentDao.addSnippet(componentVertex, saved);
            context.snippetCache.put(snippet, saved);
        });
    }

    private void attachSnippetsToFiles(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context) {
        context.snippetCache.forEach((snippet, vertex) -> {
            if (snippet.getFromFile() != null) {
                FileVertex file = Opt.ofNullable((Object)snippet.getFromFile().getUUID()).map(context.fileCache::get).orElseThrow(Suppliers.illegalState((String)"Invalid FileNode for Snippet"));
                this.fileDao.addSnippet(file, vertex);
            }
        });
    }

    private void createTreeFolder(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BomWriter.BomWriterContext context) {
        this.logSaving(context.scannedBom, "Saving BOM folder tree...", new Object[0]);
        this.notify(context, (Event)BomWriterEvents.createTree((long)context.scannedBom.getNumberOfFiles()));
        FolderVertex root = (FolderVertex)this.folderDao.save((Vertex)new FolderVertex("/"));
        this.bomDao.addRoot(context.savedBom, root);
        context.scannedBom.getRootNode().getChildren().forEach(n -> this.saveNode(n, root, context));
    }

    private void saveNode(@NonNull FileNode node, FolderVertex parent, BomWriterContext context) {
        this.notify(context, (Event)BomWriterEvents.createNode());
        if (FileNode.FileNodeType.FOLDER.equals((Object)node.getType())) {
            FolderVertex folder = (FolderVertex)this.folderDao.save((Vertex)new FolderVertex(node.getName()));
            this.folderDao.addChild(parent, (NodeVertex)folder);
            node.getChildren().forEach(n -> this.saveNode(n, folder, context));
        } else {
            FileVertex file = context.fileCache.computeIfAbsent(node.getUUID(), u -> (FileVertex)this.fileDao.save((Vertex)new FileVertex(node.getName())));
            this.folderDao.addChild(parent, (NodeVertex)file);
        }
    }

    private void attachToCatalog(ComponentVertex componentVertex, String catalogComponentId) {
        ComponentVertex catalogComponent = (ComponentVertex)this.componentDao.findById(catalogComponentId).orElseThrow(Suppliers.illegalState((String)"Catalog Component not found"));
        this.componentDao.link((Vertex)componentVertex, (Vertex)catalogComponent, (EClassDefinition)BOMClassDefinition.E.EFrom);
    }

    private void logSaving(Bom bom, String format, Object ... objects) {
        Optional opt = Opt.ofNullable((Object)bom);
        this.log("Saving", opt.map(Bom::getProduct).orElse(UNKNOWN), opt.map(Bom::getProject).orElse(UNKNOWN), opt.map(Bom::getVersion).orElse(UNKNOWN), format, objects);
    }

    private void logDeleting(@NonNull FullBomVertex bomVertex, String format, Object ... objects) {
        this.log("Deleting", bomVertex.getProduct().getName(), bomVertex.getProject().getName(), (String)bomVertex.getVersion().getProperty("name"), format, objects);
    }

    private void log(String action, String product, String project, String version, String format, Object ... objects) {
        String stdFormat = "[" + action + "][BOM %s] ";
        LOGGER.info(String.format(Opt.ofNullable((Object)format).map(stdFormat::concat).orElse(stdFormat), Stream.concat(Stream.of(String.join((CharSequence)":", product, project, version)), Optional.ofNullable(objects).stream().flatMap(Stream::of)).toArray(Object[]::new)));
    }
}

