/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.handler;

import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomExportConfiguration;
import com.castsoftware.sca.scar.server.bom.domain.BomExportFormat;
import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.FullBomVertex;
import com.castsoftware.sca.scar.server.bom.handler.BomExporter;
import com.castsoftware.sca.scar.server.bom.handler.BomExporterEvents;
import com.castsoftware.sca.scar.server.bom.handler.ExporterContext;
import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.bom.service.export.DocxBomExportService;
import com.castsoftware.sca.scar.server.bom.service.export.XlsxBomExportService;
import com.castsoftware.sca.scar.server.bom.transformer.FilesTransformer;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.handler.ComponentTransforms;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.core.model.NamedView;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxBomExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxExportContext;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxFileExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxLibraryExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxLicenseExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxMetadataExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxVulnerabilityExporter;
import com.castsoftware.sca.scar.server.kpi.dao.KPIDao;
import com.castsoftware.sca.scar.server.kpi.model.KPIsView;
import com.castsoftware.sca.scar.server.kpi.transformer.KpiTransformer;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.preference.domain.ReviewStep;
import com.castsoftware.sca.scar.server.preference.service.PreferencesService;
import com.castsoftware.sca.scar.server.system.dto.SystemInfoView;
import com.castsoftware.sca.scar.server.system.service.SystemService;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.Version;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.model.Bom;
import org.slf4j.Logger;

public class BomExporter {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(BomExporter.class);
    private static final String LICENSES_SPDX_IDS_FILE_PATH = "refs/licenses-spdx-ids.json";
    private final ComponentDao componentDao;
    private final FileDao fileDao;
    private final LicenseDao licenseDao;
    private final KPIDao kpiDao;
    private final SnippetDao snippetDao;
    private final VulnerabilityDao vulnerabilityDao;
    private final SystemService systemService;
    private final PreferencesService preferencesService;
    private final XlsxBomExportService xlsxBomExportService;
    private final DocxBomExportService docxBomExportService;

    public BomExporter(ComponentDao componentDao, FileDao fileDao, LicenseDao licenseDao, KPIDao kpiDao, SnippetDao snippetDao, VulnerabilityDao vulnerabilityDao, SystemService systemService, PreferencesService preferencesService, XlsxBomExportService xlsxBomExportService, DocxBomExportService docxBomExportService) {
        this.componentDao = componentDao;
        this.fileDao = fileDao;
        this.licenseDao = licenseDao;
        this.kpiDao = kpiDao;
        this.snippetDao = snippetDao;
        this.vulnerabilityDao = vulnerabilityDao;
        this.systemService = systemService;
        this.preferencesService = preferencesService;
        this.xlsxBomExportService = xlsxBomExportService;
        this.docxBomExportService = docxBomExportService;
    }

    public byte[] exportBom(FullBomVertex bomVertex, @NonNull BomExportConfiguration configuration) {
        this.log(bomVertex, "Started exporting BOM", new Object[0]);
        long startTime = System.nanoTime();
        byte[] bytes = new byte[]{};
        switch (2.$SwitchMap$com$castsoftware$sca$scar$server$bom$domain$BomExportFormat[configuration.getExportFormat().ordinal()]) {
            case 1: 
            case 2: {
                bytes = this.exportCdx(bomVertex, configuration);
                break;
            }
            case 3: {
                bytes = this.exportXlsx(bomVertex, configuration);
                break;
            }
            case 4: {
                bytes = this.exportDocx(bomVertex, configuration);
            }
        }
        this.logExportDuration(bomVertex, startTime);
        return bytes;
    }

    private byte[] exportXlsx(FullBomVertex bomVertex, @NonNull BomExportConfiguration config) {
        config.notify((Event)BomExporterEvents.exportContextPreparing((Integer)9));
        byte[] bytes = this.xlsxBomExportService.startExport(this.makeExportContext(bomVertex, config));
        config.notify((Event)BomExporterEvents.exportXlsxDownloading());
        return bytes;
    }

    private byte[] exportDocx(FullBomVertex bomVertex, @NonNull BomExportConfiguration config) {
        config.notify((Event)BomExporterEvents.exportContextPreparing((Integer)9));
        byte[] bytes = this.docxBomExportService.startExport(this.makeExportContext(bomVertex, config));
        config.notify((Event)BomExporterEvents.exportDocxDownloading());
        return bytes;
    }

    private byte[] exportCdx(FullBomVertex bomVertex, @NonNull BomExportConfiguration config) {
        config.notify((Event)BomExporterEvents.exportContextPreparing((Integer)8));
        byte[] bytes = this.exportCdx(this.makeCdxExportContext(config, bomVertex));
        config.notify((Event)BomExporterEvents.exportCycloneDxDownloading());
        return bytes;
    }

    private @NonNull CdxExportContext makeCdxExportContext(BomExportConfiguration configuration, FullBomVertex bomVertex) {
        this.incrementProgress(configuration);
        Map complianceLookup = this.buildLicenseComplianceLookup(bomVertex.getId(), configuration);
        this.incrementProgress(configuration);
        List components = this.collectComponents(bomVertex.getId(), complianceLookup);
        this.incrementProgress(configuration);
        this.addComponentSnippets(components);
        this.incrementProgress(configuration);
        if (configuration.isExportFiles()) {
            for (ComponentView component : components) {
                List files = this.getComponentFilesWithLicenses(component.getId(), complianceLookup);
                component.setFiles((Collection)files);
            }
        }
        this.incrementProgress(configuration);
        Set validSpdxIds = this.getValidLicenseSpdxIds();
        this.incrementProgress(configuration);
        Long fileCount = this.fileDao.countByBom(bomVertex.getId());
        Long componentCount = this.componentDao.countByBom(bomVertex.getId());
        this.incrementProgress(configuration);
        String reviewStep = this.preferencesService.findReviewStep(bomVertex.getReviewStep().intValue()).map(ReviewStep::getName).orElse("created");
        this.incrementProgress(configuration);
        return new CdxExportContext(configuration, this.getVersionWithCommitNumber(), bomVertex.getProduct().getName(), bomVertex.getProject().getName(), (String)bomVertex.getVersion().getProperty("name"), bomVertex.getLicensePolicy().getName(), bomVertex.getCreated(), this.extractBomVertexSourcePath(bomVertex), reviewStep, components, validSpdxIds, fileCount.longValue(), componentCount.longValue());
    }

    private String getVersionWithCommitNumber() {
        return this.systemService.getSystemInfo().map(SystemInfoView::getApplication).map(SystemInfoView.Application::getVersion).orElse(null);
    }

    private Set<String> getValidLicenseSpdxIds() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            InputStream inputStream = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(LICENSES_SPDX_IDS_FILE_PATH));
            Map jsonMap = (Map)objectMapper.readValue(inputStream, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return Opt.ofEmptyCollection((Collection)((List)jsonMap.get("spDxIds"))).map(HashSet::new).orElse(new HashSet());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String extractBomVertexSourcePath(@NonNull FullBomVertex bomVertex) {
        String scanPropertyData = (String)bomVertex.getVertex().getProperty("scan");
        String sourcePath = "";
        if (StringUtils.isNotEmpty((CharSequence)scanPropertyData)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                JsonNode jsonNode = mapper.readTree(scanPropertyData);
                sourcePath = jsonNode.get("sourcePath").asText();
            }
            catch (IOException e) {
                LOGGER.info("Json could not be parsed");
            }
        }
        return sourcePath;
    }

    private byte @NonNull [] exportCdx(CdxExportContext context) {
        Set validSpdxIds = this.getValidLicenseSpdxIds();
        CdxLicenseExporter cdxLicenseExporter = new CdxLicenseExporter(validSpdxIds);
        CdxBomExporter exporter = new CdxBomExporter(new CdxMetadataExporter(), new CdxLibraryExporter(cdxLicenseExporter), new CdxFileExporter(cdxLicenseExporter), new CdxVulnerabilityExporter(), arg_0 -> ((VulnerabilityDao)this.vulnerabilityDao).findByVId(arg_0));
        Bom cdxBom = exporter.extractCdxBom(context);
        context.notify((Event)BomExporterEvents.exportCycloneDxWriting());
        try {
            if (BomExportFormat.CYCLONE_DX_XML.equals((Object)context.getConfiguration().getExportFormat())) {
                return BomGeneratorFactory.createXml((Version)Version.VERSION_15, (Bom)cdxBom).toXmlString().getBytes();
            }
            return BomGeneratorFactory.createJson((Version)Version.VERSION_15, (Bom)cdxBom).toJsonString().getBytes();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to write Cyclone-dx BOM Export ", t);
        }
    }

    private @NonNull ExporterContext makeExportContext(FullBomVertex bomVertex, BomExportConfiguration configuration) {
        this.incrementProgress(configuration);
        Map complianceLookup = this.buildLicenseComplianceLookup(bomVertex.getId(), configuration);
        this.incrementProgress(configuration);
        List components = this.collectComponents(bomVertex.getId(), complianceLookup);
        this.incrementProgress(configuration);
        this.addComponentSnippets(components);
        this.incrementProgress(configuration);
        HashSet spdxIdList = new HashSet();
        TreeSet<VulnerabilityView> uniqueVulnerabilities = new TreeSet<VulnerabilityView>(Comparator.comparing(VulnerabilityView::getVulId));
        for (ComponentView component : components) {
            if (configuration.isExportFiles()) {
                List files = this.getComponentFilesWithLicenses(component.getId(), complianceLookup);
                component.setFiles((Collection)files);
                files.forEach(file -> spdxIdList.addAll(this.collectLicensesIds(file.getLicenses())));
            }
            uniqueVulnerabilities.addAll(component.getVulnerabilities());
            spdxIdList.addAll(this.collectLicensesIds((Collection)component.getLicenses()));
        }
        List vulnerabilities = uniqueVulnerabilities.stream().sorted(Comparator.comparing(VulnerabilityView::getVulId)).collect(Collectors.toList());
        this.incrementProgress(configuration);
        List licensesList = this.collectLicenses(spdxIdList);
        this.incrementProgress(configuration);
        KPIsView kpIs = this.collectKpisData(bomVertex);
        this.incrementProgress(configuration);
        Long fileCount = this.fileDao.countByBom(bomVertex.getId());
        Long componentCount = this.componentDao.countByBom(bomVertex.getId());
        this.incrementProgress(configuration);
        String reviewStep = this.preferencesService.findReviewStep(bomVertex.getReviewStep().intValue()).map(ReviewStep::getName).orElse("created");
        this.incrementProgress(configuration);
        return new ExporterContext(configuration, bomVertex.getProduct().getName(), bomVertex.getProject().getName(), (String)bomVertex.getVersion().getProperty("name"), bomVertex.getLicensePolicy().getName(), bomVertex.getCreated(), reviewStep, components, vulnerabilities, kpIs, licensesList, fileCount, componentCount);
    }

    private Map<String, ComplianceLevel> buildLicenseComplianceLookup(@NonNull String bomId, BomExportConfiguration configuration) {
        return this.licenseDao.findBomLicenses(bomId).stream().collect(Collectors.toMap(LicenseVertex::getSpdxId, BomLicenseVertex::getComplianceLevel));
    }

    private List<ComponentView> collectComponents(@NonNull String bomId, Map<String, ComplianceLevel> complianceMapping) {
        return this.componentDao.findBomComponents(bomId).stream().map(c -> ComponentTransforms.from((BomComponentVertex)c, (String)bomId, (Map)complianceMapping)).sorted(Comparator.comparing(ComponentView::getCategory)).collect(Collectors.toList());
    }

    private void addComponentSnippets(@NonNull List<ComponentView> components) {
        if (CollectionUtils.isNotEmpty(components)) {
            components.stream().filter(component -> component.getCounter().getFiles() == 0L).forEach(component -> this.snippetDao.findByComponent(component.getOriginalId()).stream().findFirst().flatMap(sv -> this.fileDao.findBySnippet(sv.getVertex().getIdentity().toString())).ifPresent(fv -> component.setDeclaredBy(fv.getPath() + fv.getName())));
        }
    }

    private List<FileView> getComponentFilesWithLicenses(@NonNull String componentId, Map<String, ComplianceLevel> complianceMapping) {
        return this.fileDao.findByComponentWithLicense(RequestUtils.decodeId((String)componentId)).stream().map(fileVertex -> FilesTransformer.from((FileVertex)fileVertex, (Map)complianceMapping)).sorted(Comparator.comparing(NamedView::getName)).collect(Collectors.toList());
    }

    private @NonNull List<LicenseVertex> collectLicenses(@NonNull Set<String> spdxIds) {
        return spdxIds.stream().distinct().map(s -> this.licenseDao.findBySpdxId(s).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Set<String> collectLicensesIds(@NonNull Collection<LightLicenseView> licenses) {
        return licenses.stream().map(LightLicenseView::getSpdxId).collect(Collectors.toSet());
    }

    private KPIsView collectKpisData(@NonNull FullBomVertex bomVertex) {
        return this.kpiDao.findByBom(bomVertex.getId()).map(KpiTransformer::from).orElseThrow(NoSuchElementException::new);
    }

    private void incrementProgress(@NonNull BomExportConfiguration configuration) {
        configuration.notify((Event)BomExporterEvents.exportContextPreparingIncrementEvent());
    }

    private void log(@NonNull FullBomVertex bomVertex, String format, Object ... objects) {
        String stdFormat = "[Exporting][BOM %s] ";
        LOGGER.info(String.format(Optional.ofNullable(format).map(stdFormat::concat).orElse(stdFormat), Stream.concat(Stream.of(String.join((CharSequence)":", bomVertex.getProduct().getName(), bomVertex.getProject().getName(), (CharSequence)bomVertex.getVersion().getProperty("name"))), Optional.ofNullable(objects).stream().flatMap(Stream::of)).toArray(Object[]::new)));
    }

    private void logExportDuration(FullBomVertex bomVertex, long startTime) {
        long duration = System.nanoTime() - startTime;
        this.log(bomVertex, "Finished exporting BOM - Duration : " + this.getMinutesSecondsTime(Long.valueOf(duration)), new Object[0]);
    }

    private String getMinutesSecondsTime(Long nanos) {
        long tempSec = nanos / 1000000000L;
        long sec = tempSec % 60L;
        long min = tempSec / 60L % 60L;
        return String.format("%d minutes : %d seconds", min, sec);
    }
}

