/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.handler;

import com.castsoftware.sca.scar.server.bom.domain.BomExport;
import com.castsoftware.sca.scar.server.bom.handler.BomExportMonitor;
import com.castsoftware.sca.scar.server.bom.handler.BomExporterEvents;
import com.castsoftware.sca.scar.server.bom.service.export.utils.FilesUtils;
import com.castsoftware.sca.scar.server.monitoring.domain.PhaseType;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressPhase;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStep;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.util.java.exception.Exceptions;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class BomExportMonitor
implements BomExporterEvents.BomExporterVisitor,
EventListener {
    private final AtomicBoolean waiting = new AtomicBoolean(false);
    private final Executor unWaitingThread = Executors.newSingleThreadExecutor();
    private final BomExport export;
    private final FilesUtils fU;
    private final ProgressPhase startingPhase;
    private final ProgressPhase elementsPhase;
    private final ProgressPhase risksPhase;
    private final ProgressPhase kpisPhase;
    private final ProgressPhase finishPhase;
    private final ProgressStep exportContextPreparingStep;
    private final ProgressStep exportBomInfosStep;
    private final ProgressStep exportComponentsStep;
    private final ProgressStep exportComponentsAndFilesStep;
    private final ProgressStep exportFilesStep;
    private final ProgressStep resizeFileColumnsStep;
    private final ProgressStep resizeComponentColumnsStep;
    private final ProgressStep exportVulnerabilitiesStep;
    private final ProgressStep resizeVulnerabilityColumnsStep;
    private final ProgressStep exportLicencesStep;
    private final ProgressStep resizeLicenseColumnsStep;
    private final ProgressStep exportKPIsStep;
    private final ProgressStep writingStep;
    private final ProgressStep downloadingStep;
    private final AtomicLong numberOfContextElements = new AtomicLong(0L);
    private final AtomicLong numberOfComponentsAndFiles = new AtomicLong(0L);
    private final AtomicLong numberOfComponents = new AtomicLong(0L);
    private final AtomicLong numberOfFiles = new AtomicLong(0L);
    private final AtomicLong numberOfVulnerabilities = new AtomicLong(0L);
    private final AtomicLong numberOfLicences = new AtomicLong(0L);

    public BomExportMonitor(BomExport export, FilesUtils filesUtils) {
        this.export = export;
        this.fU = filesUtils;
        this.startingPhase = new ProgressPhase(PhaseType.EXPORT, this.fU.t("scar_export_progress-starting-phase"), 1);
        this.elementsPhase = new ProgressPhase(PhaseType.ELEMENTS, this.fU.t("scar_export_progress-element-phases"), 1);
        this.risksPhase = new ProgressPhase(PhaseType.RISKS, this.fU.t("scar_export_progress-risks-phase"), 1);
        this.kpisPhase = new ProgressPhase(PhaseType.KPIS, this.fU.t("scar_export_progress-kpis-phase"), 1);
        this.finishPhase = new ProgressPhase(PhaseType.FINAL, this.fU.t("scar_export_progress-finalize-phase"), 1);
        this.exportContextPreparingStep = new ProgressStep(this.fU.t("scar_export_progress-preparing-step"), 1);
        this.exportBomInfosStep = new ProgressStep(this.fU.t("scar_export_progress-infos-step"), 3);
        this.exportComponentsStep = new ProgressStep(this.fU.t("scar_export_progress-comps-step"), 2);
        this.exportComponentsAndFilesStep = new ProgressStep(this.fU.t("scar_export_progress-comps-files-step"), 6);
        this.exportFilesStep = new ProgressStep(this.fU.t("scar_export_progress-files-step"), 3);
        this.resizeFileColumnsStep = new ProgressStep(this.fU.t("scar_export_progress-resizing-files-step"), 1);
        this.resizeComponentColumnsStep = new ProgressStep(this.fU.t("scar_export_progress-resizing-comps-step"), 1);
        this.exportVulnerabilitiesStep = new ProgressStep(this.fU.t("scar_export_progress-vul-step"), 1);
        this.resizeVulnerabilityColumnsStep = new ProgressStep(this.fU.t("scar_export_progress-resizing-vul-step"), 1);
        this.exportLicencesStep = new ProgressStep(this.fU.t("scar_export_progress-licenses-step"), 1);
        this.resizeLicenseColumnsStep = new ProgressStep(this.fU.t("scar_export_progress-resizing-licenses-step"), 1);
        this.exportKPIsStep = new ProgressStep(this.fU.t("scar_export_progress-kpis-step"), 4);
        this.writingStep = new ProgressStep(this.fU.t("scar_export_progress-writing"), 1);
        this.downloadingStep = new ProgressStep(this.fU.t("scar_export_progress-downloading"), 1);
        export.getMonitor().addPhase(this.startingPhase);
        this.startingPhase.addStep(this.exportContextPreparingStep);
        if (export.getConfiguration().isExportComponents() || export.getConfiguration().isExportFiles()) {
            export.getMonitor().addPhase(this.elementsPhase);
        }
        switch (1.$SwitchMap$com$castsoftware$sca$scar$server$bom$domain$BomExportFormat[export.getConfiguration().getExportFormat().ordinal()]) {
            case 1: {
                this.startingPhase.addStep(this.exportBomInfosStep);
                if (export.getConfiguration().isExportComponents()) {
                    this.elementsPhase.addStep(this.exportComponentsStep);
                }
                if (export.getConfiguration().isExportKpis()) {
                    export.getMonitor().addPhase(this.kpisPhase);
                    this.kpisPhase.addStep(this.exportKPIsStep);
                }
                export.getMonitor().addPhase(this.risksPhase);
                this.risksPhase.addStep(this.exportVulnerabilitiesStep);
                this.risksPhase.addStep(this.exportLicencesStep);
                break;
            }
            case 2: {
                if (export.getConfiguration().isExportComponents()) {
                    this.elementsPhase.addStep(this.exportComponentsStep);
                    this.elementsPhase.addStep(this.resizeComponentColumnsStep);
                }
                if (export.getConfiguration().isExportFiles()) {
                    this.elementsPhase.addStep(this.exportFilesStep);
                    this.elementsPhase.addStep(this.resizeFileColumnsStep);
                }
                export.getMonitor().addPhase(this.risksPhase);
                this.risksPhase.addStep(this.exportVulnerabilitiesStep);
                this.risksPhase.addStep(this.resizeVulnerabilityColumnsStep);
                this.risksPhase.addStep(this.exportLicencesStep);
                this.risksPhase.addStep(this.resizeLicenseColumnsStep);
                if (!export.getConfiguration().isExportKpis()) break;
                export.getMonitor().addPhase(this.kpisPhase);
                this.kpisPhase.addStep(this.exportKPIsStep);
                break;
            }
            case 3: 
            case 4: {
                if (export.getConfiguration().isExportFiles()) {
                    this.elementsPhase.addStep(this.exportComponentsAndFilesStep);
                    break;
                }
                this.elementsPhase.addStep(this.exportComponentsStep);
            }
        }
        export.getMonitor().addPhase(this.finishPhase);
        this.finishPhase.addStep(this.writingStep);
        this.finishPhase.addStep(this.downloadingStep);
    }

    public void visit(BomExporterEvents.ExportContextPreparingEvent exportContextPreparingEvent) {
        this.exportContextPreparingStep.start();
        this.numberOfContextElements.set(exportContextPreparingEvent.getNumberOfContextElements().intValue());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportContextPreparingIncrementEvent exportContextPreparingIncrementEvent) {
        this.exportContextPreparingStep.add(100.0 / (double)this.numberOfContextElements.get());
        this.broadcast();
    }

    public void visit(BomExporterEvents.ExportBomInfosEvent exportBomInfosEvent) {
        this.exportContextPreparingStep.stop();
        this.exportBomInfosStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportXlsxComponentsEvent exportXlsxComponentsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.start();
        this.numberOfComponents.set(exportXlsxComponentsEvent.getNumberOfComponents().intValue());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportDocxComponentsEvent exportDocxComponentsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportBomInfosStep.stop();
        this.exportKPIsStep.stop();
        this.exportComponentsStep.start();
        this.numberOfComponents.set(exportDocxComponentsEvent.getNumberOfComponents().intValue());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportCycloneDxComponentsEvent exportCycloneDxComponentsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.start();
        this.numberOfComponents.set(exportCycloneDxComponentsEvent.getNumberOfComponents());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportComponentEvent exportComponentEvent) {
        this.exportComponentsStep.add(100.0 / (double)this.numberOfComponents.get());
        this.broadcast();
    }

    public void visit(BomExporterEvents.ExportComponentsAndFilesEvent exportComponentsAndFilesEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsAndFilesStep.start();
        this.numberOfComponentsAndFiles.set(exportComponentsAndFilesEvent.getNumberOfComponentsAndFiles());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportComponentOrFileEvent exportComponentAndFileEvent) {
        this.exportComponentsAndFilesStep.add(100.0 / (double)this.numberOfComponentsAndFiles.get());
        this.broadcast();
    }

    public void visit(BomExporterEvents.ExportXlsxFilesEvent exportXlsxFilesEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.start();
        this.numberOfFiles.set(exportXlsxFilesEvent.getNumberOfFiles());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportFileEvent exportFileEvent) {
        this.exportFilesStep.add(100.0 / (double)this.numberOfFiles.get());
        this.broadcast();
    }

    public void visit(BomExporterEvents.ExportVulnerabilitiesEvent exportVulnerabilitiesEvent) {
        this.exportContextPreparingStep.stop();
        this.exportBomInfosStep.stop();
        this.exportKPIsStep.stop();
        this.exportComponentsStep.stop();
        this.exportVulnerabilitiesStep.start();
        this.numberOfVulnerabilities.set(exportVulnerabilitiesEvent.getNumberOfVulnerabilities());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportVulnerabilityEvent exportVulnerabilityEvent) {
        this.exportVulnerabilitiesStep.add(100.0 / (double)this.numberOfVulnerabilities.get());
        this.broadcast();
    }

    public void visit(BomExporterEvents.ResizeComponentColumnsEvent resizeComponentColumnsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ResizeFileColumnsEvent resizeFileColumnsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.stop();
        this.resizeFileColumnsStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ResizeLicenseColumnsEvent resizeLicenseColumnsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.stop();
        this.resizeFileColumnsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.resizeVulnerabilityColumnsStep.stop();
        this.exportLicencesStep.stop();
        this.resizeLicenseColumnsStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ResizeVulnerabilityColumnsEvent resizeVulnerabilityColumnsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.stop();
        this.resizeFileColumnsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.resizeVulnerabilityColumnsStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportXlsxLicencesEvent exportXlsxLicencesEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.stop();
        this.resizeFileColumnsStep.stop();
        this.exportLicencesStep.start();
        this.numberOfLicences.set(exportXlsxLicencesEvent.getNumberOfLicences());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportDocxLicencesEvent exportDocxLicencesEvent) {
        this.exportContextPreparingStep.stop();
        this.exportBomInfosStep.stop();
        this.exportKPIsStep.stop();
        this.exportComponentsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.exportLicencesStep.start();
        this.numberOfLicences.set(exportDocxLicencesEvent.getNumberOfLicences());
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportLicenceEvent exportLicenceEvent) {
        this.exportLicencesStep.add(100.0 / (double)this.numberOfLicences.get());
        this.broadcast();
    }

    public void visit(BomExporterEvents.ExportXlsxKPIsEvent exportXlsxKPIsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.stop();
        this.resizeFileColumnsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.resizeVulnerabilityColumnsStep.stop();
        this.exportLicencesStep.stop();
        this.resizeLicenseColumnsStep.stop();
        this.exportKPIsStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportDocxKPIsEvent exportDocxKPIsEvent) {
        this.exportContextPreparingStep.stop();
        this.exportBomInfosStep.stop();
        this.exportComponentsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.exportLicencesStep.stop();
        this.exportKPIsStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportXlsxWritingEvent exportXlsxWritingEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.stop();
        this.resizeFileColumnsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.resizeVulnerabilityColumnsStep.stop();
        this.exportLicencesStep.stop();
        this.resizeLicenseColumnsStep.stop();
        this.exportKPIsStep.stop();
        this.writingStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportDocxWritingEvent exportDocxWritingEvent) {
        this.exportContextPreparingStep.stop();
        this.exportBomInfosStep.stop();
        this.exportKPIsStep.stop();
        this.exportComponentsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.exportLicencesStep.stop();
        this.writingStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportCycloneDxWritingEvent exportCycloneDxWritingEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsAndFilesStep.stop();
        this.exportComponentsStep.stop();
        this.writingStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportXlsxDownloadingEvent exportXlsxDownloadingEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsStep.stop();
        this.resizeComponentColumnsStep.stop();
        this.exportFilesStep.stop();
        this.resizeFileColumnsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.resizeVulnerabilityColumnsStep.stop();
        this.exportLicencesStep.stop();
        this.resizeLicenseColumnsStep.stop();
        this.exportKPIsStep.stop();
        this.writingStep.stop();
        this.downloadingStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportDocxDownloadingEvent exportDocxDownloadingEvent) {
        this.exportContextPreparingStep.stop();
        this.exportBomInfosStep.stop();
        this.exportKPIsStep.stop();
        this.exportComponentsStep.stop();
        this.exportVulnerabilitiesStep.stop();
        this.exportLicencesStep.stop();
        this.writingStep.stop();
        this.downloadingStep.start();
        this.broadcast(true);
    }

    public void visit(BomExporterEvents.ExportCycloneDxDownloadingEvent exportCycloneDxDownloadingEvent) {
        this.exportContextPreparingStep.stop();
        this.exportComponentsAndFilesStep.stop();
        this.exportComponentsStep.stop();
        this.writingStep.stop();
        this.downloadingStep.start();
        this.broadcast(true);
    }

    public <V extends Event.EventVisitor> void visit(Event.Finish finish) {
        this.finishPhase.stop();
        this.broadcast(true);
    }

    public void on(Event event) {
        event.accept((Event.EventVisitor)this);
    }

    private void broadcast() {
        this.broadcast(false);
    }

    private void broadcast(boolean force) {
        Optional.ofNullable(this.export).filter(b -> force || !this.waiting.get()).ifPresent(b -> {
            b.update();
            if (!this.waiting.get()) {
                this.waiting.set(true);
                this.unLock();
            }
        });
    }

    private void unLock() {
        this.unWaitingThread.execute(() -> {
            try {
                Thread.sleep(1000L);
                this.waiting.set(false);
            }
            catch (InterruptedException e) {
                throw Exceptions.wrap((Throwable)e);
            }
        });
    }
}

