/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.handler;

import com.castsoftware.sca.scar.server.analyzer.BomCreator;
import com.castsoftware.sca.scar.server.analyzer.BomCreatorEvents;
import com.castsoftware.sca.scar.server.analyzer.BomWizardConfiguration;
import com.castsoftware.sca.scar.server.analyzer.scanner.ArchiveScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.CatalogScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.CycloneDxScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.FileScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.GitScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.HlCsvScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.PreviousScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.ScaScanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.Scanner;
import com.castsoftware.sca.scar.server.analyzer.scanner.packageScanner.PackageScanner;
import com.castsoftware.sca.scar.server.bom.domain.BomBuild;
import com.castsoftware.sca.scar.server.bom.handler.BomWriter;
import com.castsoftware.sca.scar.server.bom.handler.BomWriterEvents;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.monitoring.domain.PhaseType;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressPhase;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStatus;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStep;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.util.java.exception.Exceptions;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class BomBuildMonitor
implements BomCreatorEvents.BomCreatorVisitor,
BomWriterEvents.BomWriterVisitor,
KPIComputer.Events.ComputeEventVisitor,
EventListener {
    private final AtomicBoolean waiting = new AtomicBoolean(false);
    private final Executor unWaitingThread = Executors.newSingleThreadExecutor();
    private final BomBuild build;
    private final ProgressPhase scan = new ProgressPhase(PhaseType.SCAN, "Scanning SBOM", 3);
    private final ProgressStep configureScan = new ProgressStep("Configure creation", 1);
    private final ProgressStep git = new ProgressStep("Git repository cloning", 2);
    private final ProgressStep archive = new ProgressStep("Archive decompressing", 1);
    private final ProgressStep file = new ProgressStep("File scanning", 1);
    private final ProgressStep hlcsv = new ProgressStep("HL CSV (zip) scanning", 1);
    private final ProgressStep packg = new ProgressStep("Package scanning", 1);
    private final ProgressStep previous = new ProgressStep("Previous SBOM scanning", 2);
    private final ProgressStep catalog = new ProgressStep("Catalog scanning", 2);
    private final ProgressStep sca = new ProgressStep("SCA scanning", 3);
    private final ProgressStep cdxParsing = new ProgressStep("CycloneDx SBOM parsing", 1);
    private final ProgressStep cdxMapping = new ProgressStep("CycloneDx SBOM mapping", 1);
    private final ProgressPhase save = new ProgressPhase(PhaseType.SAVE, "Save SBOM", 2);
    private final ProgressStep configureProjectStep = new ProgressStep("Configuring SBOM", 0);
    private final ProgressStep bomStep = new ProgressStep("Saving SBOM", 1);
    private final ProgressStep componentsStep = new ProgressStep("Saving Components", 3);
    private final ProgressStep filesStep = new ProgressStep("Saving Files", 2);
    private final ProgressPhase computeKPI = new ProgressPhase(PhaseType.COMPUTE_KPI, "Computing SBOM KPI", 1);
    private final ProgressStep startComputeKPI = new ProgressStep("Starting compute", 1);
    private final ProgressStep componentsComputeKPI = new ProgressStep("Counting SBOM components", 2);
    private final ProgressStep filesComputeKPI = new ProgressStep("Counting SBOM files", 2);
    private final ProgressStep licensesComputeKPI = new ProgressStep("Counting SBOM licenses", 2);
    private final ProgressStep vulnerabilitiesComputeKPI = new ProgressStep("Counting SBOM vulnerabilities", 2);
    private final ProgressStep bomAggregatedKPI = new ProgressStep("Computing SBOM aggregated data", 3);
    private final ProgressStep componentAggregatedKPI = new ProgressStep("Computing components aggregated data", 4);
    private final ProgressStep fileAggregatedKPI = new ProgressStep("Computing files aggregated data", 3);
    private final AtomicLong numberOfComponent = new AtomicLong(0L);
    private final AtomicLong numberOfFile = new AtomicLong(0L);

    public BomBuildMonitor(BomBuild build) {
        this.build = build;
        build.getMonitor().addPhase(this.scan);
        this.scan.addStep(this.configureScan);
        build.getMonitor().addPhase(this.save);
        this.save.addStep(this.configureProjectStep);
        this.save.addStep(this.bomStep);
        this.save.addStep(this.componentsStep);
        this.save.addStep(this.filesStep);
        build.getMonitor().addPhase(this.computeKPI);
        this.computeKPI.addStep(this.startComputeKPI);
        this.computeKPI.addStep(this.componentsComputeKPI);
        this.computeKPI.addStep(this.filesComputeKPI);
        this.computeKPI.addStep(this.licensesComputeKPI);
        this.computeKPI.addStep(this.vulnerabilitiesComputeKPI);
        this.computeKPI.addStep(this.bomAggregatedKPI);
        this.computeKPI.addStep(this.componentAggregatedKPI);
        this.computeKPI.addStep(this.fileAggregatedKPI);
    }

    public void visit(BomCreatorEvents.ConfigureCreator start) {
        this.configureScan.start();
        this.broadcast(true);
    }

    public <SCANNER extends Scanner> void visit(BomCreatorEvents.AddScan<SCANNER> scannerEvent) {
        Optional event = this.extractScanner(scannerEvent);
        event.filter(GitScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.git));
        event.filter(ArchiveScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.archive));
        event.filter(FileScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.file));
        event.filter(HlCsvScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.hlcsv));
        event.filter(CycloneDxScanner.class::isInstance).ifPresent(s -> {
            this.scan.addStep(this.cdxParsing);
            this.scan.addStep(this.cdxMapping);
        });
        event.filter(PackageScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.packg));
        event.filter(PreviousScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.previous));
        event.filter(CatalogScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.catalog));
        event.filter(ScaScanner.class::isInstance).ifPresent(s -> this.scan.addStep(this.sca));
        this.broadcast(true);
    }

    public <SCANNER extends Scanner> void visit(BomCreatorEvents.Scan<SCANNER> scannerEvent) {
        Optional event = this.extractScanner(scannerEvent);
        Optional.of(this.configureScan).filter(ps -> ProgressStatus.RUNNING.equals((Object)ps.getStatus())).ifPresent(ProgressStep::stop);
        event.filter(GitScanner.class::isInstance).ifPresent(s -> this.startStep(this.git, new ProgressStep[]{this.archive, this.file, this.hlcsv, this.packg, this.previous, this.catalog, this.sca, this.cdxParsing}));
        event.filter(ArchiveScanner.class::isInstance).ifPresent(s -> this.startStep(this.archive, new ProgressStep[]{this.git, this.file, this.hlcsv, this.packg, this.previous, this.catalog, this.sca, this.cdxParsing}));
        event.filter(FileScanner.class::isInstance).ifPresent(s -> this.startStep(this.file, new ProgressStep[]{this.git, this.archive, this.hlcsv, this.packg, this.previous, this.catalog, this.sca, this.cdxParsing}));
        event.filter(HlCsvScanner.class::isInstance).ifPresent(s -> this.startStep(this.hlcsv, new ProgressStep[]{this.file, this.git, this.archive, this.packg, this.previous, this.catalog, this.sca, this.cdxParsing}));
        event.filter(CycloneDxScanner.class::isInstance).ifPresent(s -> this.startStep(this.cdxParsing, new ProgressStep[]{this.packg, this.hlcsv, this.file, this.git, this.archive, this.previous, this.catalog, this.sca}));
        event.filter(PackageScanner.class::isInstance).ifPresent(s -> this.startStep(this.packg, new ProgressStep[]{this.hlcsv, this.file, this.git, this.archive, this.previous, this.catalog, this.sca, this.cdxParsing}));
        event.filter(PreviousScanner.class::isInstance).ifPresent(s -> this.startStep(this.previous, new ProgressStep[]{this.hlcsv, this.file, this.git, this.archive, this.packg, this.catalog, this.sca, this.cdxParsing}));
        event.filter(CatalogScanner.class::isInstance).ifPresent(s -> this.startStep(this.catalog, new ProgressStep[]{this.hlcsv, this.file, this.git, this.archive, this.packg, this.previous, this.sca, this.cdxParsing}));
        event.filter(ScaScanner.class::isInstance).ifPresent(s -> this.startStep(this.sca, new ProgressStep[]{this.hlcsv, this.file, this.git, this.archive, this.packg, this.previous, this.catalog, this.cdxParsing}));
        this.broadcast(true);
    }

    public <SCANNER extends Scanner> void visit(BomCreatorEvents.Read<SCANNER> scannerEvent) {
        Optional event = this.extractScanner(scannerEvent);
        event.filter(GitScanner.class::isInstance).ifPresent(s -> this.git.add(scannerEvent.getProgression().doubleValue()));
        event.filter(ArchiveScanner.class::isInstance).ifPresent(s -> this.archive.add(scannerEvent.getProgression().doubleValue()));
        event.filter(FileScanner.class::isInstance).ifPresent(s -> this.file.add(scannerEvent.getProgression().doubleValue()));
        event.filter(HlCsvScanner.class::isInstance).ifPresent(s -> this.hlcsv.add(scannerEvent.getProgression().doubleValue()));
        event.filter(CycloneDxScanner.class::isInstance).ifPresent(s -> this.cdxParsing.add(scannerEvent.getProgression().doubleValue()));
        event.filter(PackageScanner.class::isInstance).ifPresent(s -> this.packg.add(scannerEvent.getProgression().doubleValue()));
        event.filter(PreviousScanner.class::isInstance).ifPresent(s -> this.previous.add(scannerEvent.getProgression().doubleValue()));
        event.filter(CatalogScanner.class::isInstance).ifPresent(s -> this.catalog.add(scannerEvent.getProgression().doubleValue()));
        event.filter(ScaScanner.class::isInstance).ifPresent(s -> this.sca.add(scannerEvent.getProgression().doubleValue()));
        this.broadcast();
    }

    public void visit(BomCreatorEvents.CdxParsingEvent cdxParsingEvent) {
        this.cdxParsing.start();
        this.broadcast(true);
    }

    public void visit(BomCreatorEvents.CdxMappingEvent cdxMappingEvent) {
        this.cdxParsing.stop();
        this.cdxMapping.start();
        this.broadcast(true);
    }

    public void visit(BomWriterEvents.ConfigureProjectEvent configureProjectEvent) {
        if (BomWizardConfiguration.SourceType.CYCLONE_DX.equals((Object)this.build.getConfiguration().getSourceType())) {
            this.cdxMapping.stop();
        }
        this.configureProjectStep.start();
        this.broadcast(true);
    }

    public void visit(BomWriterEvents.CreateBomEvent createBomEvent) {
        this.configureProjectStep.stop();
        this.bomStep.start();
        this.broadcast(true);
    }

    public void visit(BomWriterEvents.CreateComponentsEvent createComponentsEvent) {
        this.configureProjectStep.stop();
        this.bomStep.stop();
        this.componentsStep.start();
        this.numberOfComponent.set(createComponentsEvent.getNumberOfComponent());
        this.broadcast(true);
    }

    public void visit(BomWriterEvents.CreateComponentEvent createComponentEvent) {
        this.componentsStep.add(100.0 / (double)this.numberOfComponent.get());
        this.broadcast();
    }

    public void visit(BomWriterEvents.CreateTreeEvent createTreeFolderEvent) {
        this.configureProjectStep.stop();
        this.bomStep.stop();
        this.componentsStep.stop();
        this.filesStep.start();
        this.numberOfFile.set(createTreeFolderEvent.getNumberOfFiles());
        this.broadcast(true);
    }

    public void visit(BomWriterEvents.CreateNodeEvent createNodeEvent) {
        this.filesStep.add(100.0 / (double)this.numberOfFile.get());
        this.broadcast();
    }

    public void visit(KPIComputer.Events.StartComputeEvent startComputeEvent) {
        this.startComputeKPI.start();
        this.broadcast(true);
    }

    public void visit(KPIComputer.Events.ComponentsCountComputeEvent componentsCountComputeEvent) {
        this.startComputeKPI.stop();
        this.componentsComputeKPI.start();
        this.broadcast(true);
    }

    public void visit(KPIComputer.Events.FilesCountComputeEvent filesCountComputeEvent) {
        this.startComputeKPI.stop();
        this.componentsComputeKPI.stop();
        this.filesComputeKPI.start();
        this.broadcast(true);
    }

    public void visit(KPIComputer.Events.LicensesCountComputeEvent licensesCountComputeEvent) {
        this.startComputeKPI.stop();
        this.componentsComputeKPI.stop();
        this.filesComputeKPI.stop();
        this.licensesComputeKPI.start();
        this.broadcast(true);
    }

    public void visit(KPIComputer.Events.VulnerabilitiesCountComputeEvent vulnerabilitiesCountComputeEvent) {
        this.startComputeKPI.stop();
        this.componentsComputeKPI.stop();
        this.filesComputeKPI.stop();
        this.licensesComputeKPI.stop();
        this.vulnerabilitiesComputeKPI.start();
        this.broadcast(true);
    }

    public void visit(KPIComputer.Events.BomAggregatedComputeEvent bomAggregatedComputeEvent) {
        this.startComputeKPI.stop();
        this.componentsComputeKPI.stop();
        this.filesComputeKPI.stop();
        this.licensesComputeKPI.stop();
        this.vulnerabilitiesComputeKPI.stop();
        this.bomAggregatedKPI.start();
        this.broadcast(true);
    }

    public void visit(KPIComputer.Events.ComponentAggregatedComputeEvent componentAggregatedComputeEvent) {
        this.startComputeKPI.stop();
        this.componentsComputeKPI.stop();
        this.filesComputeKPI.stop();
        this.licensesComputeKPI.stop();
        this.vulnerabilitiesComputeKPI.stop();
        this.bomAggregatedKPI.stop();
        this.componentAggregatedKPI.start();
        this.broadcast(true);
    }

    public void visit(KPIComputer.Events.FileAggregatedComputeEvent fileAggregatedComputeEvent) {
        this.startComputeKPI.stop();
        this.componentsComputeKPI.stop();
        this.filesComputeKPI.stop();
        this.licensesComputeKPI.stop();
        this.vulnerabilitiesComputeKPI.stop();
        this.bomAggregatedKPI.stop();
        this.componentAggregatedKPI.stop();
        this.fileAggregatedKPI.start();
        this.broadcast(true);
    }

    public void visit(Event.Finish finish) {
        if (BomCreator.class.isAssignableFrom(finish.getSource())) {
            this.scan.stop();
        }
        if (BomWriter.class.isAssignableFrom(finish.getSource())) {
            this.save.stop();
        }
        if (KPIComputer.class.isAssignableFrom(finish.getSource())) {
            this.computeKPI.stop();
        }
        this.broadcast(true);
    }

    public void on(Event event) {
        event.accept((Event.EventVisitor)this);
    }

    private void startStep(ProgressStep start, ProgressStep ... stop) {
        Optional.ofNullable(stop).stream().flatMap(Stream::of).forEach(ps -> Optional.of(ps).map(ProgressStep::getStatus).filter(arg_0 -> ProgressStatus.RUNNING.equals(arg_0)).ifPresent(status -> ps.stop()));
        Optional.ofNullable(start).ifPresent(ProgressStep::start);
    }

    private <SCANNER extends Scanner> Optional<? extends Scanner> extractScanner(BomCreatorEvents.BomCreatorScannerEvent<SCANNER> scannerEvent) {
        return Optional.ofNullable(scannerEvent).map(BomCreatorEvents.BomCreatorScannerEvent::getScanner);
    }

    private void broadcast() {
        this.broadcast(false);
    }

    private void broadcast(boolean force) {
        Optional.ofNullable(this.build).filter(b -> force || !this.waiting.get()).ifPresent(b -> {
            b.update();
            if (!this.waiting.get()) {
                this.waiting.set(true);
                this.unLock();
            }
        });
    }

    private void unLock() {
        this.unWaitingThread.execute(() -> {
            try {
                Thread.sleep(1000L);
                this.waiting.set(false);
            }
            catch (InterruptedException e) {
                throw Exceptions.wrap((Throwable)e);
            }
        });
    }
}

