/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.handler;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.util.java.Suppliers;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public class AnalyzerBomFetcher {
    private final CentralDao centralDao;
    private final BomDao bomDao;
    private final ComponentDao componentDao;
    private final FileDao fileDao;
    private final SnippetDao snippetDao;
    private final VulnerabilityDao vulnerabilityDao;
    private final LicenseDao licenseDao;

    public AnalyzerBomFetcher(CentralDao centralDao, BomDao bomDao, ComponentDao componentDao, FileDao fileDao, SnippetDao snippetDao, VulnerabilityDao vulnerabilityDao, LicenseDao licenseDao) {
        this.centralDao = centralDao;
        this.bomDao = bomDao;
        this.componentDao = componentDao;
        this.fileDao = fileDao;
        this.snippetDao = snippetDao;
        this.vulnerabilityDao = vulnerabilityDao;
        this.licenseDao = licenseDao;
    }

    public String getCatalogId() {
        return this.centralDao.getCatalog().getId();
    }

    public Optional<FileVertex> getFileFromSha256(String sha256, String bomId) {
        return this.fileDao.findBySha256(sha256).stream().filter(f -> ((BomVertex)this.bomDao.findByFile(f.getId()).orElseThrow(Suppliers.illegalState((String)"no bom attached"))).getId().equals(bomId)).findFirst();
    }

    public Optional<SnippetVertex> getSnippetFromNameAndVersion(String name, String version, String bomId) {
        return this.snippetDao.findByNameAndVersion(name, version).stream().filter(s -> ((BomVertex)this.bomDao.findBySnippet(s.getId()).orElseThrow(Suppliers.illegalState((String)"no bom attached"))).getId().equals(bomId)).findFirst();
    }

    public Optional<ComponentVertex> getComponentFromFile(String id) {
        return this.componentDao.findByFile(id);
    }

    public Optional<ComponentVertex> getComponentFromSnippet(String id) {
        return this.componentDao.findBySnippet(id);
    }

    public BomComponentVertex getComponentWithLV(String id) {
        return this.componentDao.findByIdWithLV(id).filter(BomComponentVertex.class::isInstance).map(BomComponentVertex.class::cast).orElseThrow(NoSuchElementException::new);
    }

    public Optional<VulnerabilityVertex> getVulnerability(String id) {
        return this.vulnerabilityDao.findByVId(id);
    }

    public List<LicenseVertex> findAllLicenses() {
        return this.licenseDao.findAll();
    }
}

