/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.exception;

import com.castsoftware.sca.scar.server.core.exception.ResourceNotFoundException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BomExceptions {
    public static @NonNull ResourceNotFoundException bomNotFound(@NonNull String bomId) {
        return new ResourceNotFoundException("bom_not_found", String.format("Bom with id '%s' cannot be found.", StringUtils.defaultIfBlank((CharSequence)bomId, (CharSequence)"{MISSING}")));
    }

    public static @NonNull ResourceNotFoundException catalogNotFound() {
        return new ResourceNotFoundException("catalog_not_found", "The central catalog cannot be found");
    }

    public static @NonNull ResourceNotFoundException componentNotFound(@NonNull String componentId) {
        return new ResourceNotFoundException("component_not_found", String.format("Component with id '%s' cannot be found", StringUtils.defaultIfBlank((CharSequence)componentId, (CharSequence)"{MISSING}")));
    }

    public static @NonNull ResourceNotFoundException kpisNotFound(@NonNull String bomId) {
        return new ResourceNotFoundException("kpis_not_found", String.format("Kpis not found for Bom with id '%s'", StringUtils.defaultIfBlank((CharSequence)bomId, (CharSequence)"{MISSING}")));
    }

    public static @NonNull ResourceNotFoundException productNotFound(@NonNull String productId) {
        return new ResourceNotFoundException("product_not_found", String.format("Product with id '%s' cannot be found.", StringUtils.defaultIfBlank((CharSequence)productId, (CharSequence)"{MISSING}")));
    }

    public static @NonNull ResourceNotFoundException projectNotFound(@NonNull String projectId) {
        return new ResourceNotFoundException("project_not_found", String.format("Project with id '%s' cannot be found.", StringUtils.defaultIfBlank((CharSequence)projectId, (CharSequence)"{MISSING}")));
    }

    public static @NonNull ResourceNotFoundException rootNodeNotFound(@NonNull String bomId) {
        return new ResourceNotFoundException("root_node_not_found", String.format("Root node for Bom with id '%s' cannot be found.", StringUtils.defaultIfBlank((CharSequence)bomId, (CharSequence)"{MISSING}")));
    }

    @Generated
    private BomExceptions() {
    }
}

