/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.domain;

import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.NodeVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.castsoftware.sca.scar.server.util.visitable.SCArVertexVisitor;
import com.castsoftware.sca.util.java.Predicates;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FileVertex
extends NodeVertex {
    private List<LicenseVertex> licenses;

    public FileVertex(String name) {
        super(name);
    }

    public FileVertex(OVertexDocument vertex) {
        super(vertex);
    }

    public FileVertex(OVertexDocument vertex, List<LicenseVertex> licenses) {
        super(vertex);
        this.setLicenses(licenses);
    }

    public boolean isFolder() {
        return false;
    }

    public VClassDefinition definition() {
        return BOMClassDefinition.V.VFile;
    }

    public String getPath() {
        return (String)this.getProperty("path", (Object)"unknown");
    }

    public void setPath(String path) {
        this.setProperty("path", (Object)path, Predicates.notEmptyString());
    }

    public String getSha256() {
        return (String)this.getProperty("sha256", (Object)"undefined");
    }

    public void setSha256(String sha256) {
        this.setProperty("sha256", (Object)sha256);
    }

    public String getSha1() {
        return (String)this.getProperty("sha1", (Object)"undefined");
    }

    public void setSha1(String sha1) {
        this.setProperty("sha1", (Object)sha1);
    }

    public String getMd5() {
        return (String)this.getProperty("md5", (Object)"undefined");
    }

    public void setMd5(String md5) {
        this.setProperty("md5", (Object)md5);
    }

    public long getSize() {
        return (Long)this.getProperty("size", (Object)-1L);
    }

    public void setSize(long size) {
        this.setProperty("size", (Object)size);
    }

    public String getVersion() {
        return (String)this.getProperty("version", (Object)"");
    }

    public void setVersion(String version) {
        this.setProperty("version", (Object)version, Predicates.notEmptyString());
    }

    public String getComments() {
        return (String)this.getProperty("comments", (Object)"");
    }

    public void setComments(String comments) {
        this.setProperty("comments", (Object)comments, Predicates.notEmptyString());
    }

    public List<LicenseVertex> getLicenses() {
        return Optional.ofNullable(this.licenses).orElseGet(ArrayList::new);
    }

    public void setLicenses(List<LicenseVertex> licenses) {
        Optional.ofNullable(licenses).ifPresent(l -> {
            this.licenses = l;
        });
    }

    public String getCopyright() {
        return (String)this.getProperty("copyright", (Object)"");
    }

    public void setCopyright(String copyright) {
        this.setProperty("copyright", (Object)copyright);
    }

    public FileVertex copy() {
        FileVertex copiedVertex = new FileVertex(this.getName());
        VertexUtils.getFieldNames(Fields.class).forEach(f -> copiedVertex.setProperty(f, this.getPropertyOrNull(f)));
        return copiedVertex;
    }

    public void accept(SCArVertexVisitor visitor) {
        visitor.visit(this);
    }
}

