/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.domain;

import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.util.visitable.SCArVertexVisitor;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.time.Instant;
import java.util.Optional;

public class BomVertex
extends Vertex<SCArVertexVisitor> {
    public BomVertex() {
    }

    public BomVertex(OVertexDocument vertex) {
        super(vertex);
    }

    public VClassDefinition definition() {
        return BOMClassDefinition.V.VBom;
    }

    public boolean isAvailable() {
        return (Boolean)this.getProperty("available", (Object)false);
    }

    public void setAvailable(boolean available) {
        this.setProperty("available", (Object)available);
    }

    public boolean isCatalog() {
        return (Boolean)this.getProperty("catalog", (Object)false);
    }

    public void setCatalog(boolean catalog) {
        this.setProperty("catalog", (Object)catalog);
    }

    public Instant getCreated() {
        return Instant.ofEpochSecond((Long)this.getProperty("created", (Object)0L));
    }

    public void setCreated(Instant instant) {
        Optional.ofNullable(instant).map(Instant::getEpochSecond).ifPresent(i -> this.setProperty("created", i));
    }

    public Instant getUpdated() {
        return Instant.ofEpochSecond((Long)this.getProperty("updated", (Object)0L));
    }

    public void setUpdated(Instant instant) {
        Optional.ofNullable(instant).map(Instant::getEpochSecond).ifPresent(i -> this.setProperty("updated", i));
    }

    public void setScannerConfiguration(String scannerConfiguration) {
        this.setProperty("scan", (Object)scannerConfiguration);
    }

    public Integer getReviewStep() {
        return (Integer)this.getProperty("review", (Object)0);
    }

    public void setReviewStep(Integer reviewStep) {
        this.setProperty("review", (Object)reviewStep);
    }

    public void accept(SCArVertexVisitor visitor) {
        visitor.visit(this);
    }
}

