/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.dao;

import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.util.java.Predicates;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.Query;
import org.jooq.SelectField;
import org.jooq.impl.DSL;

/*
 * Exception performing whole class analysis ignored.
 */
public class SnippetDao
extends GraphDao<SnippetVertex> {
    public SnippetDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)BOMClassDefinition.V.VSnippet);
    }

    public Collection<SnippetVertex> findByNameAndVersion(String name, String version) {
        return this.listDomain(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.queryBuilder.selectFrom(this.definition.name()).where(Fields.NAME.eq((Object)Optional.ofNullable(name).filter(Predicates.notEmptyString()).orElseThrow(IllegalArgumentException::new))).and(Optional.ofNullable(version).filter(Predicates.notEmptyString()).map(arg_0 -> ((Field)Fields.VERSION).eq(arg_0)).orElseGet(() -> ((Field)Fields.VERSION).isNull())), new Object[]{name, version});
    }

    public Collection<SnippetVertex> findByComponent(String idComponent) {
        return this.findByComponent(idComponent, null);
    }

    public Collection<SnippetVertex> findByComponent(String idComponent, ODatabaseSession currentSession) {
        return this.findByLink(idComponent, BOMClassDefinition.E.EDeclaredBy, currentSession);
    }

    public Collection<SnippetVertex> findByFile(String idFile) {
        return this.findByFile(idFile, null);
    }

    public Collection<SnippetVertex> findByFile(String idFile, ODatabaseSession currentSession) {
        return this.findByLink(idFile, BOMClassDefinition.E.EPart, currentSession);
    }

    public Long countByBom(String bomId) {
        return (Long)this.query(session -> {
            String traverseComponent = SnippetDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.ECategory.name()}), (String)bomId, (Integer)2);
            return this.countSnippets(traverseComponent, BOMClassDefinition.E.EDeclaredBy, session);
        });
    }

    public Long countByComponent(String componentId) {
        return (Long)this.query(session -> this.countSnippets(componentId, BOMClassDefinition.E.EDeclaredBy, session));
    }

    public FileVertex searchParentFileByComponent(String componentId) {
        return (FileVertex)this.query(session -> this.searchDeclaredByFile(componentId, session));
    }

    public Long countByFile(String fileId) {
        return (Long)this.query(session -> this.countSnippets(fileId, BOMClassDefinition.E.EPart, session));
    }

    private Collection<SnippetVertex> findByLink(String idFrom, BOMClassDefinition.E linkType, ODatabaseSession currentSession) {
        String projections = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{linkType.name(), BOMClassDefinition.V.VSnippet.name()});
        return (Collection)this.query(session -> session.query(this.queryBuilder.selectFrom(SnippetDao.traverse((String)projections, (String)idFrom)).toString(), new Object[0]).vertexStream().map(OVertexDocument.class::cast).filter(v -> BOMClassDefinition.V.VSnippet.name().equals(v.getClassName())).map(SnippetVertex::new).collect(Collectors.toList()), currentSession);
    }

    private Long countSnippets(String fromId, BOMClassDefinition.E linkType, ODatabaseSession session) {
        String traverseFile = SnippetDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{linkType.name()}), (String)fromId, (Integer)2);
        String query = this.queryBuilder.select((SelectField)DSL.count().as("count")).from(traverseFile).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VSnippet.name())).toString();
        return session.query(query, new Object[0]).stream().filter(r -> r.hasProperty("count")).map(r -> r.getProperty("count")).map(Long.class::cast).findFirst().orElse(-1L);
    }

    @NotNull
    private FileVertex searchDeclaredByFile(String fromId, ODatabaseSession session) {
        String query = "select out from EPart where @rid = ?";
        OResultSet rs = session.query(query, new Object[]{fromId});
        String result = null;
        while (rs.hasNext()) {
            OResult item = rs.next();
            assert (item != null);
            result = item.getProperty("out").toString();
        }
        FileVertex fv = null;
        if (result != null) {
            String query2 = "select * from VFile where @rid = ?";
            OResultSet rs2 = session.query(query2, new Object[]{result});
            while (rs2.hasNext()) {
                OResult item = rs2.next();
                assert (item != null);
                fv = new FileVertex(item.getProperty("name").toString());
                fv.setPath(item.getProperty("path").toString());
            }
        }
        return fv;
    }
}

