/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.dao;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.ProjectDao;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.ProjectVertex;
import com.castsoftware.sca.scar.server.bom.domain.VersionInfo;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.kpi.domain.KPIVertex;
import com.castsoftware.sca.scar.server.kpi.structure.KPIClassDefinition;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.Predicates;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.Condition;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep1;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectDao
extends GraphDao<ProjectVertex> {
    public ProjectDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)BOMClassDefinition.V.VProject);
    }

    public Optional<ProjectVertex> findByProductAndName(String productId, String name) {
        List result = this.listDomain(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.selectFromByProduct(productId).and(Fields.NAME.eq((Object)((String)Opt.ofBlankString((String)name).orElseThrow(IllegalArgumentException::new)))), new Object[]{this.definition.name(), name});
        return result.stream().findFirst();
    }

    public List<ProjectVertex> searchByProductAndName(String productId, String name) {
        String startWith = "%".concat(Optional.ofNullable(name).filter(Predicates.notEmptyString()).orElseThrow(IllegalArgumentException::new).concat("%"));
        return this.listDomain(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.selectFromByProduct(productId).and((Condition)Fields.NAME.like(startWith)), new Object[]{this.definition.name(), startWith});
    }

    public List<ProjectVertex> findAllByProduct(String productId) {
        return this.listDomain(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.selectFromByProduct(Guards.notBlank((String)productId)), new Object[]{this.definition.name()});
    }

    public List<ProjectVertex> findEmptyProjects() {
        return this.listDomain(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.queryBuilder.selectFrom(this.definition.name()).where(String.format("outE(%s).size()=0", BOMClassDefinition.E.EVersion.name())), new Object[]{this.definition.name()});
    }

    public Collection<String> findVersions(String id) {
        SelectConditionStep query = this.queryBuilder.selectFrom(GraphDao.traverseOutEdge((String)((String)Opt.ofBlankString((String)id).orElseThrow(IllegalArgumentException::new)))).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.E.EVersion.name()));
        return this.listEdge(edge -> Optional.of(edge).filter(e -> e.getPropertyNames().contains("name")).map(e -> (String)e.getProperty("name")).orElse("Unknown"), (Query)query, new Object[]{BOMClassDefinition.E.EVersion.name()});
    }

    public Collection<VersionInfo> findAllVersionInfo(String projectId) {
        String traverseBom = ProjectDao.traverse((Collection)Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE.value(new String[]{BOMClassDefinition.E.EVersion.name()}), GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EPolicy.name()}), GraphDao.TraverseType.OUT_DEFINED.value(new String[]{KPIClassDefinition.E.EKPI.name()})).collect(Collectors.toList()), (String)ProjectDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EVersion.name()}), (String)projectId), (Integer)2);
        return (Collection)this.query(session -> session.query(this.queryBuilder.selectFrom(traverseBom).where(GraphDao.MetaFields.clazz.ne((Object)BOMClassDefinition.V.VProject.name())).toString(), new Object[0]).edgeStream().map(arg_0 -> this.from(arg_0)).collect(Collectors.toList()));
    }

    public void addBom(ProjectVertex project, BomVertex bom, String newVersion) {
        this.linkWithUpdate((Vertex)project, (Vertex)bom, (EClassDefinition)BOMClassDefinition.E.EVersion, edge -> edge.setProperty("name", (Object)newVersion));
    }

    public Collection<String> findBomBuildConfiguration(String projectId) {
        SelectSeekStep1 query = this.queryBuilder.select((SelectField)BomDao.Fields.SCAN).from(ProjectDao.traverseOut((String)projectId)).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VBom.name())).orderBy((OrderField)BomDao.Fields.CREATED.desc());
        return (Collection)this.query(arg_0 -> ProjectDao.lambda$findBomBuildConfiguration$7((Query)query, arg_0));
    }

    public List<BomVertex> findBoms(ProjectVertex projectVertex, ODatabaseSession session) {
        SelectConditionStep query = this.queryBuilder.selectFrom(ProjectDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EVersion.name()}), (String)projectVertex.getId())).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VBom.name()));
        return this.listVertex(session, BomVertex::new, query.toString(), new Object[0]);
    }

    private VersionInfo from(OEdge oVersion) {
        String version = Optional.of(oVersion).filter(e -> e.getPropertyNames().contains("name")).map(e -> (String)e.getProperty("name")).orElse("UNKNOWN VERSION");
        BomVertex bom = new BomVertex((OVertexDocument)OVertexDocument.class.cast(oVersion.getTo()));
        LicensePolicyVertex licensePolicy = StreamSupport.stream(bom.getVertex().getVertices(ODirection.OUT, new String[]{BOMClassDefinition.E.EPolicy.name()}).spliterator(), false).map(OVertexDocument.class::cast).map(LicensePolicyVertex::new).findFirst().orElse(null);
        KPIVertex kpi = StreamSupport.stream(bom.getVertex().getVertices(ODirection.OUT, new String[]{KPIClassDefinition.E.EKPI.name()}).spliterator(), false).map(OVertexDocument.class::cast).map(KPIVertex::new).findFirst().orElseGet(KPIVertex::new);
        return new VersionInfo(oVersion.getIdentity(), version, bom, licensePolicy, kpi);
    }

    private SelectConditionStep<Record> selectFromByProduct(String productId) {
        return this.queryBuilder.selectFrom(GraphDao.traverseOut((String)productId)).where(GraphDao.MetaFields.clazz.eq((Object)this.definition.name()));
    }

    private static /* synthetic */ List lambda$findBomBuildConfiguration$7(Query query, ODatabaseSession session) {
        return session.query(query.getSQL(), new Object[]{BOMClassDefinition.V.VBom.name()}).stream().filter(r -> r.getPropertyNames().contains("scan")).map(r -> (String)r.getProperty("scan")).collect(Collectors.toList());
    }
}

