/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.dao;

import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.Query;
import org.jooq.SelectField;
import org.jooq.impl.DSL;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileDao
extends GraphDao<FileVertex> {
    public FileDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)BOMClassDefinition.V.VFile);
    }

    public void addLicense(FileVertex file, LicenseVertex license) {
        this.addLicense(file, license, null);
    }

    public void addLicense(FileVertex file, LicenseVertex license, ODatabaseSession session) {
        this.link((Vertex)file, (Vertex)license, (EClassDefinition)BOMClassDefinition.E.ELicense, session);
    }

    public void addSnippet(FileVertex file, SnippetVertex snippet) {
        this.addSnippet(file, snippet, null);
    }

    public void addSnippet(FileVertex file, SnippetVertex snippet, ODatabaseSession session) {
        this.link((Vertex)file, (Vertex)snippet, (EClassDefinition)BOMClassDefinition.E.EPart, session);
    }

    public Collection<FileVertex> findByComponentWithLicense(String componentId) {
        Collection projections = Stream.of(GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.EContains.name(), BOMClassDefinition.V.VFile.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX, GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.EContains.name(), BOMClassDefinition.V.VFile.name(), BOMClassDefinition.E.ELicense.name(), BOMClassDefinition.V.VLicense.name()})).collect(Collectors.toList());
        return (Collection)this.query(session -> this.queryWithLicense(session, FileDao.traverse((Collection)projections, (String)componentId)).collect(Collectors.toList()));
    }

    public Optional<FileVertex> findByIdWithLicense(String id) {
        return this.findByIdWithLicense(id, null);
    }

    public Optional<FileVertex> findByIdWithLicense(String id, ODatabaseSession currentSession) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.ELicense.name(), BOMClassDefinition.V.VLicense.name()});
        return (Optional)this.query(session -> this.queryWithLicense(session, FileDao.traverse((String)projection, (String)id)).findFirst(), currentSession);
    }

    public Collection<FileVertex> findByComponent(String idComponent) {
        return this.findByComponent(idComponent, null);
    }

    public Collection<FileVertex> findByComponent(String idComponent, ODatabaseSession currentSession) {
        String projections = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.EContains.name(), BOMClassDefinition.V.VFile.name()});
        return (Collection)this.query(session -> session.query(this.queryBuilder.selectFrom(FileDao.traverse((String)projections, (String)idComponent)).toString(), new Object[0]).vertexStream().map(OVertexDocument.class::cast).filter(v -> BOMClassDefinition.V.VFile.name().equals(v.getClassName())).map(FileVertex::new).collect(Collectors.toList()), currentSession);
    }

    public Collection<FileVertex> findByBom(String bomId) {
        Collection projections = Stream.of(GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.ECategory.name(), BOMClassDefinition.V.VComponent.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX), (String[])new String[]{BOMClassDefinition.E.EContains.name(), BOMClassDefinition.V.VFile.name()})).collect(Collectors.toList());
        return (Collection)this.query(session -> session.query(this.queryBuilder.selectFrom(FileDao.traverse((Collection)projections, (String)bomId, (Integer)2)).toString(), new Object[0]).vertexStream().map(OVertexDocument.class::cast).filter(v -> BOMClassDefinition.V.VFile.name().equals(v.getClassName())).map(FileVertex::new).collect(Collectors.toList()), null);
    }

    public Optional<FileVertex> findBySnippet(String idSnippet) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EPart.name()});
        return this.listVertex(FileVertex::new, (Query)this.queryBuilder.selectFrom(FileDao.traverse((String)projection, (String)idSnippet)), new Object[]{BOMClassDefinition.V.VFile.name()}).stream().findFirst();
    }

    public List<FileVertex> findBySha256(String sha256) {
        return this.listByIndex(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), BOMClassDefinition.I.IFileSha256.name(), sha256);
    }

    public Long countByBom(String bomId) {
        return (Long)this.query(session -> {
            String traverseComponent = FileDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.ECategory.name()}), (String)bomId, (Integer)2);
            return this.countFiles(traverseComponent, session);
        });
    }

    public Long countByComponent(String componentId) {
        return (Long)this.query(session -> this.countFiles(componentId, session));
    }

    private Stream<FileVertex> queryWithLicense(ODatabaseSession session, String traverse) {
        return session.query(this.queryBuilder.selectFrom(traverse).toString(), new Object[0]).vertexStream().map(OVertexDocument.class::cast).filter(v -> BOMClassDefinition.V.VFile.name().equals(v.getClassName())).map(FileVertex::new).peek(fileVertex -> fileVertex.setLicenses(Optional.of(fileVertex).map(Vertex::getVertex).map(v -> v.getEdges(ODirection.OUT, new String[]{BOMClassDefinition.E.ELicense.name()})).map(Iterable::spliterator).map(sp -> StreamSupport.stream(sp, false)).orElseGet(Stream::empty).map(OEdge::getTo).map(OVertexDocument.class::cast).map(LicenseVertex::new).collect(Collectors.toList())));
    }

    private Long countFiles(String componentId, ODatabaseSession session) {
        String traverseFile = FileDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EContains.name()}), (String)componentId, (Integer)2);
        String query = this.queryBuilder.select((SelectField)DSL.count().as("count")).from(traverseFile).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VFile.name())).toString();
        return session.query(query, new Object[0]).stream().filter(r -> r.hasProperty("count")).map(r -> r.getProperty("count")).map(Long.class::cast).findFirst().orElse(-1L);
    }
}

