/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.dao;

import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.CatalogBomVertex;
import com.castsoftware.sca.scar.server.bom.domain.CentralVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.core.db.ODatabasePool;
import java.util.Optional;
import org.jooq.Query;

/*
 * Exception performing whole class analysis ignored.
 */
public class CentralDao
extends GraphDao<CentralVertex> {
    public CentralDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)BOMClassDefinition.V.VCentral);
    }

    public BomVertex getCatalogWithPolicy() {
        BomVertex catalog = this.getCatalog();
        LicensePolicyVertex policy = (LicensePolicyVertex)this.listVertex(LicensePolicyVertex::new, (Query)this.queryBuilder.selectFrom(CentralDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EPolicy.name()}), (String)catalog.getId())).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VLicensePolicy.name())), new Object[]{BOMClassDefinition.V.VLicensePolicy.name()}).stream().findFirst().orElseThrow(IllegalStateException::new);
        return new CatalogBomVertex(catalog, policy);
    }

    public BomVertex getCatalog() {
        return (BomVertex)this.searchCatalog(this.getCentral().getId()).orElseThrow(Suppliers.illegalState((String)"Catalog is not defined"));
    }

    public void setCatalog(BomVertex catalog) {
        CentralVertex central = this.getCentral();
        this.searchCatalog(central.getId()).ifPresent(s -> {
            throw new IllegalStateException("Catalog is already defined");
        });
        this.link((Vertex)central, (Vertex)catalog, (EClassDefinition)BOMClassDefinition.E.ECatalog);
    }

    private Optional<BomVertex> searchCatalog(String centralId) {
        return this.listVertex(BomVertex::new, (Query)this.queryBuilder.selectFrom(CentralDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.ECatalog.name()}), (String)centralId)).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VBom.name())), new Object[]{BOMClassDefinition.V.VBom.name()}).stream().findFirst();
    }

    public CentralVertex getCentral() {
        return (CentralVertex)this.searchCentral().orElseThrow(Suppliers.illegalState((String)"Central node is not defined"));
    }

    private Optional<CentralVertex> searchCentral() {
        return this.findAll().stream().findFirst();
    }

    public LicensePolicyVertex getDefaultPolicy() {
        return (LicensePolicyVertex)this.searchDefaultPolicy(this.getCentral().getId()).orElseThrow(Suppliers.illegalState((String)"No default license policy defined"));
    }

    private Optional<LicensePolicyVertex> searchDefaultPolicy(String centralId) {
        return this.listVertex(LicensePolicyVertex::new, (Query)this.queryBuilder.selectFrom(CentralDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.EDefaultPolicy.name()}), (String)centralId)).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VLicensePolicy.name())), new Object[]{BOMClassDefinition.V.VLicensePolicy.name()}).stream().findFirst();
    }

    public void setDefaultPolicy(LicensePolicyVertex defaultPolicy) {
        CentralVertex central = this.getCentral();
        this.searchDefaultPolicy(central.getId()).ifPresent(dlp -> this.unlink((Vertex)central, (Vertex)dlp, (EClassDefinition)BOMClassDefinition.E.EDefaultPolicy));
        this.link((Vertex)this.getCentral(), (Vertex)defaultPolicy, (EClassDefinition)BOMClassDefinition.E.EDefaultPolicy);
    }
}

