/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.bom.dao;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.CatalogBomVertex;
import com.castsoftware.sca.scar.server.bom.domain.CategoryInfo;
import com.castsoftware.sca.scar.server.bom.domain.FolderVertex;
import com.castsoftware.sca.scar.server.bom.domain.FullBomVertex;
import com.castsoftware.sca.scar.server.bom.domain.ProductVertex;
import com.castsoftware.sca.scar.server.bom.domain.ProjectVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.kpi.domain.KPIVertex;
import com.castsoftware.sca.scar.server.kpi.structure.KPIClassDefinition;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectWhereStep;
import org.jooq.impl.DSL;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class BomDao
extends GraphDao<BomVertex> {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(BomDao.class);

    public BomDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)BOMClassDefinition.V.VBom);
    }

    public void addComponent(BomVertex bom, ComponentVertex component, String categoryName) {
        this.addComponent(bom, component, categoryName, null);
    }

    public void addComponent(BomVertex bom, ComponentVertex component, String categoryName, ODatabaseSession session) {
        this.link((Vertex)((BomVertex)Guards.notNull((Object)bom, (Supplier)Suppliers.illegalArgument((String)"Bom is mandatory"))), (Vertex)((ComponentVertex)Guards.notNull((Object)component, (Supplier)Suppliers.illegalArgument((String)"Component is mandatory"))), (EClassDefinition)BOMClassDefinition.E.ECategory, e -> e.setProperty("ref", (Object)Guards.notBlank((String)categoryName, (Supplier)Suppliers.illegalArgument((String)"Category name is mandatory"))), session);
    }

    public void addRoot(BomVertex bom, FolderVertex rootFolder) {
        this.link((Vertex)bom, (Vertex)rootFolder, (EClassDefinition)BOMClassDefinition.E.ERoot);
    }

    public void addPolicy(BomVertex bom, LicensePolicyVertex policy) {
        this.link((Vertex)bom, (Vertex)policy, (EClassDefinition)BOMClassDefinition.E.EPolicy);
    }

    public List<CategoryInfo> findCategoryInfo(String bomId) {
        String countComponents = "components";
        Field ref = DSL.field((String)"ref", String.class);
        SelectHavingStep query = this.queryBuilder.select((SelectField)ref, (SelectField)DSL.count((Field)ref).as("components")).from(BomDao.traverseOutEdge((String)Guards.notBlank((String)bomId))).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.E.ECategory.name())).groupBy(new GroupField[]{ref});
        return (List)this.query(arg_0 -> BomDao.lambda$findCategoryInfo$2((Query)query, arg_0));
    }

    public Optional<FolderVertex> findRootNode(String bomId, ODatabaseSession session) {
        return this.listVertex(session, FolderVertex::new, (Query)this.queryBuilder.selectFrom(BomDao.traverseOut((String)bomId)).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VFolder.name())), new Object[]{BOMClassDefinition.V.VFolder.name()}).stream().findFirst();
    }

    public Optional<FolderVertex> findRootNode(String bomId) {
        return this.findRootNode(bomId, null);
    }

    public Optional<BomVertex> findById(String id) {
        Collection projections = Stream.of(GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EVersion.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX, GraphDao.TraverseType.IN), (String[])new String[]{BOMClassDefinition.E.EVersion.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_VERTEX), (String[])new String[]{BOMClassDefinition.E.EPolicy.name()})).collect(Collectors.toList());
        SelectWhereStep traverseQuery = this.queryBuilder.selectFrom(BomDao.traverse((Collection)projections, (String)id, (Integer)2));
        return this.listFull((Query)traverseQuery).stream().findFirst();
    }

    public List<BomVertex> findAll() {
        String bomsWithVersion = BomDao.traverse((String)GraphDao.TraverseType.IN_VERTEX.value(new String[0]), (String)BOMClassDefinition.E.EVersion.name());
        Collection projections = Stream.of(GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EVersion.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX, GraphDao.TraverseType.IN), (String[])new String[]{BOMClassDefinition.E.EVersion.name()}), GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_VERTEX), (String[])new String[]{BOMClassDefinition.E.EPolicy.name()})).collect(Collectors.toList());
        SelectConditionStep traverseQuery = this.queryBuilder.selectFrom(BomDao.traverse((Collection)projections, (String)bomsWithVersion, (Integer)2)).where(GraphDao.MetaFields.clazz.ne((Object)BOMClassDefinition.E.EVersion.name()));
        return this.listFull((Query)traverseQuery);
    }

    public List<BomVertex> findByDateLimit(Field<Long> field, int limit) {
        SelectLimitPercentStep query = this.queryBuilder.selectFrom(this.definition.name()).where(Fields.CATALOG.notEqual((Object)true)).and(Fields.AVAILABLE.isTrue()).orderBy((OrderField)field.desc()).limit((Number)limit);
        return this.listFull((Query)query);
    }

    public Optional<Long> countAll() {
        SelectConditionStep traverseQuery = this.queryBuilder.selectCount().from(BomDao.traverse((String)GraphDao.TraverseType.IN_VERTEX.value(new String[0]), (String)BOMClassDefinition.E.EVersion.name())).where(GraphDao.MetaFields.clazz.ne((Object)BOMClassDefinition.E.EVersion.name()));
        return (Optional)this.query(arg_0 -> BomDao.lambda$countAll$4((Query)traverseQuery, arg_0));
    }

    public Optional<BomVertex> findByComponent(String idComponent) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.ECategory.name()});
        return this.listVertex(BomVertex::new, (Query)this.queryBuilder.selectFrom(BomDao.traverse((String)projection, (String)idComponent)), new Object[]{BOMClassDefinition.V.VBom.name()}).stream().findFirst();
    }

    public Optional<BomVertex> findByFile(String fileId) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX, GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EContains.name(), BOMClassDefinition.E.ECategory.name()});
        return this.listVertex(BomVertex::new, (Query)this.queryBuilder.selectFrom(BomDao.traverse((String)projection, (String)fileId)), new Object[]{BOMClassDefinition.V.VBom.name()}).stream().findFirst();
    }

    public Optional<BomVertex> findBySnippet(String snippetId) {
        String projection = GraphDao.TraverseType.concat(Stream.of(GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX, GraphDao.TraverseType.IN_DEFINED_EDGE, GraphDao.TraverseType.OUT_VERTEX), (String[])new String[]{BOMClassDefinition.E.EDeclaredBy.name(), BOMClassDefinition.E.ECategory.name()});
        return this.listVertex(BomVertex::new, (Query)this.queryBuilder.selectFrom(BomDao.traverse((String)projection, (String)snippetId)), new Object[]{BOMClassDefinition.V.VBom.name()}).stream().findFirst();
    }

    public List<BomVertex> findOrphanedBoms() {
        return this.listVertex(BomVertex::new, (Query)this.queryBuilder.selectFrom(this.definition.name()).where(String.format("in(%s).size()=0", BOMClassDefinition.E.EVersion.name())).and(Fields.CATALOG.notEqual((Object)true)), new Object[]{BOMClassDefinition.V.VBom.name()});
    }

    public void addKPI(BomVertex bomVertex, KPIVertex saved, ODatabaseSession session) {
        this.link((Vertex)bomVertex, (Vertex)saved, (EClassDefinition)KPIClassDefinition.E.EKPI, session);
    }

    private List<BomVertex> listFull(Query traverseQuery) {
        return (List)this.query(session -> session.query(traverseQuery.toString(), new Object[0]).vertexStream().map(OVertexDocument.class::cast).filter(ovd -> BOMClassDefinition.V.VBom.name().equals(ovd.getClassName())).map(BomVertex::new).map(bomVertex -> {
            LicensePolicyVertex licensePolicy = BomDao.licensePolicy((BomVertex)bomVertex);
            if (bomVertex.isCatalog()) {
                return new CatalogBomVertex(bomVertex, licensePolicy);
            }
            try {
                OEdge version = BomDao.version((BomVertex)bomVertex);
                ProjectVertex project = BomDao.project((OEdge)version);
                ProductVertex product = BomDao.product((ProjectVertex)project);
                return new FullBomVertex(bomVertex, product, project, version, licensePolicy);
            }
            catch (IllegalStateException ex) {
                LOGGER.warn("SBOM '{}' doesn't have a Version link! Skipping...", (Object)bomVertex.getId());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static OEdge version(BomVertex bomVertex) {
        return Optional.of(bomVertex).map(Vertex::getVertex).map(v -> v.getEdges(ODirection.IN, new String[]{BOMClassDefinition.E.EVersion.name()})).map(Iterable::iterator).filter(Iterator::hasNext).map(Iterator::next).orElseThrow(Suppliers.illegalState((String)"BOM without a Version link"));
    }

    private static ProjectVertex project(OEdge version) {
        return Optional.ofNullable(version).map(OEdge::getFrom).map(OVertexDocument.class::cast).map(ProjectVertex::new).orElseThrow(Suppliers.illegalState((String)"BOM without a linked Project"));
    }

    private static ProductVertex product(ProjectVertex project) {
        return Optional.of(project).map(Vertex::getVertex).map(v -> v.getEdges(ODirection.IN, new String[]{BOMClassDefinition.E.ELink.name()})).map(Iterable::iterator).filter(Iterator::hasNext).map(Iterator::next).map(OEdge::getFrom).map(OVertexDocument.class::cast).map(ProductVertex::new).orElseThrow(Suppliers.illegalState((String)"bom need product"));
    }

    private static LicensePolicyVertex licensePolicy(BomVertex bomVertex) {
        return Optional.of(bomVertex).map(Vertex::getVertex).map(v -> v.getEdges(ODirection.OUT, new String[]{BOMClassDefinition.E.EPolicy.name()})).map(Iterable::iterator).filter(Iterator::hasNext).map(Iterator::next).map(OEdge::getTo).map(OVertexDocument.class::cast).map(LicensePolicyVertex::new).orElseThrow(Suppliers.illegalState((String)"bom need license policy version"));
    }

    private static /* synthetic */ Optional lambda$countAll$4(Query traverseQuery, ODatabaseSession session) {
        return session.query(traverseQuery.toString(), new Object[0]).stream().map(o -> (Long)o.getProperty("count(*)")).findFirst();
    }

    private static /* synthetic */ List lambda$findCategoryInfo$2(Query query, ODatabaseSession session) {
        return session.query(query.toString(), new Object[0]).stream().map(oResult -> new CategoryInfo((String)oResult.getProperty("ref"), (Long)oResult.getProperty("components"))).collect(Collectors.toList());
    }
}

