/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.autoconfiguration.component.orientdb;

import com.castsoftware.sca.scar.server.autoconfiguration.component.orientdb.OSCArConfigurer;
import com.castsoftware.sca.scar.server.orientdb.EmbeddedServer;
import com.castsoftware.sca.scar.server.orientdb.configuration.Database;
import com.castsoftware.sca.scar.server.orientdb.configuration.Databases;
import com.castsoftware.sca.scar.server.orientdb.configuration.EmbeddedServerConfiguration;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.util.Optional;

public class OSCarBaseConfigurer
implements OSCArConfigurer {
    public void configure(EmbeddedServer server, EmbeddedServerConfiguration configuration) {
        Optional.of(configuration).map(EmbeddedServerConfiguration::getRoot).orElseThrow(Suppliers.illegalConfiguration((String)"root user is mandatory"));
        OServerNetworkProtocolConfiguration binary = new OServerNetworkProtocolConfiguration("binary", ONetworkProtocolBinary.class.getName());
        OServerNetworkListenerConfiguration listener = new OServerNetworkListenerConfiguration();
        listener.protocol = "binary";
        listener.portRange = configuration.getRangePort();
        server.addNetwork(binary, listener).addStorage("BOM", Optional.of(configuration).map(EmbeddedServerConfiguration::getDatabases).map(Databases::getBom)).addUser(configuration.getRoot().getLogin(), configuration.getRoot().getPassword(), "*").addProperty("useLightweightEdges", String.valueOf(true));
        Optional.of(configuration).map(EmbeddedServerConfiguration::getDatabases).map(Databases::getBom).map(Database::getUser).ifPresent(u -> server.addUser(u.getLogin(), u.getPassword(), "*"));
    }
}

