/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.autoconfiguration.component.orientdb;

import com.castsoftware.sca.scar.server.autoconfiguration.component.orientdb.OSCArConfigurer;
import com.castsoftware.sca.scar.server.orientdb.EmbeddedServer;
import com.castsoftware.sca.scar.server.orientdb.configuration.EmbeddedServerConfiguration;
import com.castsoftware.sca.scar.server.orientdb.configuration.StudioConfiguration;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpDb;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetStaticContent;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;

public class OSCArStudioConfigurer
implements OSCArConfigurer {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(OSCArStudioConfigurer.class);

    public void configure(EmbeddedServer server, EmbeddedServerConfiguration configuration) {
        try {
            server.addProperty("orientdb.www.path", configuration.getStudio().getPath());
            OServerNetworkListenerConfiguration httpListener = new OServerNetworkListenerConfiguration();
            OServerCommandConfiguration cmd = new OServerCommandConfiguration();
            cmd.implementation = OServerCommandGetStaticContent.class.getName();
            cmd.pattern = "GET|www GET|studio/ GET| GET|*.htm GET|*.html GET|*.xml GET|*.jpeg GET|*.jpg GET|*.png GET|*.gif GET|*.js GET|*.css GET|*.swf GET|*.ico GET|*.txt GET|*.otf GET|*.pjs GET|*.svg";
            cmd.parameters = (OServerEntryConfiguration[])Stream.of(new OServerEntryConfiguration("http.cache:*.htm *.html", "Cache-Control: no-cache, no-store, max-age=0, must-revalidate\\r\\nPragma: no-cache"), new OServerEntryConfiguration("http.cache:default", "Cache-Control: max-age=120")).toArray(OServerEntryConfiguration[]::new);
            httpListener.protocol = "http";
            httpListener.portRange = Optional.of(configuration).map(EmbeddedServerConfiguration::getStudio).map(StudioConfiguration::getRangePort).orElseThrow(Suppliers.illegalConfiguration((String)"Studio range port is mandatory"));
            httpListener.commands = (OServerCommandConfiguration[])Stream.of(cmd).toArray(OServerCommandConfiguration[]::new);
            server.addNetwork(new OServerNetworkProtocolConfiguration("http", ONetworkProtocolHttpDb.class.getName()), httpListener);
        }
        catch (Throwable e) {
            LOGGER.warn("Fail to launch orientdb Studio");
            Optional.of(LOGGER).filter(Logger::isDebugEnabled).ifPresent(l -> l.debug("fail", e));
        }
    }
}

