/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.autoconfiguration.component.application;

import com.castsoftware.sca.scar.server.api.handler.DisconnectBroadcaster;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ImageIcon;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class SCArTrayIcon
extends TrayIcon {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SCArTrayIcon.class);
    private static final String IMAGE_PATH = "/tray.png";
    private static final String TOOLTIP = "SBOM Manager";
    private final SystemTray tray;
    private final ConfigurableApplicationContext applicationContext;
    private final String url;
    private final DisconnectBroadcaster notifier;

    public SCArTrayIcon(ConfigurableApplicationContext applicationContext, String url, DisconnectBroadcaster notifier) throws AWTException {
        super(SCArTrayIcon.createImage((String)"/tray.png", (String)"SBOM Manager"), "SBOM Manager");
        this.applicationContext = applicationContext;
        this.url = Guards.notBlank((String)url);
        this.notifier = notifier;
        this.tray = SystemTray.getSystemTray();
        this.setup();
    }

    private void setup() throws AWTException {
        PopupMenu popup = new PopupMenu();
        MenuItem browse = new MenuItem("Open browser");
        browse.addActionListener(this.browse());
        popup.add(browse);
        MenuItem disconnect = new MenuItem("Disconnect server");
        disconnect.addActionListener(this.disconnect());
        popup.add(disconnect);
        this.setPopupMenu(popup);
        this.tray.add((TrayIcon)this);
    }

    private ActionListener browse() {
        return event -> {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(this.url));
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.error("Unable to open browser", (Throwable)e);
                }
            } else {
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.exec("rundll32 url.dll,FileProtocolHandler " + this.url);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to open browser", (Throwable)e);
                }
            }
        };
    }

    private ActionListener disconnect() {
        return event -> {
            this.notifier.notifyDisconnect();
            SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
            this.remove();
        };
    }

    public void remove() {
        this.tray.remove((TrayIcon)this);
    }

    protected static Image createImage(String path, String description) {
        URL imageURL = SCArTrayIcon.class.getResource(path);
        if (imageURL == null) {
            LOGGER.error("Failed to create image. Resource not found: " + path);
            throw new RuntimeException();
        }
        return new ImageIcon(imageURL, description).getImage();
    }
}

