/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.autoconfiguration.component.application;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.Launcher;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.Launchers;
import com.castsoftware.sca.util.java.Consumers;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SCArApplication {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SCArApplication.class);
    private static String homeFolder = ".scar";
    private final ConfigurableApplicationContext applicationContext;
    private final Function<String[], ConfigurableApplicationContext> starter;

    public static String getHomeFolder() {
        return homeFolder;
    }

    public static void setHomeFolder(String homeFolder) {
        SCArApplication.homeFolder = homeFolder;
    }

    public static <R> R defaultResourceLocation(Function<Path, R> transform) {
        return (R)(Paths.get(homeFolder, new String[0]).isAbsolute() ? Optional.of(Paths.get(homeFolder, new String[0])).map(Functions.peek(path -> Optional.of(path).filter(x$0 -> Files.notExists(x$0, new LinkOption[0])).ifPresent(Consumers.forwardThrowable(x$0 -> Files.createDirectories(x$0, new FileAttribute[0]))))).map((Function)Guards.notNull(transform)).orElseThrow(IllegalStateException::new) : Optional.ofNullable(System.getProperty("user.home")).map(x$0 -> Paths.get(x$0, new String[0])).map(p -> p.resolve(homeFolder)).map(Functions.peek(path -> Optional.of(path).filter(x$0 -> Files.notExists(x$0, new LinkOption[0])).ifPresent(Consumers.forwardThrowable(x$0 -> Files.createDirectory(x$0, new FileAttribute[0]))))).map((Function)Guards.notNull(transform)).orElseThrow(IllegalStateException::new));
    }

    public SCArApplication(ConfigurableApplicationContext applicationContext, Function<String[], ConfigurableApplicationContext> starter) {
        this.applicationContext = applicationContext;
        this.starter = starter;
    }

    public void start() {
        try {
            this.executeLaunchers(this.applicationContext);
        }
        catch (Launcher.RestartException exception) {
            this.restart();
        }
        catch (Exception other) {
            LOGGER.error("Failed to launch application", (Throwable)other);
            this.exit();
        }
    }

    public void restart() {
        ApplicationArguments args = (ApplicationArguments)this.applicationContext.getBean(ApplicationArguments.class);
        Stream<String> argsStr = args.getSourceArgs() != null ? Arrays.stream(args.getSourceArgs()) : Stream.empty();
        String[] sourceArgs = (String[])Stream.concat(argsStr.filter(s -> !s.contains("sca.scar.openBrowser")), Stream.of("--sca.scar.openBrowser=false")).toArray(String[]::new);
        Thread restartSpringBoot = new Thread(() -> {
            this.beforeClose();
            this.applicationContext.close();
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.starter.apply(sourceArgs);
            this.afterRestart(configurableApplicationContext);
            this.executeLaunchers(configurableApplicationContext);
        });
        restartSpringBoot.setDaemon(false);
        restartSpringBoot.start();
    }

    protected void exit() {
        SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1});
    }

    protected ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected void afterRestart(ConfigurableApplicationContext newApplicationContext) {
    }

    protected void beforeClose() {
    }

    private void executeLaunchers(ConfigurableApplicationContext setApplicationContext) {
        Optional.ofNullable(setApplicationContext).map(ctxt -> (Launchers)ctxt.getBean(Launchers.class)).map(Functions.peek(launchers -> Objects.requireNonNull(setApplicationContext).addApplicationListener(event -> launchers.destroy()))).ifPresent(Consumers.forwardThrowable(Launchers::launch, Exceptions::wrap));
    }
}

