/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.autoconfiguration.component.application;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.Launcher;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.NoDestroyLauncher;
import com.castsoftware.sca.util.java.Consumers;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class Launchers
implements Launcher {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(Launchers.class);
    private final List<Launcher> launchers;
    private final List<Launcher> stoppableLaunchers;

    public Launchers(List<Launcher> launchers) {
        this.launchers = launchers;
        this.stoppableLaunchers = launchers.stream().filter(Predicates.negate(NoDestroyLauncher.class::isInstance)).collect(Collectors.toList());
    }

    public void launch() throws Exception {
        this.launchers.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).peek(launcher -> LOGGER.info(String.format("Start launcher %s", launcher.getClass().getName()))).forEach(Consumers.forwardThrowable(Launcher::launch, Exceptions::wrap));
    }

    public void destroy() {
        this.stoppableLaunchers.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).peek(launcher -> LOGGER.info(String.format("Destroy launcher %s", launcher.getClass().getName()))).forEach(Launcher::destroy);
    }
}

