/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.autoconfiguration;

import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.Launcher;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.Launchers;
import com.castsoftware.sca.scar.server.autoconfiguration.component.thread.SCArThreadFactory;
import com.castsoftware.sca.scar.server.core.component.ServerStatusHolder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public class StarterAutoConfiguration {
    @Bean
    public ServerStatusHolder serverStatusHolder() {
        return new ServerStatusHolder();
    }

    @Bean
    @ConfigurationProperties(value="sca.scar")
    public ScarServerProperties serverConfiguration() {
        return new ScarServerProperties();
    }

    @Bean
    public ExecutorService globalExecutor(ScarServerProperties configuration) {
        return Executors.newFixedThreadPool(configuration.getThreadPoolAsync().getCount(), (ThreadFactory)new SCArThreadFactory(configuration.getThreadPoolAsync().getName()));
    }

    @Primary
    @Bean
    public Launcher defaultLauncher() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public Launchers launchers(List<Launcher> launchers) {
        return new Launchers(launchers);
    }
}

