/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.autoconfiguration;

import com.castsoftware.sca.scar.server.autoconfiguration.StarterAutoConfiguration;
import com.castsoftware.sca.scar.server.autoconfiguration.component.orientdb.OSCArConfigurer;
import com.castsoftware.sca.scar.server.autoconfiguration.component.orientdb.OSCarBaseConfigurer;
import com.castsoftware.sca.scar.server.orientdb.EmbeddedServer;
import com.castsoftware.sca.scar.server.orientdb.configuration.EmbeddedServerConfiguration;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(value={OServer.class})
@AutoConfigureAfter(value={StarterAutoConfiguration.class})
@ConditionalOnProperty(prefix="sca.scar.orientdb.server", name={"enabled"}, havingValue="true")
public class OSCArEmbeddedServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="sca.scar.orientdb.server")
    public EmbeddedServerConfiguration orientdbConfiguration() {
        return new EmbeddedServerConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public OServer oServer() throws Exception {
        System.setProperty("ORIENTDB_HOME", EmbeddedServer.DEFAULT_HOME_DIRECTORY.toString());
        return OServerMain.create();
    }

    @Bean
    public EmbeddedServer orientdbServer(OServer server, EmbeddedServerConfiguration configuration, List<OSCArConfigurer> configurers) throws Exception {
        EmbeddedServer embeddedServer = new EmbeddedServer(server, EmbeddedServer.DEFAULT_HOME_DIRECTORY);
        configurers.forEach(c -> c.configure(embeddedServer, configuration));
        embeddedServer.start();
        return embeddedServer;
    }

    @Primary
    @Bean
    public OSCArConfigurer basicConfigurer() {
        return new OSCarBaseConfigurer();
    }
}

