/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.application.service;

import com.castsoftware.sca.scar.server.application.configuration.MutableProperties;
import com.castsoftware.sca.scar.server.application.configuration.SamlProperties;
import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.configuration.SsoProperties;
import com.castsoftware.sca.scar.server.application.domain.ApplicationConnectionType;
import com.castsoftware.sca.scar.server.application.domain.ApplicationMode;
import com.castsoftware.sca.scar.server.application.handler.ConfigurationReader;
import com.castsoftware.sca.scar.server.application.handler.ConfigurationWriter;
import com.castsoftware.sca.scar.server.application.model.response.ServerConfigurationResponse;
import com.castsoftware.sca.scar.server.application.transformer.ConfigurationTransformer;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.SCArApplication;
import com.castsoftware.sca.scar.server.core.component.ServerStatusHolder;
import com.castsoftware.sca.scar.server.sam.configuration.SamAccountCredentials;
import com.castsoftware.sca.scar.server.sam.service.SamVersionCheckService;
import com.castsoftware.sca.scar.server.user.handler.OwnerWriter;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

public class ApplicationService {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ApplicationService.class);
    public static final Path DEFAULT_CONFIGURATION_LOCATION;
    public static final Path DEFAULT_CONFIGURATION_BACKUP_LOCATION;
    private final SCArApplication scarApplication;
    private final ServerStatusHolder serverStatusHolder;
    private final ScarServerProperties scarServerProperties;
    private final SsoProperties ssoProperties;
    private final ConfigurationReader configurationReader;
    private final ConfigurationWriter configurationWriter;
    private final OwnerWriter ownerWriter;
    private final SamVersionCheckService samVersionCheckService;

    public ServerConfigurationResponse getConfiguration() {
        return ConfigurationTransformer.from((ScarServerProperties)this.scarServerProperties, (SsoProperties)this.ssoProperties);
    }

    public MutableProperties createAndSaveConfiguration(SamAccountCredentials accountConfig, String password) {
        MutableProperties.ScarProperties scar = new MutableProperties.ScarProperties();
        scar.setMode(ApplicationMode.INITIALIZED);
        scar.setConnectionType(ApplicationConnectionType.SINGLE_USER);
        scar.setSamUser(accountConfig);
        MutableProperties.ScaProperties sca = new MutableProperties.ScaProperties();
        sca.setScar(scar);
        MutableProperties config = new MutableProperties();
        config.setSca(sca);
        this.configurationWriter.write(config, DEFAULT_CONFIGURATION_LOCATION, DEFAULT_CONFIGURATION_BACKUP_LOCATION);
        this.ownerWriter.createOwnerAccount(accountConfig.getEmail(), password);
        LOGGER.info("Starting version check polling after successful initialization");
        try {
            this.samVersionCheckService.startPolling();
            LOGGER.debug("Version check polling started successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to start version check polling after initialization", (Throwable)e);
        }
        this.scarServerProperties.setMode(ApplicationMode.INITIALIZED);
        this.scarServerProperties.setConnectionType(ApplicationConnectionType.SINGLE_USER);
        return config;
    }

    public MutableProperties updateConfiguration(SamAccountCredentials accountConfig) {
        MutableProperties config = (MutableProperties)this.configurationReader.readUserConfiguration(DEFAULT_CONFIGURATION_LOCATION, MutableProperties.class).orElseThrow();
        Optional.of(config).map(MutableProperties::getSca).map(MutableProperties.ScaProperties::getScar).map(MutableProperties.ScarProperties::getSamUser).ifPresent(u -> {
            u.setId(accountConfig.getId());
            u.setSecretKey(accountConfig.getSecretKey());
            this.configurationWriter.write(config, DEFAULT_CONFIGURATION_LOCATION, DEFAULT_CONFIGURATION_BACKUP_LOCATION);
        });
        return config;
    }

    public void updateAuthenticationMode(ApplicationConnectionType connectionType, String samlMetadataUrl) {
        MutableProperties config = (MutableProperties)this.configurationReader.readUserConfiguration(DEFAULT_CONFIGURATION_LOCATION, MutableProperties.class).orElseThrow();
        boolean update = false;
        MutableProperties.ScarProperties scarProps = config.getSca().getScar();
        if (!scarProps.getConnectionType().equals((Object)connectionType)) {
            SamAccountCredentials samUser;
            scarProps.setConnectionType(connectionType);
            if (ApplicationConnectionType.SAML_USER.equals((Object)connectionType)) {
                SamlProperties samlConfig = new SamlProperties();
                samlConfig.setMetadataLocation(samlMetadataUrl);
                scarProps.setSaml(samlConfig);
            }
            if (ApplicationConnectionType.MULTI_USER.equals((Object)connectionType) && (samUser = scarProps.getSamUser()) != null) {
                this.ownerWriter.ensureOwnerAccount(samUser.getEmail(), samUser.getSecretKey());
            }
            update = true;
        } else if (ApplicationConnectionType.SAML_USER.equals((Object)connectionType) && !samlMetadataUrl.equals(scarProps.getSaml().getMetadataLocation())) {
            scarProps.getSaml().setMetadataLocation(samlMetadataUrl);
            update = true;
        }
        if (update) {
            this.configurationWriter.write(config, DEFAULT_CONFIGURATION_LOCATION, DEFAULT_CONFIGURATION_BACKUP_LOCATION);
            this.restartServer();
        }
    }

    private void restartServer() {
        this.serverStatusHolder.setStatus(ServerStatusHolder.ServerStatus.RESTARTING);
        this.scarApplication.restart();
    }

    @Generated
    public ApplicationService(SCArApplication scarApplication, ServerStatusHolder serverStatusHolder, ScarServerProperties scarServerProperties, SsoProperties ssoProperties, ConfigurationReader configurationReader, ConfigurationWriter configurationWriter, OwnerWriter ownerWriter, SamVersionCheckService samVersionCheckService) {
        this.scarApplication = scarApplication;
        this.serverStatusHolder = serverStatusHolder;
        this.scarServerProperties = scarServerProperties;
        this.ssoProperties = ssoProperties;
        this.configurationReader = configurationReader;
        this.configurationWriter = configurationWriter;
        this.ownerWriter = ownerWriter;
        this.samVersionCheckService = samVersionCheckService;
    }

    static {
        String defaultPath = (String)SCArApplication.defaultResourceLocation(Path::toString);
        DEFAULT_CONFIGURATION_LOCATION = Paths.get(defaultPath, "scar.yml");
        DEFAULT_CONFIGURATION_BACKUP_LOCATION = Paths.get(defaultPath, "scar.yml.bck");
    }
}

