/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.application.ioc;

import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.configuration.SsoProperties;
import com.castsoftware.sca.scar.server.application.handler.ConfigurationReader;
import com.castsoftware.sca.scar.server.application.handler.ConfigurationWriter;
import com.castsoftware.sca.scar.server.application.ioc.BaseWebClientSupplier;
import com.castsoftware.sca.scar.server.application.launcher.ConfigurationMigration;
import com.castsoftware.sca.scar.server.application.launcher.ConfigurationMigrationLauncher;
import com.castsoftware.sca.scar.server.application.service.ApplicationService;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.Launcher;
import com.castsoftware.sca.scar.server.autoconfiguration.component.application.SCArApplication;
import com.castsoftware.sca.scar.server.core.component.ServerStatusHolder;
import com.castsoftware.sca.scar.server.sam.service.SamVersionCheckService;
import com.castsoftware.sca.scar.server.user.handler.OwnerWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Configuration
public class ApplicationIOC {
    @Bean
    public BaseWebClientSupplier webClientSupplier(ApplicationContext applicationContext) {
        return () -> (WebClient.Builder)applicationContext.getBean(WebClient.Builder.class);
    }

    @Bean
    public Yaml yaml() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        return new Yaml(dumperOptions);
    }

    @Bean
    public ConfigurationReader configurationReader(Yaml yaml) {
        return new ConfigurationReader(yaml);
    }

    @Bean
    public ConfigurationWriter configurationWriter(ObjectMapper objectMapper, Yaml yaml) {
        return new ConfigurationWriter(objectMapper, yaml);
    }

    @Bean
    public Launcher configurationMigrationLauncher(List<ConfigurationMigration> migrations) {
        return new ConfigurationMigrationLauncher(migrations);
    }

    @Bean
    public ApplicationService applicationService(SCArApplication scarApplication, ServerStatusHolder serverStatusHolder, ScarServerProperties scarServerProperties, SsoProperties ssoConfiguration, ConfigurationReader configurationReader, ConfigurationWriter configurationWriter, OwnerWriter ownerWriter, SamVersionCheckService samVersionCheckService) {
        return new ApplicationService(scarApplication, serverStatusHolder, scarServerProperties, ssoConfiguration, configurationReader, configurationWriter, ownerWriter, samVersionCheckService);
    }
}

